<?php

use App\CPU\Helpers;
use Illuminate\Support\Facades\App;
use App\Model\BusinessSetting;

if(!function_exists('translate')) {
    function  translate($key)
    {
        $local = Helpers::default_lang();
        App::setLocale($local);

        try {
            $lang_array = include(base_path('resources/lang/' . $local . '/messages.php'));
            $processed_key = ucfirst(str_replace('_', ' ', Helpers::remove_invalid_charcaters($key)));
            $key = Helpers::remove_invalid_charcaters($key);
            if (!array_key_exists($key, $lang_array)) {
                $lang_array[$key] = $processed_key;
                $str = "<?php return " . var_export($lang_array, true) . ";";
                file_put_contents(base_path('resources/lang/' . $local . '/messages.php'), $str);
                $result = $processed_key;
            } else {
                $result = __('messages.' . $key);
            }
        } catch (\Exception $exception) {
            $result = __('messages.' . $key);
        }

        return $result;
    }
}



if (!function_exists('rank_name')) {
    function rank_name($key)
    {
        if ($key == 1) {
            return 'Sales Executive';
        } elseif ($key == 2) {
            return 'Marketing Executive';
        } elseif ($key == 3) {
            return 'AGM';
        } elseif ($key == 4) {
            return 'GM';
        }elseif ($key == 5) {
            return 'Director';
        }else{
            return ' ';
        }
    }
}

if (!function_exists('dealer_type')) {
    function dealer_type($key)
    {
       $dealer_type =  DB::table('users')->where('id',$key)->first()->account_type;
        if ($dealer_type == 1) {
            return 'Outlate';
        } elseif ($dealer_type == 2) {
            return 'Dealer';
        } elseif ($dealer_type == 3) {
            return 'Depo ';
        } elseif ($dealer_type == 4) {
            return 'Co-founder';
        } else{
            return 'Online Agent';
        }
    }
}

if (!function_exists('account_type')) {
    function account_type($key)
    {
        // Member/classic/ premium/ platinum
        $dealer_type =  DB::table('users')->where('id',$key)->first()->pack_id;
        if ($dealer_type == 1) {
            return 'Member';
        } elseif ($dealer_type == 2) {
            return 'Classic';
        } elseif ($dealer_type == 3) {
            return 'Premium';
        } elseif ($dealer_type == 4) {
            return 'Platinum';
        } else{
            return 'Member';
        }
    }
}



if (!function_exists('numberConvert')) {
  function numberConvert($number)
  {

    if($number == 1){
    //  return 'Direct Sponsor';
    }
      if (in_array(($number % 100), range(11, 13))) {
          $suffix = 'th';
      } else {
          switch ($number % 10) {
              case 1:
                  $suffix = 'st';
                  break;
              case 2:
                  $suffix = 'nd';
                  break;
              case 3:
                  $suffix = 'rd';
                  break;
              default:
                  $suffix = 'th';
                  break;
          }
      }

      return $number . $suffix;
  }
}


if (!function_exists('package_name')) {
    function package_name($key)
    {
        return DB::table('invest_manages')->where('id',$key)->first()->title??'-';
    }
}


if (!function_exists('payment_method_name')) {
    function payment_method_name($key)
    {
        return DB::table('payment_gateway')->where('id',$key)->first(['method_name','image']);
    }
}


if (!function_exists('charges')) {
    function charges($key)
    {
        return   BusinessSetting::where('type', $key)->first()->value;
    }
}



