<?php

namespace App\Http\Controllers\Admin;

use App\CPU\Helpers;
use App\Http\Controllers\Controller;
use App\Model\Order;
use App\User;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Model\Subscription;
use App\Model\BusinessSetting;
use Rap2hpoutre\FastExcel\FastExcel;
use App\CPU\ImageManager;


class CustomerController extends Controller
{


    public function customer_list(Request $request)
    {

        $query_param = [];
        $search = $request['search'];
        if ($request->has('search')) {
            $key = explode(' ', $request['search']);
            $customers = User::where('account_type',0)->with(['orders'])
                ->where(function ($q) use ($key) {
                    foreach ($key as $value) {
                        $q->Where('user_id', 'like', "%{$value}%")
                            ->orWhere('phone', 'like', "%{$value}%")
                            ->orWhere('id', 'like', "%{$value}%");
                            //->orWhere('email', 'like', "%{$value}%");
                    }
                });
            $query_param = ['search' => $request['search']];
        } else {
            $customers = User::where('account_type',0);with(['orders']);
        }
        $customers = $customers->latest()->paginate(Helpers::pagination_limit())->appends($query_param);
        return view('admin-views.customer.list', compact('customers', 'search'));
    }

    public function dealer_list(Request $request)
    {

        $query_param = [];
        $search = $request['search'];
        if ($request->has('search')) {
            $key = explode(' ', $request['search']);
            $customers = User::whereIn('account_type',[1,2,3,4,5])
                ->where(function ($q) use ($key) {
                    foreach ($key as $value) {
                        $q->Where('user_id', 'like', "%{$value}%")
                            ->orWhere('phone', 'like', "%{$value}%")
                            ->orWhere('id', 'like', "%{$value}%");
                            //->orWhere('email', 'like', "%{$value}%");
                    }
                });
            $query_param = ['search' => $request['search']];
        } else {
            $customers = User::whereIn('account_type',[1,2,3,4,5]);
        }


        $customers = $customers->latest()->paginate(Helpers::pagination_limit())->appends($query_param);
        return view('admin-views.customer.dealer_list', compact('customers', 'search'));
    }

    public function dealer_create()
    {
        return view('admin-views.customer.dealer_create');
    }


    public function dealer_store(Request $request)
    {
           $request->validate([
            'name' => 'required',
            'role_id' => 'required',
            'image' => 'required',
            'email' => 'required|email|unique:users',

            'password'=>'required',
            'phone'=>'required'

        ], [
            'name.required' => 'Role name is required!',
            'role_name.required' => 'Role id is Required',
            'email.required' => 'Email id is Required',
            'image.required' => 'Image is Required',

        ]);

        if ($request->role_id == 1) {
            //Toastr::warning('Access Denied!');
            //return back();
        }


        $exists = DB::table('users')->where('user_id', $request->user_id)->exists();

        if ($exists) {
            Toastr::error('User ID already exists!');
            return back();
        }

        $Referexists = DB::table('users')->where('user_id', $request->refer)->exists();

        if (!$Referexists) {
            Toastr::error('Dealer Refer  is not exists!');
            return back();
        }


        DB::table('users')->insert([
            'name' => $request->name,
            'f_name' => $request->name,
            'phone' => $request->phone,
            'email' => $request->email,
            'user_id' => $request->user_id,
            'account_type' => $request->role_id,
            'sponser' => $request->dealer_refer,
            'id_type' => 2,
            'password_plain' => $request->password,
            'password' => bcrypt($request->password),
           // 'status'=>1,
            'image' => ImageManager::upload('admin/', 'png', $request->file('image')),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        Toastr::success('Employee added successfully!');

       return redirect('admin/customer/dealer-list');
    }

    public function status_update(Request $request)
    {
        User::where(['id' => $request['id']])->update([
            'is_active' => $request['status']
        ]);

        DB::table('oauth_access_tokens')
            ->where('user_id', $request['id'])
            ->delete();

        return response()->json([], 200);
    }

    public function dealer_status_update($id,$type)
    {
        User::where(['id' => $id])->update([
            'account_type' => $type
        ]);

        Toastr::success('Customer dealer designation successfully updated!');
        return back();
    }

    public function view(Request $request, $id)
    {

        $customer = User::find($id);
        if (isset($customer)) {
            $query_param = [];
            $search = $request['search'];
            $orders = Order::where(['customer_id' => $id]);
            if ($request->has('search')) {

                $orders = $orders->where('id', 'like', "%{$search}%");
                $query_param = ['search' => $request['search']];
            }
            $orders = $orders->latest()->paginate(Helpers::pagination_limit())->appends($query_param);
            return view('admin-views.customer.customer-view', compact('customer', 'orders', 'search'));
        }
        Toastr::error('Customer not found!');
        return back();
    }

    public function update(Request $request)
    {

         if ($request->f_name) {
             $request->validate([
                'f_name' => 'required',
                'l_name' => 'required',
                'phone' => 'required',
            ], [
                'f_name.required' => 'First name is required',
                'l_name.required' => 'Last name is required',
                'phone.required' => 'phone  is required',
            ]);

             $userDetails = [
                'f_name' => $request->f_name,
                'l_name' => $request->l_name,
                'phone' => $request->phone,
            ];

            User::where(['id' => $request->id])->update($userDetails);
         }

        if ($request->email) {
            $request->validate([
                    'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            ]);

            User::where(['id' => $request->id])->update([
                'email' => $request->email,
            ]);
        }



         if ($request->user_id) {
            $exist = User::where(['user_id' => $request->user_id])->first();

            if(empty(!$exist)){
                 Toastr::error(translate('sorry this user id is exist'));
                 return back();
            }


            try {
                  DB::beginTransaction();

                    $customer = User::find($request->id);


                    User::where(['sponser' => $customer->user_id])->update(['sponser' => $request->user_id]);
                    User::where(['placement_id' => $customer->user_id])->update(['placement_id' => $request->user_id]);
                    User::where(['id' => $request->id])->update(['user_id' => $request->user_id]);
                DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();

            }


        }

       if ($request->password) {
            $request->validate([
                'password' => ['required', 'string', 'min:6', 'max:12'],
            ]);

            User::where(['id' => $request->id])->update([
                'password' => bcrypt($request->password),
                'password_plain' => $request->password,
            ]);
       }

       if ($request->transpassword) {
            $request->validate([
                'transpassword' => ['required', 'string', 'min:6', 'max:12'],
            ]);

            User::where(['id' => $request->id])->update([
                'trans_password' => bcrypt($request->transpassword),
            ]);
       }


        Toastr::info(translate('updated_successfully'));
        return back();


    }

    public function edit(Request $request, $id)
    {

        $customer = User::find($id);
        if (isset($customer)) {

            return view('admin-views.customer.customer-edit', compact('customer'));
        }
        Toastr::error('Customer not found!');
        return back();
    }

    public function delete($id)
    {
        $customer = User::find($id);
        $customer->delete();
        Toastr::success('Customer deleted successfully!');
        return back();
    }

    public function subscriber_list(Request $request)
    {
        $query_param = [];
        $search = $request['search'];
        if ($request->has('search')) {
            $subscription_list = Subscription::where('email','like', "%{$search}%");

            $query_param = ['search' => $request['search']];
        } else {
        $subscription_list = new Subscription;
        }
        $subscription_list = $subscription_list->latest()->paginate(Helpers::pagination_limit())->appends($query_param);
        return view('admin-views.customer.subscriber-list',compact('subscription_list','search'));
    }

    public function customer_settings()
    {
        $data = BusinessSetting::where('type','like','wallet_%')->orWhere('type','like','loyalty_point_%')->get();
        $data = array_column($data->toArray(), 'value','type');

        return view('admin-views.customer.customer-settings', compact('data'));
    }

    public function customer_update_settings(Request $request)
    {
        if (env('APP_MODE') == 'demo') {
            Toastr::info(\App\CPU\translate('update_option_is_disable_for_demo'));
            return back();
        }

        $request->validate([
            'add_fund_bonus'=>'nullable|numeric|max:100|min:0',
            'loyalty_point_exchange_rate'=>'nullable|numeric',
        ]);
        BusinessSetting::updateOrInsert(['type' => 'wallet_status'], [
            'value' => $request['customer_wallet']??0
        ]);
        BusinessSetting::updateOrInsert(['type' => 'loyalty_point_status'], [
            'value' => $request['customer_loyalty_point']??0
        ]);
        BusinessSetting::updateOrInsert(['type' => 'wallet_add_refund'], [
            'value' => $request['refund_to_wallet']??0
        ]);
        BusinessSetting::updateOrInsert(['type' => 'loyalty_point_exchange_rate'], [
            'value' => $request['loyalty_point_exchange_rate']??0
        ]);
        BusinessSetting::updateOrInsert(['type' => 'loyalty_point_item_purchase_point'], [
            'value' => $request['item_purchase_point']??0
        ]);
        BusinessSetting::updateOrInsert(['type' => 'loyalty_point_minimum_point'], [
            'value' => $request['minimun_transfer_point']??0
        ]);

        Toastr::success(\App\CPU\translate('customer_settings_updated_successfully'));
        return back();
    }

    public function get_customers(Request $request){

        if(!empty($request->q)){
            $key = explode(' ', $request['q']);
            $data = User::where('id', '!=', 0)
                ->where(function ($q) use ($key) {
                    foreach ($key as $value) {
                        $q->orWhere(function ($query) use ($value) {
                            $query->where('user_id', 'like', "%{$value}%");
                        });
                    }
                })
                ->limit(10)
                ->get([DB::raw('id, CONCAT(user_id) as text')]);
            return response()->json($data);
       }

       if($request->all){
            $data = User::where('id','!=',0)->orderby('id','desc')->limit(50)->get([DB::raw('id, CONCAT(user_id) as text')]);
             return response()->json($data);
       }

        // $key = explode(' ', $request['q']);
        // $data = User::where('id','!=',0)->
        // where(function ($q) use ($key) {
        //     foreach ($key as $value) {
        //         $q->orWhere('f_name', 'like', "%{$value}%")
        //         ->orWhere('l_name', 'like', "%{$value}%")
        //         ->orWhere('phone', 'like', "%{$value}%");
        //     }
        // })
        // ->limit(8)
        // ->get([DB::raw('id, CONCAT(f_name, " ", l_name, " (", phone ,")") as text')]);
        // if($request->all) $data[]=(object)['id'=>false, 'text'=>trans('messages.all')];
        // return response()->json($data);
    }


    /**
     * Export product list by excel
     * @param Request $request
     * @param $type
     */
    public function export(Request $request){

        if ($request->has('search')) {
            $key = explode(' ', $request['search']);
            $customers = User::with(['orders'])
                ->where(function ($q) use ($key) {
                    foreach ($key as $value) {
                        $q->orWhere('f_name', 'like', "%{$value}%")
                            ->orWhere('l_name', 'like', "%{$value}%")
                            ->orWhere('phone', 'like', "%{$value}%")
                            ->orWhere('email', 'like', "%{$value}%");
                    }
                });
        } else {
            $customers = User::with(['orders']);
        }
        $items = $customers->latest()->get();

        return (new FastExcel($items))->download('customer_list.xlsx');
    }
}
