<?php

namespace App\Http\Controllers\Admin;

use App\CPU\Helpers;
use App\CPU\ImageManager;
use App\Http\Controllers\Controller;
use App\Model\Admin;
use App\Model\Brand;
use App\User;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Model\Translation;
use Rap2hpoutre\FastExcel\FastExcel;

class PaymentMethodAffiliateController extends Controller
{

    
    function index(Request $request)
    {
        $search      = $request['search'];
        $query_param = $search ? ['search' => $request['search']] : '';
        $list =  DB::table('payment_gateway')->latest()->paginate(Helpers::pagination_limit());
       
        return view('admin-views.payment-method-affiliate.list', compact('list', 'search'));
    }

    public function add_new()
    {
        $br = DB::table('payment_gateway')->latest()->paginate(Helpers::pagination_limit());
        $language=\App\Model\BusinessSetting::where('type','pnc_language')->first();
        $language = $language->value ?? null;
        $default_lang = 'en';

        return view('admin-views.payment-method-affiliate.add-new', compact('br', 'language', 'default_lang'));
    }

    public function store(Request $request)
    {
 
        $request->validate([
            'method_name' => 'required',
            'account_no' => 'required',
        ], [
            'method_name.required'   => 'Peyment Method name is required!',          
        ]);
    
        if(empty($request->id)){
            
           $image = ImageManager::upload('brand/', 'png', $request->file('image'));
     
           DB::table('payment_gateway')->Insert([           
                'image' => $image,
                'method_name' => $request->method_name,
                'account_no' => $request->account_no,
                'min' => $request->min,
                'max' => $request->max,
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ]);

            Toastr::success('Payment Method Added added successfully!');
            return back();

        }else{

            $first_find  = DB::table('payment_gateway')->where('id',$request->id)->first();
           
            if ($request->has('image')) {
                $image = ImageManager::update('brand/', $first_find->image, 'png', $request->file('image'));
             } else {
               $image = DB::table('payment_gateway')->where('id',$request->id)->first()->image;
             }

            DB::table('payment_gateway')->where('id',$request->id)->update([           
                'image' => $image,
                'method_name' => $request->method_name,
                'account_no' => $request->account_no,
                'min' => $request->min,
                'max' => $request->max,
                'status' => 1,              
                'updated_at' => now()
            ]);

            Toastr::success('Payment Method Added added successfully!');
            return back();

        }
      
    }


    public function edit($id)
    {
        $b = DB::table('payment_gateway')->where('id', $id)->first(); 
        return view('admin-views.payment-method-affiliate.edit', compact('b'));
       
    }


    /**
     * Export brand list by excel
     * @return string|\Symfony\Component\HttpFoundation\StreamedResponse
     * @throws \Box\Spout\Common\Exception\IOException
     * @throws \Box\Spout\Common\Exception\InvalidArgumentException
     * @throws \Box\Spout\Common\Exception\UnsupportedTypeException
     * @throws \Box\Spout\Writer\Exception\WriterNotOpenedException
     */
    public function export(){
        $brands = Brand::withCount('brandAllProducts')
            ->with(['brandAllProducts'=> function($query){
                $query->withCount('order_details');
            }])->orderBy('id', 'DESC')->get();

        $data = array();
        foreach($brands as $brand){
            $data[] = array(
                'Brand Name'      => $brand->name,
                'Total Product'   => $brand->brand_all_products_count,
                'Total Order' => $brand->brandAllProducts->sum('order_details_count'),
            );
        }

        return (new FastExcel($data))->download('brand_list.xlsx');
    }

   
    public function update(Request $request)
    {
       
        $request->validate([
            'name.0' => 'required|unique:brands,name,'.$id,
        ], [
            'name.0.required'   => 'Brand name is required!',
            'name.0.unique'     => 'The brand has already been taken.',
        ]);

        $brand = Brand::find($id);
        $brand->name = $request->name[array_search('en', $request->lang)];
        if ($request->has('image')) {
            $brand->image = ImageManager::update('brand/', $brand['image'], 'png', $request->file('image'));
         }
        $brand->save();
        foreach ($request->lang as $index => $key) {
            if ($request->name[$index] && $key != 'en') {
                Translation::updateOrInsert(
                    ['translationable_type' => 'App\Model\Brand',
                        'translationable_id' => $brand->id,
                        'locale' => $key,
                        'key' => 'name'],
                    ['value' => $request->name[$index]]
                );
            }
        }

        Toastr::success('updated successfully!');
        return back();
    }

    public function status_update(Request $request)
    {

        $brand = DB::table('payment_gateway')->where('id', $request['id'])->first();

        if ($brand) {
            // Update the 'status' field.
            DB::table('payment_gateway')
                ->where('id', $request['id'])
                ->update(['status' => $request['status']]);
            
            // Fetch the updated record.
            $brand = DB::table('payment_gateway')->find($request['id']);
            
            return response()->json([
                'success' => 1,
            ], 200);
        } else {
            return response()->json([
                'success' => 0,
            ], 200);
        }

       
    }

    public function delete(Request $request)
    {
        $translation = Translation::where('translationable_type','App\Model\Brand')
                                    ->where('translationable_id',$request->id);
        $translation->delete();
        $brand = Brand::find($request->id);
        ImageManager::delete('/brand/' . $brand['image']);
        $brand->delete();
        return response()->json();
    }

    
    public function cashin_list(Request $request)
    {
        $query = DB::table('cash_in');
      
        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }
      
        if ($request->has('search')) {  
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                  $q->where('trx_id',$search)
              //  $q->where('trx_id', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);
        $data['search']      = $request['search'];
        return view('admin-views.cashin-approve.cashin_list', $data);
      
    }


    public function cashin_status_update($id)
    {
        $cash_in_list = DB::table('cash_in')->where('id', $id)->where('status', 0)->first();
        if(!empty($cash_in_list)){
        $user_list = User::where('id', $cash_in_list->user_id)->first();

      
            // Update the 'status' field.
            DB::table('cash_in')
                ->where('id', $id)
                ->update(['status' => 1,'updated_at' => now()]);
        
            User::where('id',$user_list->id)->update([           
                'register_wallet' => $user_list->register_wallet +  $cash_in_list->amount
            ]);

        Toastr::success('Deposit successfully!');
        return back();
       }else{
        Toastr::error('This is approved');
        return back();
       }

    }


}
