<?php

namespace App\Http\Controllers\Admin;

use App\CPU\BackEndHelper;
use App\Http\Controllers\Controller;
use App\User;
use App\Model\AdminWallet;
use App\Model\SellerWallet;
use App\Model\WithdrawRequest;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WithdrawController extends Controller
{
    public function update(Request $request, $id)
    {
        $w = WithdrawRequest::find($id);
        if ($w->approved1 != 1) {
            SellerWallet::where('seller_id', $w->seller_id)->increment('withdrawn', $w->amount);
        }
        $w->approved = $request['approved'];
        $w->transaction_note = $request['note'];
        $w->save();
        Toastr::success('Updated!');
        return redirect()->back();
    }


    public function status_filter(Request $request)
    {
        session()->put('withdraw_status_filter', $request['withdraw_status_filter']);
        return response()->json(session('withdraw_status_filter'));
    } 

    
    public function withdraw_list(Request $request)
    {
        $query = WithdrawRequest::join('payment_gateway','payment_gateway.id','=','withdraw_requests.withdrawal_method_id');
        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('withdraw_requests.created_at', [$fromDate, $toDate]);
        }
      
        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('withdraw_requests.created_at', 'like', "%$search%");
            });
        }
        $data['withdraw_req'] = $query->select('withdraw_requests.*','withdraw_requests.id as wid','payment_gateway.id','payment_gateway.method_name')->orderBy('withdraw_requests.created_at', 'desc')->paginate(40);
     
    
        return view('admin-views.customer.wallet.withdraw_list', $data);
    }

    
    public function status_update($type,$id)
    {
        $w = WithdrawRequest::find($id);
        if ($type == 2) {
            User::where('id', $w->seller_id)->increment('income_wallet', $w->withouth_charge);
        }
        $w->approved = $type;     
        $w->save();
        Toastr::success('Successfully updated!');
      
      
        return redirect()->back();
    }



}
