<?php
namespace App\Http\Controllers\CronJob;

use App\Http\Controllers\Controller;
use App\CPU\Helpers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use DB;
use App\User;

class RankFIndController extends Controller
{

    public function rank_find()
    {
        $current_date = date('Y-m-d');
        $cron_exists = DB::table('crone_records')->where('date', $current_date)->where('type', 'rank_check')->first();

        if (!$cron_exists) {
            $users = User::select('id', 'user_id', 'rank', 'income_wallet', 'sponser_sales')->where('account_type', 0)->get();

            ///dd($users);

            foreach ($users as $user) {
                $sales        = $user->sponser_sales;
                $current_rank = $user->rank;

                if ($sales >= 50000000 && $current_rank < 5) {
                    $rank = 5;
                    $reward = 'Flat + Foreign Tour';
                } elseif ($sales >= 20000000 && $current_rank < 4) {
                    $rank = 4;
                    $reward = 'Private Car + Foreign Tour';
                } elseif ($sales >= 10000000 && $current_rank < 3) {
                    $rank = 3;
                    $reward = 'Motorbike';
                } elseif ($sales >= 5000000 && $current_rank < 2) {
                    $rank = 2;
                    $reward = 'Cox’s Bazar';
                } elseif ($sales >= 1000000 && $current_rank < 1) {
                    $rank = 1;
                    $reward = 'Smart Phone';

                } else {
                    continue;
                    // No rank upgrade
                }

                // Check if already given this rank reward
                $already_ranked = DB::table('royal_rank_history')
                                    ->where('rank', $rank)
                                    ->where('user', $user->id)
                                    ->exists();

                if (!$already_ranked) {
                    User::where('id', $user->id)->update(['rank' => $rank]);
                    $this->royal_rank_history($reward, $user->id, $rank);
                    $this->club_bonus_store(0, $user->id, $rank); // Optional: update bonus amount if needed
                }
            }

            DB::table('crone_records')->insert([
                'type' => 'rank_check',
                'date' => $current_date,
                'updated_at' => now(),
            ]);
        }
    }


   public function royal_rank_history($bonus,$userid,$type){
       DB::table('royal_rank_history')->insert([
            'user' => $userid,
            'rank' => $type,
            'rank_bonus' => $bonus,
            'status'     => 'pending',
            'date'       => date('Y-m-d'),
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

   public function monthly_club_distribute($amount,$userid,$type){
        DB::table('monthly_club_distribute')->insert([
            'userid'       => $userid,
            'amount'       => $amount,
            'type'         => $type,
            'created_at'   => now(),
            'updated_at'   => now(),
        ]);
    }



   public function club_bonus_store($amount,$userid,$type){
       DB::table('club_bonus_ex')->insert([
            "amount"=>$amount,
            "type"=>$type,
            "userid"=>$userid,
            'created_at'=> now(),
            'updated_at'=> now()
        ]);
    }


















}
