<?php

namespace App\Http\Controllers\Web;
use App\CPU\ImageManager;
use App\Http\Controllers\Controller;
use App\Model\Admin;
use App\Model\Brand;
use App\Model\WithdrawRequest;
use App\User;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Hash; 
use Redirect; 

class BalanceController extends Controller
{
    public function index(Request $request)
    {               
        $report =   DB::table('balance_transaction')->where('from_id',auth('customer')->user()->id)->whereIn('type', array('1','2'))->orderBy('id', 'desc')->paginate(10);     
        return view('member-panel.balance.list', compact('report'));
    }  

    public function transfer()
    {               
        $report =   DB::table('balance_transaction')->where('from_id',auth('customer')->user()->id)->whereIn('type', array('1','2'))->orderBy('id', 'desc')->paginate(10);     
        return view('member-panel.balance.transfer', compact('report'));
    }    

    public function received()
    {               
        $report =   DB::table('balance_transaction')->where('to_id',auth('customer')->user()->id)->whereIn('type', array('1','2'))->orderBy('id', 'desc')->paginate(10);     
        return view('member-panel.balance.received', compact('report'));
    }  

  
    public function store(Request $request)
    {       
        $user_id  = $request->user_id;
        $user     = User::where('user_id',  $user_id)->first();
        $User   = User::find(auth('customer')->user()->id);
          
        if(499 > $request->final_amount) {
            Toastr::error('Sorry! Minimum amount is 500');
            return back();  
        }
         
        if ((Hash::check($request->password, $User->trans_password))) {         
            if($request->wallet_type == 1){
                // $request->validate([                    
                //     'amount'      => 'required|numeric|min:1',
                // ], [                   
                //     'amount.required' => 'Amount is wrong!',
                // ]);

                if($User->income_wallet < $request->final_amount) {
                    Toastr::error('Sorry! Balance is insufficiant!');
                    return back();  
                }
             
                $net_amount = $User->income_wallet -  $request->final_amount;
                DB::table('users')->where('id', auth('customer')->user()->id)->update([
                    'income_wallet'       => $net_amount,              
                    'updated_at' => now(),
                ]); 

                $amount = $request->final_amount ;
                DB::table('users')->where('id',  $User->id)->update([
                    'register_wallet'=> $User->register_wallet + $amount,              
                    'updated_at'    => now(),
                ]);

                DB::table('balance_transaction')->insert([
                    'from_id'       => auth('customer')->user()->id,
                    'to_id'         => auth('customer')->user()->id,
                    'amount'        => $amount,
                    'type'          => 1,
                    'created_at'    => now(),
                    'updated_at'    => now(),
                ]);

                Toastr::success('Amount successfully moved!');
                return back();

            }elseif($request->wallet_type == 2){
                 if(!empty($user) && ($User->id != $user->id) ){
                     
                        // $request->validate([
                        //     'user_id' => 'required',
                        //     'amount'      => 'required|numeric|min:1',
                        // ], [
                        //     'user_id.required' => 'User name is required!',
                        //     'amount.required' => 'Amount is wrong!',
                        // ]);
    

                        if($User->register_wallet < $request->final_amount) {
                            Toastr::error('Sorry! Balance is insufficiant!');
                            return back();  
                        }
                        
                        $ded_amount    =  $request->final_amount;
                        DB::table('users')->where('id', auth('customer')->user()->id)->update([
                             'register_wallet'   => $User->register_wallet - $ded_amount,            
                            'updated_at' => now(),
                        ]); 

                        $reg_amount    =  $request->final_amount;
                     //   $reg_amount     = $user->register_wallet + ($request->final_amount - ($request->final_amount*2.5/100));
                        DB::table('users')->where('id',  $user->id)->update([
                            'register_wallet'   => $user->register_wallet + $reg_amount,              
                            'updated_at' => now(),
                        ]);

                        DB::table('balance_transaction')->insert([
                            'from_id'       => auth('customer')->user()->id,
                            'to_id'         => $user->id,
                            'amount'        => $request->final_amount,
                            'type'          => 2,
                            'created_at'    => now(),
                            'updated_at'    => now(),
                        ]);

                        Toastr::success('amount successfully transfered!');
                        return back();
                } else {
                    Toastr::error('User id is wrong!');
                    return back();  
                }      

            } 
            
            } else {
                if(empty(auth('customer')->user()->trans_password)){
                     Toastr::warning('Pleas set your Transaction password first! From account > profile > set Transaction Password');
                     return back();        
                }
                
                Toastr::error('Sorry! Transaction passowrd is wrong!');
                return back();  
            } 

    }


    public function delete(Request $request)
    {
        $br = DB::table('balance_transaction')->find($request->id);    
        $br->delete();
        return response()->json();
    } 

    public function user_search(Request $request)
    { 
        $user = User::where('user_id',$request->user_id)->where('id','!=',auth('customer')->user()->id)->first();

        if($user){
            echo 1;  exit();
        }else{
            echo 0; exit();      
        }
    }

    public function cashin_list(Request $request)
    {               
        $query = DB::table('cash_in')->where('user_id',auth('customer')->user()->id);
        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }
      
        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }
        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);
        return view('member-panel.cashin.list',$data);
    }   

    public function cashin()
    {               
        $report  = DB::table('cash_in')->where('user_id',auth('customer')->user()->id)->orderBy('id', 'desc')->paginate(20);     
        $payment = DB::table('payment_gateway')->where('status',1)->orderBy('id', 'asc')->get();     
        return view('member-panel.cashin.cashin', compact('report','payment'));
    }    
    
    
    public function cashin_store(Request $request)
    {       
      
        if( $request->final_amount < 1){
            Toastr::error('Invalid Amount!');
            return back();
        }
        
        if( empty($request->method_id) ){
            Toastr::error('Please select deposit method');
            return back();
        }
       
        $User   = User::find(auth('customer')->user()->id);
        $image  = ImageManager::upload('brand/',  'png', $request->file('image'));    
       
        DB::table('cash_in')->insert([
            'user_id'       => auth('customer')->user()->id,
            'amount'        => $request->final_amount,
            'method_id'     => $request->method_id,
            'trx_id'        => $request->trx_id,
            'comment'       => $request->comment,
            'image'         => $image,
            'status'        => 0,
            'created_at'    => now(),
            'updated_at'    => now(),
        ]);

        Toastr::success('Deposit successfull, Please wait for admin approval');
        return Redirect::to('/member/cashin-list');
    }


   
    public function withdraw_list(Request $request)
    {               
        $query = WithdrawRequest::where('seller_id',auth('customer')->user()->id)->join('payment_gateway','payment_gateway.id','=','withdraw_requests.withdrawal_method_id');
        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('withdraw_requests.created_at', [$fromDate, $toDate]);
        }
      
        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('withdraw_requests.created_at', 'like', "%$search%");
            });
        }
        $data['report'] = $query->select('withdraw_requests.*','payment_gateway.id','payment_gateway.method_name')->orderBy('withdraw_requests.created_at', 'desc')->paginate(20);
        return view('member-panel.withdraw.list',$data);
    }   


    public function withdraw()
    {               
        $report  = WithdrawRequest::where('seller_id',auth('customer')->user()->id)->orderBy('id', 'desc')->paginate(20);     
        $payment = DB::table('payment_gateway')->where('status',1)->orderBy('id', 'asc')->get();     
        return view('member-panel.withdraw.withdraw', compact('report','payment'));
    }    


  
    
    public function withdraw_store(Request $request)
    {       
      
        if( $request->final_amount < 1){
            Toastr::error('Invalid Amount!');
            return back();
        }
            
        if( empty($request->method_id) ){
            Toastr::error('Please select withdraw method');
            return back();
        }
    
        if( $request->final_amount <= charges('minimum_withdraw')){
            Toastr::warning('Minumum Withdraw Amount '. charges('minimum_withdraw') );
            return back();
        }
        
        if( $request->final_amount > auth('customer')->user()->income_wallet){
            Toastr::warning('Sorry! Insufficaint Income balance');
            return back();
        }
        
        if (!Hash::check($request->trx_password, auth('customer')->user()->trans_password)) {    
            
            if(empty(auth('customer')->user()->trans_password)){
                 Toastr::warning('Pleas set your Transaction password first! From account > profile > set Transaction Password');
                return back();        
            }
            
            Toastr::warning('Sorry! Transaction password did not match!');
            return back();                 
        }
      
        $User   = User::find(auth('customer')->user()->id);
        $dataaaP['income_wallet']  = $User->income_wallet - $request->amount;      
        User::where('id', $User->id)->update($dataaaP); 
       
        WithdrawRequest::insert([
            'seller_id'       => auth('customer')->user()->id,
            'amount'               => $request->final_amount,
            'withouth_charge'        => $request->amount,
            'withdrawal_method_id'     => $request->method_id,         
            'account_no' => $request->account_no,
            'transaction_note'       => $request->comment,
           // 'approved'        => 0,
            'created_at'    => now(),
            'updated_at'    => now(),
        ]);
      
        Toastr::success('Withdraw successfull, Please wait for admin approval');
        return Redirect::to('/member/withdraw-list');
    }




}
