<?php

namespace App\Http\Controllers\Web;

use App\CPU\Helpers;
use App\CPU\ImageManager;
use App\Http\Controllers\Controller;
//use App\Traits\CommonTrait;
use App\User;
use Barryvdh\DomPDF\Facade as PDF;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use App\Model\Notification;
use App\Model\SupportTicket;
use App\Model\Admin;
use App\Model\Banner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use function App\CPU\translate;
//use App\CPU\Convert;
//use App\Model\ProductCompare;
use Session;
//use function React\Promise\all;
use Hash;
use Redirect;

class DashboardController extends Controller
{
    //use CommonTrait;

    public function dashboard(Request $request)
    {
        $data['email'] = auth('customer')->user()->email;
        $data['size']  = 40;
        $data['spon_com']  = DB::table('sponser_commission')->where('seller_id', auth('customer')->id())->sum('amount');
        $data['gen_com']   = DB::table('generation_commisions')->where('comment','Generation')->where('user_id', auth('customer')->id())->sum('amount');
        $data['matching']  = DB::table('matching_history')->where('userid',auth('customer')->user()->id)->sum('amount');
        $data['global_com']= DB::table('monthly_club_distribute')->where('userid',auth('customer')->user()->id)->sum('amount');
        $data['leadership']= DB::table('generation_commisions')->where('comment','Leadership')->where('user_id',auth('customer')->user()->id)->sum('amount');
        $data['upline']    = DB::table('upline_history')->where('userid',auth('customer')->user()->id)->sum('amount');
        $data['dealer']    = DB::table('dealer_commission')->where('seller_id',auth('customer')->user()->id)->sum('amount');
        $data['notice']    = Notification::where('status',1)->orderBy('id', 'desc')->first();
        $data['banners']   = Banner::where('banner_type','Member Banner')->where('published',1)->orderBy('id', 'desc')->latest()->paginate(6);
        return view('member-panel.system.dashboard', $data);
    }

    public function coming(Request $request)
    {
        $country_restrict_status = Helpers::get_business_settings('delivery_country_restriction');
        $data['customerDetail'] = User::where('id', auth('customer')->id())->first();
        return view('member-panel.system.coming', $data);
    }

    public function notices(Request $request)
    {
        $data['notice']    = Notification::where('status',1)->latest()->get();
        return view('member-panel.system.notice_list', $data);
    }


    public function notice_details($id)
    {
        $data['notice']    = Notification::where('id',$id)->first();
        return view('member-panel.system.notice_details', $data);
    }

    public function investment(Request $request)
    {
        $data['package']        = DB::table('invest_manages')->orderBy('id','asc')->get();
        return view('member-panel.system.investment',$data);
    }


    public function investment_start(Request $request)
    {

        $user = User::find(auth('customer')->user()->id);
        $pack = DB::table('invest_manages')->where('id', $request->pack_id)->first();

        // Check if package exists
        if (!$pack) {
            Toastr::error('Invalid investment package.');
            return redirect('/member/investment');
        }

        // Check balance
        if ($user->register_wallet < $pack->amount) {
            Toastr::error('Balance insufficient. Please top up your wallet.');
            return redirect('/member/investment');
        }

        // Deduct balance
        DB::table('users')->where('id', $user->id)->decrement('register_wallet', $pack->amount);

        // Start investment
        DB::table('invest_return')->insert([
            'userid'        => $user->id,
            'pack_id'       => $pack->id,
            'return_count'  => $pack->days,
            'percent'       => $pack->percent,
            'amount'        => $pack->amount,
            'status'        => 0,
            'created_at'    => now(),
            'updated_at'    => now(),
        ]);

        $adminFund = Admin::find(1);

        Admin::where('id', $adminFund->id)->update([
            'cofounder'=> $pack->amount * 5 / 100 + $adminFund->cofounder,
            'rank_gift'=> $pack->amount * 3 / 100 + $adminFund->rank_gift,
            'salary'=> $pack->amount * 2 / 100 + $adminFund->salary,
        ]);

        $sponser = User::where('user_id', $user->sponser)->first();

        // sponsor commission
        $total_sv_point = $pack->amount;
        $dist_amount               = $total_sv_point * 7 / 100;
        $dataaaP['income_wallet']  = $sponser->income_wallet + $dist_amount ;
        $dataaaP['sponser_sales']  = $sponser->sponser_sales + $total_sv_point ;
        DB::table('users')->where('id', $sponser->id)->update($dataaaP);

        $dataq['type']        = 1;
        $dataq['amount']      = $dist_amount;
        $dataq['reg_amount']  = $total_sv_point;
        $dataq['main_id']     = $user->id; //seller id
        $dataq['seller_id']   = $sponser->id; //sponsor account
        $dataq['reg_id']      = $user->id; // new registration id
        DB::table('sponser_commission')->insert($dataq);
        // sponsor commission

        $this->generation_income_distribute($sponser->sponser, $user->id, $count = 1, $total_sv_point);


        Toastr::success('Investment started successfully!');
        return redirect('/member/investment-report');
    }

public function investment_report()
{
    $user = auth('customer')->user();

    // All investments of the user
    $investments = DB::table('invest_return')
        ->join('invest_manages', 'invest_return.pack_id', '=', 'invest_manages.id')
        ->where('invest_return.userid', $user->id)
        ->select(
            'invest_return.*',
            'invest_manages.title',
            'invest_manages.amount as pack_amount',
            'invest_manages.days as duration'
        )
        ->orderBy('invest_return.created_at', 'desc')
        ->get();


    return view('member-panel.system.investment_report', compact('investments'));
}



    public function profile(Request $request)
    {
        return view('member-panel.profile.profile');
    }

   public function profile_edit(Request $request)
    {
        $infos = User::find(auth('customer')->user()->id);
        return view('member-panel.profile.profile_edit',compact('infos'));
    }


   public function profile_update(Request $request)
    {
        try {
           $info = User::find(auth('customer')->user()->id)->update($request->all());

            $image = $request->file('image');
            if ($image != null) {
                $imageName = ImageManager::update('profile/', auth('customer')->user()->image, 'png', $request->file('image'));
                User::where('id', auth('customer')->id())->update(['image' => $imageName]);
                ImageManager::delete('/profile/' . auth('customer')->user()->image);
            }
            return response()->json(['color' => 'green','message' => 'Successfully updated Profile','status'=> 200]);
        }catch (ErrorException $e) {
            return response()->json(['color' => 'red', 'message' => $e->getMessage()], 400);
          }

    }



    public function user_id_search(Request $request)
    {
        $username          = $request->user_id;
        $username_result   = User::where('user_id', $username)->first();
        if(empty($username_result)){
            echo 1; exit();
        }else {
            echo 2; exit();
        }
    }

    public function sponser_search(Request $request)
    {
        $sponsor       = $request->sponsor;
        $username_result   = User::where('user_id', $sponsor)->first();

        if(!empty($username_result)){
            echo 1;
        }else {
            echo 2;
        }
    }



    public function placement_search(Request $request)
    {
        $placement_id       = $request->placement_id;
        $placement          = $request->placement;

        $placement_user   = User::where('user_id', $placement_id)->first();

        if(!empty($placement_user)){

               if($placement == "L"){
                    $left_position = User::where('placement_id', $placement_id)->where('placement',$placement)->first();

                     if(empty($left_position)){
                        echo 1 ; exit();
                     }else {
                        echo 2 ; exit();
                     }
               } else if($placement == "R"){
                     $right_position = User::where('placement_id', $placement_id)->where('placement',$placement)->first();
                     if(empty($right_position)){
                        echo 1 ; exit();
                     }else {
                        echo 2;
                         exit();
                     }
                }

        }else {
            echo 10;
            exit();
        }
    }




    public function placement_search_old(Request $request)
    {
        $sponser_id = $this->recursiveFindLeftPosition($request->placement_id,$request->placement);
        return response()->json([
            'message' => $sponser_id . ' is your  placement id',
            'user_id' => $sponser_id,
        ]);
    }

    private function recursiveFindLeftPosition($sponsorId,$placement)
    {
        $user = User::where('sponser', $sponsorId)
            ->where('placement',$placement)
            ->first();

        if ($user) {
            return $this->recursiveFindLeftPosition($user->user_id,$placement);
        } else {
            return $sponsorId;
        }
    }



    public function register(Request $request)
    {
        $data['placement_id']   =  $request->pli;
        $data['placement']      =  $request->pl;
        $country_restrict_status = Helpers::get_business_settings('delivery_country_restriction');
        $data['customerDetail'] = User::where('id', auth('customer')->id())->first();
        $data['package']        = DB::table('invest_manages')->get();
        return view('member-panel.system.register', $data);
    }


    public function member_account_create(Request $request)
    {

        $user_check          = User::where('user_id', $request->user_id)->first();
        if(!empty($user_check)){
            echo 2;
            exit();
        }

        $sponser          = User::where('user_id', $request->sponsor)->first();
        if(empty($sponser)){
            echo 3;
            exit();
        }

        if($request->password != $request->confirmpassword) {
            echo 20;
            exit();
        }

        if( strlen($request->confirmpassword) < 5) {
            echo 21;
            exit();
        }

       $placement_id       = $request->placement_id;
       $placement          = $request->placement;
       $placement_user     = User::where('user_id', $placement_id)->first();
       if(empty($placement_user)){
              echo 10;
               exit();
       }

       $placement_result   = User::where('placement_id', $placement_user->user_id)->first();
       if(!empty($placement_user)){
         if(!empty($placement_result)){
              if($placement == "L"){
                    $left_position = User::where('placement_id', $placement_id)->where('placement',$placement)->first();
                    if(empty($left_position)){
                    }else {
                        echo 5 ;
                        exit();
                    }
              }else if($placement == "R"){
                    $right_position = User::where('placement_id', $placement_id)->where('placement',$placement)->first();
                    if(empty($right_position)){

                    }else {
                       echo 6 ;
                        exit();
                    }
               }
           }else {

           }
       }else {
             echo 10;
             exit();
       }


        $pack_amount   = DB::table('invest_manages')->where('id',  $request->pack_id)->first();

        // if($pack_amount->amount != 0){
        //     if($pack_amount->amount > auth('customer')->user()->sv_wallet ){
        //         echo 4;
        //         exit();
        //     }
        // }
        try {
                DB::beginTransaction();
               // $pack_amount           = DB::table('invest_manages')->where('id',  $request->pack_id)->first();
                $sponses_wall          = User::where('user_id', $request->sponsor)->first();
                $reg_amount            = 0;

                $seller                = new User();

                $seller->phone         = $request->phone;
                $seller->email         = $request->email;
                $seller->f_name        = $request->full_name;
                $seller->user_id       = strtolower($request->user_id);
                $seller->sponser       = $sponses_wall->user_id;
                $seller->placement     = $request->placement;
                $seller->placement_id  =  $request->placement_id;
                $seller->password      = bcrypt($request->password);
                //$seller->trans_password  = bcrypt($request->confirmpassword);
                $seller->password_plain= $request->password;
                $seller->nid           = $request->nid;
                $seller->account_type  = 0;
                $seller->pack_id       = 0;
                $seller->id_type       = 2; // affiliate
                $seller->left_count    = 0;
                $seller->right_count   = 0;
                $seller->left_pv       = 0;
                $seller->right_pv      = 0;
                $seller->left_pv_flashable   = 0;
                $seller->right_pv_flashable  = 0;
                $seller->income_wallet       = 0;
                $seller->register_wallet     = 0;
                $seller->sv_wallet           = 0;
                // $seller->image = 0;
                $seller->sponser_count = 0;
                // $seller->status = 1;
                $seller->save();

                $this->sponsor_count($sponses_wall->user_id, $seller->id, $count = 1);

                // DB::table('package_upgrade_history')->insert([
                //     'user_id'     => $seller->id,
                //     'package_id'  => $pack_amount->id,
                //     'deduct_amnt' => $pack_amount->amount,
                //     'pack_price'  => $pack_amount->amount,
                //     'created_at'  => now(),
                //     'updated_at'  => now(),
                // ]);


              //  if($pack_amount->amount != 0){

                    // $user_balance          = User::where('id', auth('customer')->user()->id)->first();
                    // $dataPP['sv_wallet'] = $user_balance->sv_wallet  - $reg_amount;
                    // DB::table('users')->where('id', $user_balance->id)->update($dataPP);

                    // $sponser_percent = DB::table('invest_manages')->where('id',  $user_balance->account_type)->first();


                    // //  $dist_amount           = $sponser_percent->spon_per * $reg_amount / 100;
                    // //  $dist_amount           = 10 * $reg_amount / 100;
                    // $dist_amount               = $reg_amount * 25 * 0.12;
                    // $dataaaP['sponser_count']  = $sponses_wall->sponser_count + 1;
                    // $dataaaP['income_wallet']  = $sponses_wall->income_wallet + $dist_amount ;
                    // DB::table('users')->where('id', $sponses_wall->id)->update($dataaaP);

                    // DB::table('invest_return')->insert([
                    //     'userid'        => $seller->id ,
                    //     'pack_id'       => $pack_amount->id,
                    //     'return_count'  => $pack_amount->days,
                    //     'percent'       => $pack_amount->percent,
                    //     'amount'        => $pack_amount->amount,
                    //     'status'        => 0,
                    //     'created_at'    => now(),
                    //     'updated_at'    => now(),
                    // ]);

                    // $dataq['type']        = 1;
                    // $dataq['amount']      = $dist_amount;
                    // $dataq['reg_amount']  = $pack_amount->amount;
                    // $dataq['main_id']     = auth('customer')->user()->id; //seller id
                    // $dataq['seller_id']   = $sponses_wall->id; //sponsor account
                    // $dataq['reg_id']      = $seller->id; // new registration id
                    // DB::table('sponser_commission')->insert($dataq);

                    //  $this->carry_update($request->placement_id, $request->placement, $pack_amount->amount);
                    //  $distributed_amount =  $pack_amount->amount * 25 * 0.08;
                    //  $this->generation_income_distribute($sponses_wall->user_id, $seller->id, $count = 1, $distributed_amount);
                    //$this->club_bonus_store($pack_amount->amount, $seller->id);
                    //$this->ex_club_bonus_store($pack_amount->amount, $seller->id);
              //  }

            // $sender_id ='899';
            //$apiKey    ='YWJva2FzaG9ubGluZTpQYXNzMTIzQUI=';
            // $mobileNo  =$request->phone;
            // $message   ='Hi! '.$request->user_id.' Welcome to . Your User Name '.$request->user_id.' & Pass '.$request->password;
            // Session::put('users_name', strtolower($request->user_id));
            // Session::put('users_pass', $request->password);

            //$this->basic_email($request);
            //$this->techno_bulk_sms($sender_id,$apiKey,$mobileNo,$message);
            DB::commit();

            echo 1;  exit();

        }catch (ErrorException $e) {
            //  $e->getMessage();
            DB::rollBack();
            echo 0;  exit();
        }

    }



    private function carry_update($mbplacement, $mbteam, $amount)
    {
        $teaminfo   =  User::where('user_id', $mbplacement)->select('id', 'user_id', 'left_pv',  'right_pv','left_pv_flashable', 'right_pv_flashable', 'left_count','right_count','placement_id', 'placement')->first();

        if(!empty($teaminfo)) {
            if($mbteam == "L") {
                User::where('id', $teaminfo->id)->update([
                    'left_pv'      => $teaminfo->left_pv + $amount,
                    'left_count'      => $teaminfo->left_count + 1,
                    'left_pv_flashable'   => $teaminfo->left_pv_flashable + $amount,
                ]);

            } elseif($mbteam == "R") {
                User::where('id', $teaminfo->id)->update([
                    'right_pv'      => $teaminfo->right_pv + $amount,
                    'right_count'      => $teaminfo->right_count + 1,
                    'right_pv_flashable'   => $teaminfo->right_pv_flashable + $amount,
                ]);
            }
        }
        if(!empty($teaminfo)){
            return $this->carry_update($teaminfo->placement_id, $teaminfo->placement, $amount);
        }
    }



    private function carry_upgrade_user($mbplacement, $mbteam, $amount)
    {
        $teaminfo   =  User::where('user_id', $mbplacement)->select('id', 'user_id', 'left_pv',  'right_pv','left_pv_flashable', 'right_pv_flashable', 'left_count','right_count','placement_id', 'placement')->first();

        if(!empty($teaminfo)) {
            if($mbteam == "L") {
                User::where('id', $teaminfo->id)->update([
                    'left_pv'      => $teaminfo->left_pv + $amount,
                    'left_pv_flashable'   => $teaminfo->left_pv_flashable + $amount,
                ]);

            } elseif($mbteam == "R") {
                User::where('id', $teaminfo->id)->update([
                    'right_pv'      => $teaminfo->right_pv + $amount,
                    'right_pv_flashable'   => $teaminfo->right_pv_flashable + $amount,
                ]);
            }
        }
        if(!empty($teaminfo)){
            return $this->carry_upgrade_user($teaminfo->placement_id, $teaminfo->placement, $amount);
        }
    }


  private function sponsor_count($sponser_id, $insertid, $count = 1)
  {
      $sponser_details    = User::where('user_id', $sponser_id)->first();
      if(!empty($sponser_details)){

            $dataw['sponser_count']  = $sponser_details->sponser_count + $count;
            User::where('id', $sponser_details->id)->update($dataw);

            $genaration_count        = $count+1;
            if(!empty($sponser_details)){
             return  $this->sponsor_count($sponser_details->sponser, $insertid, $genaration_count);
            }

       }
  }


    private function generation_income_distribute($sponser_id, $insertid, $count = 1, $pack_amount)
    {
        $sponser = User::where('user_id', $sponser_id)->first();

        if (!$sponser || $count > 6) return;

        $commissions = [
            1 => ['percent' => 2, 'required' => 0],
            2 => ['percent' => 2, 'required' => 2],
            3 => ['percent' => 1, 'required' => 4],
            4 => ['percent' => 1, 'required' => 6],
            5 => ['percent' => 1, 'required' => 8],
            6 => ['percent' => 1, 'required' => 10],
        ];


        if (isset($commissions[$count])) {
            $conf = $commissions[$count];

            if ($count === 1 || $sponser->sponser_count >= $conf['required']) {
                $dist_amount = ($pack_amount * $conf['percent']) / 100;

                // Update wallet
                $sponser->increment('income_wallet', $dist_amount);

                // Insert commission record
                DB::table('generation_commisions')->insert([
                    'amount' => $dist_amount,
                    'user_id' => $sponser->id,
                    'reg_id' => $insertid,
                    'gen' => $count,
                    'comment' => 'Generation'
                ]);
            }
        }

        // Recursive call to next upline
        $this->generation_income_distribute($sponser->sponser, $insertid, $count + 1, $pack_amount);
    }




   public function techno_bulk_sms_back($sender_id,$apiKey,$mobileNo,$message){
        $url = 'https://24smsbd.com/api/bulkSmsApi';
        $data = array('sender_id' => $sender_id,
         'apiKey' => $apiKey,
         'mobileNo' => $mobileNo,
         'message' =>$message
         );
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        $output = curl_exec($curl);
        curl_close($curl);
    }


    public function password_update(Request $request)
    {
        $user = User::find(auth('customer')->user()->id);

        if (!Hash::check($request->oldpassword, $user->password)) {
             return response()->json(['color' => 'red','message' => 'Old password did not matched!','status'=> 500]);
        }

        if (($request->password != $request->confirmpassword)) {
             return response()->json(['color' => 'red','message' => 'Password and confirm password did not matched!','status'=> 500]);
        }

        $user->password       = bcrypt($request['password']);
        $user->password_plain = $request['password'];
        $user->save();
        return response()->json(['color' => 'green','message' => 'Password updated successfully','status'=> 200] );
    }

    public function tran_password_update(Request $request)
    {

        $user = User::find(auth('customer')->user()->id);
        if((auth('customer')->user()->trans_password)){
            if (!Hash::check($request->toldpassword, $user->trans_password)) {
                return response()->json(['color' => 'red','message' => 'Old  Transaction password did not matched!','status'=> 500]);
            }
        }

        if (($request->tpassword != $request->tconfirmpassword)) {
             return response()->json(['color' => 'red','message' => ' Transaction Password and confirm  Transaction password did not matched!','status'=> 500]);
        }

        $user->trans_password       = bcrypt($request['tconfirmpassword']);
        $user->save();
        return response()->json(['color' => 'green','message' => 'Transaction Password updated successfully','status'=> 200]);
    }

    // product order

    public function products(Request $request)
    {
        $data['product'] =  DB::table('products')->orderBy('id', 'asc')->get();
        $data['users']   =  User::where('account_type','!=',1)->orderBy('id', 'asc')->get();
        return view('member-panel.order.products', $data);
    }


    public function placement_tree($user_id)
    {
        $data['member_details']       = User::where('user_id', $user_id)->first();
        return view('member-panel.tree.placement_tree_page', $data);
    }

    public function placement_tree2($user_id)
    {
        $user_id                      = base64_decode($user_id);
        $data['member_details']       = User::where('user_id', $user_id)->first();
        return view('member-panel.tree.placement_tree_page', $data);
    }

    public function tree_search(Request $request)
    {
        $data['member_details']            = User::where('user_id',  $request->user_id)->first();
        if(!empty($data['member_details']  )){
            if( $data['member_details']->id >= auth()->guard('customer')->user()->id )
            {
                $data['member_details']   = User::where('user_id',  $request->user_id)->first();
            } else {
                 $data['member_details']  = '';
            }
        }  else {
             $data['member_details']  = '';
        }

        return view('member-panel.tree.placement_tree_page', $data);
    }

    public function tree_details($user_id)
    {
        $member  = User::where('user_id', $user_id)->first();
        $data['member_details']       = User::where('id', $member->id)->first();
        $data['member_details']  = User::where('id', $member->id)->first();
        return view('member-panel.tree.placement_tree_page', $data);
    }


    public function account_tickets()
    {
        $supportTickets = SupportTicket::where('customer_id', auth('customer')->id())->orderBy('id','desc')->paginate(20);

        return view('member-panel.system.support-ticket', compact('supportTickets'));
    }

    public function single_ticket(Request $request)
    {
        $ticket = SupportTicket::where('id', $request->id)->first();

        return view('member-panel.system.ticket_view', compact('ticket'));

    }


    public function ticket_submit(Request $request)
    {
        $ticket = [
            'subject' => $request['ticket_subject'],
            'type' => $request['ticket_type'],
            'customer_id' => auth('customer')->check() ? auth('customer')->id() : null,
            'priority' => $request['ticket_priority'],
            'description' => $request['ticket_description'],
            'created_at' => now(),
            'updated_at' => now(),
        ];
        DB::table('support_tickets')->insert($ticket);
        return back();
    }


    public function support_ticket_delete(Request $request)
    {
        if (auth('customer')->check()) {
            $support = SupportTicket::find($request->id);
            $support->delete();
            return redirect()->back();
        } else {
            return redirect()->back();
        }

    }


    public function comment_submit(Request $request, $id)
    {
        $request->validate([
            'comment' => 'required',
        ], [
            'comment.required' => 'Type something',
        ]);

        DB::table('support_tickets')->where(['id' => $id])->update([
            'status' => 'open',
            'updated_at' => now(),
        ]);

        DB::table('support_ticket_convs')->insert([
            'customer_message' => $request->comment,
            'support_ticket_id' => $id,
            'position' => 0,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        return back();
    }

    public function support_ticket_close($id)
    {
        DB::table('support_tickets')->where(['id' => $id])->update([
            'status' => 'close',
            'updated_at' => now(),
        ]);
        Toastr::success('Ticket closed!');
        return redirect('/member/account-tickets');
    }



    public function all_gallery(Request $request)
    {
        $data['banners']   = Banner::where('banner_type','Member Banner')->where('published',1)->orderBy('id', 'desc')->get();
        return view('member-panel.system.all_gallery', $data);
    }


    public function package_upgrade(Request $request)
    {

        $data['customerDetail'] = User::where('id', auth('customer')->id())->first();
        $data['package']        = DB::table('invest_manages')->get();
   //     $data['package']        = DB::table('invest_manages')->where('id', '>', auth('customer')->user()->pack_id )->get();
        return view('member-panel.system.package_update', $data);
    }



    public function member_account_upgrade(Request $request)
    {
        $package = DB::table('invest_manages')->where('id', $request->pack_id)->first();
        $users   = User::where('id', auth('customer')->user()->id)->first();

             $check_status =  $users->pack_id;

            $package_upgrade_history = DB::table('package_upgrade_history')->where('user_id',$users->id)->get();
            $total_payment           = $package_upgrade_history->sum('deduct_amnt');
            $final_amount            = $package->amount - $total_payment;

            if( $users->register_wallet < $final_amount ){
                   echo 2;
                   exit();
            }

            $users->register_wallet     =  $users->register_wallet - $final_amount;
            $users->pack_id       =  $package->id ;
            $users->update();

            DB::table('package_upgrade_history')->insert([
                'user_id'     => $users->id,
                'package_id'  => $request->pack_id,
                'deduct_amnt' => $final_amount,
                'pack_price'  => $package->amount,
                'created_at'  => now(),
                'updated_at'  => now(),
            ]);


            $pack_amount           = DB::table('invest_manages')->where('id', $request->pack_id)->first();

            $reg_amount            = $final_amount;
            if($pack_amount->amount != 0){

                $user_balance          = User::where('id', auth('customer')->user()->id)->first();
                $sponses_wall          = User::where('user_id', $user_balance->sponser)->first();

                $dist_amount               = $reg_amount * $pack_amount->percent / 100;
                $dataaaP['income_wallet']  = $sponses_wall->income_wallet + $dist_amount ;
                DB::table('users')->where('id', $sponses_wall->id)->update($dataaaP);

                // DB::table('invest_return')->insert([
                //     'userid'        => $user_balance->id ,
                //     'pack_id'       => $pack_amount->id,
                //     'return_count'  => $pack_amount->days,
                //     'percent'       => $pack_amount->percent,
                //     'amount'        => $pack_amount->amount,
                //     'status'        => 0,
                //     'created_at'    => now(),
                //     'updated_at'    => now(),
                // ]);

                $dataq['type']        = 1;
                $dataq['amount']      = $dist_amount;
                $dataq['reg_amount']  = $reg_amount;
                $dataq['main_id']     = auth('customer')->user()->id; //seller id
                $dataq['seller_id']   = $sponses_wall->id; //sponsor account
                $dataq['reg_id']      = $user_balance->id; // new registration id
                DB::table('sponser_commission')->insert($dataq);

                //$this->carry_upgrade_user($user_balance->placement_id, $user_balance->placement, $final_amount);
                //$distributed_amount =  $final_amount * 25 * 0.08;
                $this->generation_income_distribute($sponses_wall->user_id, $user_balance->id, $count = 1, $reg_amount);
            }

            echo 1;
            exit();
    }



    public function generation_list(Request $request)
    {
        if(!empty($request->user)){
            $user   = $request->user;
        }else{
            $user   =   auth('customer')->user()->user_id;
        }

        $users         = User::where('sponser',  $user)->select('id','created_at','user_id','sponser','email','phone','f_name','l_name','sponser_count')->get();
        $allcount      = User::where('sponser',  $user)->select('id','created_at','user_id','sponser','email','phone','f_name','l_name','sponser_count')->count();
        $users_detail  = User::where('user_id',  $user)->first();
        if(!empty($users)){
            if(empty($request->gen)){
                $gen    = 1;
            }else{
                $gen    = 1 + $request->gen;
            }
        } else {
            $users = [];
            $gen   = 0;
        }

        return view('member-panel.system.generation_list', compact('users','gen','users_detail','allcount'));
    }









}
