<?php

namespace App\Http\Controllers\Web;

use App\CPU\BackEndHelper;
use App\CPU\Helpers;
use App\CPU\ImageManager;
use App\Http\Controllers\Controller;
use App\User;
use App\Model\Product;
use App\CPU\OrderManager;
use App\Model\ProductStock;
use App\Model\Order;
use App\Model\OrderDetail;
//use Barryvdh\DomPDF\Facade as PDF;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Session;
use Redirect;
use App\Model\BusinessSetting;
use App\Model\DeliveryMan;
use App\Model\DeliveryManTransaction;
use App\Model\DeliverymanWallet;
use App\Model\OrderTransaction;
use App\Model\Seller;
use App\Traits\CommonTrait;
use App\Model\ShippingAddress;
use App\Model\Admin;
use Illuminate\Support\Facades\View;
use Ramsey\Uuid\Uuid;
use function App\CPU\translate;
use App\CPU\CustomerManager;
use App\CPU\Convert;
class DealerController extends Controller
{


    public function orders(Request $request)
    {
        $query = Order::where('customer_id',auth('customer')->user()->id);

        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }


        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('id', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.order.orders', $data);
    }


    public function order_detail($id)
    {
        $data['order'] =  Order::find($id);
        return view('member-panel.order.order-details', $data);
    }


    public function delivery(Request $request)
    {

        $query = Order::where('order_from','software')->where('seller_id',auth('customer')->user()->id);
        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }

        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('id', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.order.delivery', $data);
    }


    public function pending_order_detail($id)
    {
        $data['order'] =  Order::find($id);
        return view('member-panel.order.pending_order_detail', $data);
    }


    public function stock(Request $request)
    {
        $query = Product::join('product_stocks', 'products.id', '=', 'product_stocks.product_id')
                ->where(function ($query) {
                    $query->where('product_stocks.qty', '>', 0)
                        ->orWhereNull('product_stocks.qty');
                })
                ->where('product_stocks.user_id', auth('customer')->user()->id);

        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('product_stocks.created_at', [$fromDate, $toDate]);
        }


        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('id', 'like', "%$search%")
                    ->orWhere('product_stocks.created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->select('products.*','product_stocks.qty')->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.order.stock', $data);
    }



    public function product($id)
    {
        if($id != 0 && $id != 'admin'){
            $data['product']  = Product::join('product_stocks', 'products.id', '=', 'product_stocks.product_id')
                                        ->where(function ($query) {
                                            $query->where('product_stocks.qty', '>', 0)
                                                ->orWhereNull('product_stocks.qty');
                                        })
                                        ->where('product_stocks.user_id', $id)
                                        ->select('products.*','product_stocks.qty')
                                        ->get();

        }else if( $id == 'admin'){
            $data['product'] =  Product::where('current_stock','!=',0)->orderBy('id', 'asc')->get();
        }else {
            $data['product'] = [];
        }

        $data['id'] = $id;

        $dealer_type =  auth('customer')->user()->account_type;
        if ($dealer_type == 5) {
            $data['users'] =  User::where('id','!=',auth('customer')->user()->id)->whereIn('account_type',[1,2,3,4])->orderBy('id', 'asc')->get();
        } elseif ($dealer_type == 4) {
            $data['users'] =  User::where('id','!=',auth('customer')->user()->id)->whereIn('account_type',[1,2,3])->orderBy('id', 'asc')->get();
        } elseif ($dealer_type == 3) {
            $data['users'] =  User::where('id','!=',auth('customer')->user()->id)->whereIn('account_type',[1,2])->orderBy('id', 'asc')->get();
        } elseif ($dealer_type == 2) {
            $data['users'] =  User::where('id','!=',auth('customer')->user()->id)->whereIn('account_type',[1])->orderBy('id', 'asc')->get();
        } elseif ($dealer_type == 1) {
            $data['users'] =   [];
        } else{
            $data['users'] =  User::where('id','!=',auth('customer')->user()->id)->whereIn('account_type',[1,2,3,4,5])->orderBy('id', 'asc')->get();
        }

        return view('member-panel.order.products', $data);
    }



    public function create_order(Request $request){

            $product_id  =  $request->product_id;
            $amounts     =  $request->amounts;
            $quantity    =  $request->Quantity;
            $amounts     =  $request->total_amounts;
            $grand_total =  $request->grand_total;
            $seller_id   = $request->seller_id;
            if($grand_total >  auth('customer')->user()->register_wallet){

               Toastr::error('You do not have Purchase balance....');
               return Redirect::back();
            }

            if($seller_id == 0) {
                Toastr::error('Something went wrong....');
                return Redirect::back();
            }

            if(empty($seller_id)) {
                Toastr::error('Something went wrong....');
                return Redirect::back();
            }

            if($grand_total < 0){
                Toastr::warning('There is no product added.');
                return back();
            }
            if(empty($grand_total)){
                Toastr::warning('There is no product added.');
                return back();
            }

            DB::beginTransaction();
            try {
               if($request->seller_id == 'admin'){
                        Order::insert([
                                'customer_id'=> auth('customer')->user()->id,
                                'order_amount'=> $grand_total,
                                'discount_amount' => 0,
                                'payment_status' => 'paid',
                                'shipping_address' => auth('customer')->user()->street_address,
                                'shipping_cost' => 0,
                                'billing_address'=> auth('customer')->user()->street_address,
                                'extra_discount'=> 0,
                                'delivery_man_id'=> 1,
                                'shipping_method_id'=> 0,
                                'order_from'=> 'ecommerce',
                                'seller_id'=> $request->seller_id, // 1 ==  admin
                                'delivery_type'=> 0, //  0 == pending, 1 == delivered ,
                                'created_at'=>now(),
                                'updated_at'=>now()
                        ]);

                        $orderId = DB::getPdo()->lastInsertId();
                        foreach ($product_id  as $key => $value) {
                            if(!empty($request->Quantity[$key])){
                            $product_sv =  Product::where('id',$request->product_id[$key])->first()->sv_point;
                                OrderDetail::insert([
                                    'order_id'=> $orderId,
                                    'price'=> $request->amounts[$key] ,
                                    'product_id' => $request->product_id[$key],
                                    'price' => $request->amounts[$key],
                                    'discount' => 0,
                                    'payment_status' => 'paid',
                                    'qty' => $request->Quantity[$key],
                                    'sv_point' => $product_sv,
                                    'tax' => 0,
                                    'shipping_method_id' => 0,
                                    'seller_id' => $request->seller_id,
                                    'created_at'=>now(),
                                    'updated_at'=>now(),
                                ]);
                            }
                        }

                        User::where('id',auth('customer')->user()->id)->update([
                            'register_wallet' => auth('customer')->user()->register_wallet - $grand_total
                        ]);

                    } else {
                            Order::insert([
                                'customer_id'=> auth('customer')->user()->id,
                                'order_amount'=> $grand_total,
                                'discount_amount' => 0,
                                'payment_status' => 'paid',
                                'shipping_address' => auth('customer')->user()->street_address,
                                'shipping_cost' => 0,
                                'billing_address'=> auth('customer')->user()->street_address,
                                'extra_discount'=> 0,
                                'delivery_man_id'=> 1,
                                'shipping_method_id'=> 0,
                                'order_from'=> 'software',
                                'seller_id'=> $request->seller_id, // 1 ==  admin
                                'delivery_type'=> 0, //  0 == pending, 1 == delivered ,
                                'created_at'=>now(),
                                'updated_at'=>now()
                        ]);

                        $orderId = DB::getPdo()->lastInsertId();
                        $total_sv = 0;
                        foreach ($product_id  as $key => $value) {
                            if(!empty($request->Quantity[$key])){
                                $stock_chck =  ProductStock::where('user_id',$seller_id)->where('product_id',$request->product_id[$key])->first();

                                ProductStock::where('id',$stock_chck->id)->update([
                                    'qty'=> $stock_chck->qty -  $request->Quantity[$key],
                                    'updated_at'=>now(),
                                ]);

                                $product_sv =  Product::where('id',$request->product_id[$key])->first()->sv_point;

                                OrderDetail::insert([
                                    'order_id'=> $orderId,
                                    'price'=> $request->amounts[$key] ,
                                    'product_id' => $request->product_id[$key],
                                    'price' => $request->amounts[$key],
                                    'discount' => 0,
                                    'payment_status' => 'paid',
                                    'qty' => $request->Quantity[$key],
                                    'sv_point' => $product_sv,
                                    'tax' => 0,
                                    'shipping_method_id' => 0,
                                    'seller_id' => $request->seller_id,
                                    'created_at'=>now(),
                                    'updated_at'=>now(),
                                ]);
                                $total_sv += $product_sv;
                            }

                        }
                        $sellerDetails =  User::where('id',$request->seller_id)->first(['id','sv_wallet','register_wallet']);

                        if($sellerDetails->sv_wallet < $total_sv){
                            Toastr::warning('This dealer does not have sufficiant SV.');
                            return back();
                        }

                        User::where('id',auth('customer')->user()->id)->update([
                            'register_wallet' => auth('customer')->user()->register_wallet - $grand_total
                        ]);

                    }

                DB::commit(); // Commit the changes
                Toastr::success('Product Purchase successfull...');
                return back();
            } catch (Exception $e) {
                Toastr::error('Failed Please try again...');
                DB::rollBack();
            }

    }



    public function orders_status(Request $request)
    {

        $order = Order::find($request->id);

        if(!isset($order->customer))
        {
            return response()->json(['customer_status'=>0],200);
        }

        DB::beginTransaction();
         try {

                //  recheck
                $wallet_status = Helpers::get_business_settings('wallet_status');
                $loyalty_point_status = Helpers::get_business_settings('loyalty_point_status');

                if($request->order_status=='delivered' && $order->payment_status !='paid'){

                    return response()->json(['payment_status'=>0],200);
                }
                $fcm_token = isset($order->customer) ? $order->customer->cm_firebase_token : null;
                $value = Helpers::order_status_update_message($request->order_status);
                if(!empty($fcm_token)) {
                    try {
                        if ($value) {
                            $data = [
                                'title' => translate('Order'),
                                'description' => $value,
                                'order_id' => $order['id'],
                                'image' => '',
                            ];
                            Helpers::send_push_notif_to_device($fcm_token, $data);
                        }
                    } catch (\Exception $e) {
                    }
                }

                try {
                    $fcm_token_delivery_man = $order->delivery_man->fcm_token;
                    if ($request->order_status == 'canceled' && $value != null) {
                        $data = [
                            'title' => translate('order'),
                            'description' => $value,
                            'order_id' => $order['id'],
                            'image' => '',
                        ];
                        if($order->delivery_man_id) {
                            self::add_deliveryman_push_notification($data, $order->delivery_man_id);
                        }
                        Helpers::send_push_notif_to_device($fcm_token_delivery_man, $data);
                    }
                } catch (\Exception $e) {
                }

                $order->order_status = $request->order_status;
                OrderManager::stock_update_on_order_status_change($order, $request->order_status);
                $order->save();

                if($loyalty_point_status == 1)
                {
                    if($request->order_status == 'delivered' && $order->payment_status =='paid'){
                        CustomerManager::create_loyalty_point_transaction($order->customer_id, $order->id, Convert::default($order->order_amount-$order->shipping_cost), 'order_place');
                    }
                }

                if ($order->delivery_man_id && $request->order_status == 'delivered') {
                    $dm_wallet = DeliverymanWallet::where('delivery_man_id', $order->delivery_man_id)->first();
                    $cash_in_hand = $order->payment_method == 'cash_on_delivery' ? $order->order_amount : 0;

                    if (empty($dm_wallet)) {
                        DeliverymanWallet::create([
                            'delivery_man_id' => $order->delivery_man_id,
                            'current_balance' => BackEndHelper::currency_to_usd($order->deliveryman_charge) ?? 0,
                            'cash_in_hand' => BackEndHelper::currency_to_usd($cash_in_hand),
                            'pending_withdraw' => 0,
                            'total_withdraw' => 0,
                        ]);
                    } else {
                        $dm_wallet->current_balance += BackEndHelper::currency_to_usd($order->deliveryman_charge) ?? 0;
                        $dm_wallet->cash_in_hand += BackEndHelper::currency_to_usd($cash_in_hand);
                        $dm_wallet->save();
                    }

                    if($order->deliveryman_charge && $request->order_status == 'delivered'){
                        DeliveryManTransaction::create([
                            'delivery_man_id' => $order->delivery_man_id,
                            'user_id' => 0,
                            'user_type' => 'admin',
                            'credit' => BackEndHelper::currency_to_usd($order->deliveryman_charge) ?? 0,
                            'transaction_id' => Uuid::uuid4(),
                            'transaction_type' => 'deliveryman_charge'
                        ]);
                    }
                }

            //  self::add_order_status_history($request->id, 0, $request->order_status, 'admin');

                $transaction = OrderTransaction::where(['order_id' => $order['id']])->first();
                if (isset($transaction) && $transaction['status'] == 'disburse') {
                    return response()->json($request->order_status);
                }

                if ($request->order_status == 'delivered' && $order['seller_id'] != null) {
                    OrderDetail::where('order_id', $order->id)->update(
                        ['delivery_status'=>'delivered']
                    );

                 //   $order =     Order::where('id', $order->id)->first();
                    $sv_sum =    OrderDetail::where('order_id', $order->id)->get();

                    $total_sv_point = 0;
                    foreach($sv_sum as $v){
                        $aaaaa = $v->qty * $v->sv_point;
                        $total_sv_point = $total_sv_point + $aaaaa;
                    }


                    $userDetails =  User::where('id',$order->customer_id)->first(['id','sv_wallet']);
                    User::where('id',$userDetails->id)->update(['sv_wallet' => $userDetails->sv_wallet + $total_sv_point]);


                    // dealer commission
                     $seller =  User::where('id',$order->seller_id)->first(['id','sv_wallet','income_wallet','register_wallet','account_type']);

                            if( $seller->account_type == 1){
                                $distribt_amount = $total_sv_point *  4 / 100;
                            }elseif($seller->account_type == 2){
                                $distribt_amount = $total_sv_point *  4 / 100;
                            }elseif($seller->account_type == 3){
                                $distribt_amount = $total_sv_point *  6 / 100;
                            }


                            User::where('id',$seller->id)->update([
                                'sv_wallet'       => $seller->sv_wallet - $total_sv_point,
                                'register_wallet' => $seller->register_wallet + $order->order_amount,
                                'income_wallet'   => $seller->income_wallet + $distribt_amount,
                            ]);

                            DB::table('dealer_commission')->insert([
                                'order_id'    => $order->id,
                                'type'        => $seller->account_type,
                                'user_id'     => $userDetails->id,
                                'seller_id'   => $seller->id,
                                'main_amount' => $total_sv_point,
                                'amount'      => $distribt_amount,
                                'created_at'  => now(),
                                'updated_at'  => now(),
                            ]);

                             // dealer commission

                            $adminFund = Admin::find(1);

                            Admin::where('id', $adminFund->id)->update([
                                'cofounder'=> ($total_sv_point * 5 / 100) + $adminFund->cofounder,
                                'rank_gift'=> ($total_sv_point * 3 / 100) + $adminFund->rank_gift,
                                'salary'=> ($total_sv_point * 2 / 100) + $adminFund->salary,
                            ]);

                            $sponser = User::where('id', $order->customer_id)->first();
                            // sponsor commission

                            $dist_amount               = $total_sv_point * 7 / 100;
                            $dataaaP['income_wallet']  = $sponser->income_wallet + $dist_amount ;
                            $dataaaP['sponser_sales']  = $sponser->sponser_sales + $total_sv_point ;
                            DB::table('users')->where('id', $sponser->id)->update($dataaaP);



                            // DB::table('invest_return')->insert([
                            //     'userid'        => $user_balance->id ,
                            //     'pack_id'       => $pack_amount->id,
                            //     'return_count'  => $pack_amount->days,
                            //     'percent'       => $pack_amount->percent,
                            //     'amount'        => $pack_amount->amount,
                            //     'status'        => 0,
                            //     'created_at'    => now(),
                            //     'updated_at'    => now(),
                            // ]);

                            $dataq['type']        = 1;
                            $dataq['amount']      = $dist_amount;
                            $dataq['reg_amount']  = $total_sv_point;
                            $dataq['main_id']     = $order->seller_id; //seller id
                            $dataq['seller_id']   = $sponser->id; //sponsor account
                            $dataq['reg_id']      = $order->customer_id; // new registration id
                            DB::table('sponser_commission')->insert($dataq);
                            // sponsor commission

                           $this->generation_income_distribute($sponser->sponser, $order->customer_id, $count = 1, $total_sv_point);

                }

                DB::commit();
                return response()->json($request->order_status);
            } catch (Exception $e) {
                return response()->json('Failed Please try again...');
                DB::rollBack();
            }
    }



    private function generation_income_distribute($sponser_id, $insertid, $count = 1, $pack_amount)
    {
        $sponser = User::where('user_id', $sponser_id)->first();

        if (!$sponser || $count > 6) return;

        $commissions = [
            1 => ['percent' => 2, 'required' => 0],
            2 => ['percent' => 2, 'required' => 2],
            3 => ['percent' => 1, 'required' => 4],
            4 => ['percent' => 1, 'required' => 6],
            5 => ['percent' => 1, 'required' => 8],
            6 => ['percent' => 1, 'required' => 10],
        ];

        if (isset($commissions[$count])) {
            $conf = $commissions[$count];

            if ($count === 1 || $sponser->sponser_count >= $conf['required']) {
                $dist_amount = ($pack_amount * $conf['percent']) / 100;

                // Update wallet
                $sponser->increment('income_wallet', $dist_amount);

                // Insert commission record
                DB::table('generation_commisions')->insert([
                    'amount' => $dist_amount,
                    'user_id' => $sponser->id,
                    'reg_id' => $insertid,
                    'gen' => $count,
                    'comment' => 'Generation'
                ]);
            }
        }

        // Recursive call to next upline
        $this->generation_income_distribute($sponser->sponser, $insertid, $count + 1, $pack_amount);
    }




}
