<?php

namespace App\Http\Controllers\Web;

use App\CPU\Helpers;

//use App\CPU\ImageManager;
use App\Http\Controllers\Controller;
//use App\Traits\CommonTrait;
use App\User;
//use Barryvdh\DomPDF\Facade as PDF;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
//use Intervention\Image\Facades\Image;
use function App\CPU\translate;
use App\CPU\Convert;
use App\Model\Order;
use Session;
//use function React\Promise\all;
use Hash;
use Redirect;

class MemberReportController extends Controller
{
 //   use CommonTrait;


    public function refer_commission(Request $request)
    {
        $query = DB::table('sponser_commission')->where('seller_id',auth('customer')->user()->id);

        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }

        // Apply search if the "search" parameter is present
        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.reports.refer_commission', $data);
    }

    public function generation_commission(Request $request)
    {
        $query = DB::table('generation_commisions')->where('comment','Generation')->where('user_id',auth('customer')->user()->id);

        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }

        // Apply search if the "search" parameter is present
        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.reports.generation_commission', $data);
    }

    public function matching_commission(Request $request)
    {
        $query = DB::table('matching_history')->where('userid',auth('customer')->user()->id);

        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }

        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.reports.matching_commission', $data);
    }

    public function incentive_commission(Request $request)
    {
        $query = DB::table('royal_rank_history')->where('user',auth('customer')->user()->id);

        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }

        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.reports.incentive_commission', $data);
    }

    public function global_commission(Request $request)
    {
        $query = DB::table('monthly_club_distribute')->where('userid',auth('customer')->user()->id);

        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }

        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.reports.global_commission', $data);
    }

    public function leadership_commission(Request $request)
    {
        $query = DB::table('generation_commisions')->where('comment','Leadership')->where('user_id',auth('customer')->user()->id);

        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }

        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.reports.leadership_commission', $data);
    }



    public function mentor_commission(Request $request)
    {
        $query = DB::table('upline_history')->where('userid',auth('customer')->user()->id);

        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }

        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.reports.mentor_commission', $data);
    }


    public function dealer_commission(Request $request)
    {
        $query = DB::table('dealer_commission')->where('seller_id',auth('customer')->user()->id);


        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }

        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.reports.dealer_commission', $data);
    }

    public function dealer_global_commission(Request $request)
    {
        $query = DB::table('upline_history')->where('userid',auth('customer')->user()->id);

        if ($request->has('date_range')) {

            $dateParts = explode(" to ", $request->date_range);
            $fromDate = trim($dateParts[0]);
            $toDate = trim($dateParts[1]);
            $fromDate = date('Y-m-d 00:00:00', strtotime($fromDate));
            $toDate = date('Y-m-d 23:59:59', strtotime($toDate));

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }

        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('user', 'like', "%$search%")
                    ->orWhere('created_at', 'like', "%$search%");
            });
        }

        $data['report'] = $query->orderBy('created_at', 'desc')->paginate(20);

        return view('member-panel.reports.dealer_commission', $data);
    }

    public function income_balance_report(Request $request)
    {
        $data['spon_com']  = DB::table('sponser_commission')->where('seller_id', auth('customer')->id())->sum('amount');
        $data['gen_com']   = DB::table('generation_commisions')->where('comment','Generation')->where('user_id', auth('customer')->id())->sum('amount');
        $data['matching']  = DB::table('matching_history')->where('userid',auth('customer')->user()->id)->sum('amount');
        $data['global_com']= DB::table('monthly_club_distribute')->where('userid',auth('customer')->user()->id)->sum('amount');
        $data['leadership']= DB::table('generation_commisions')->where('comment','Leadership')->where('user_id',auth('customer')->user()->id)->sum('amount');
        $data['upline']    = DB::table('upline_history')->where('userid',auth('customer')->user()->id)->sum('amount');
        $data['dealer']    = DB::table('dealer_commission')->where('seller_id',auth('customer')->user()->id)->sum('amount');
        $data['incentive']    = 0;

        $data['withdraw']  = DB::table('withdraw_requests')->where('approved',1)->where('seller_id',auth('customer')->user()->id)->sum('withouth_charge');

        $data['transfer']  = DB::table('balance_transaction')->where('from_id',auth('customer')->user()->id)->where('type', 1)->sum('amount');
        $data['transfer_in']  = DB::table('balance_transaction')->where('to_id',auth('customer')->user()->id)->where('type', 1)->sum('amount');


        return view('member-panel.reports.income_summery', $data);
    }

    public function purchase_balance_report(Request $request)
    {

        $data['cashin']  = DB::table('cash_in')->where('status',1)->where('user_id',auth('customer')->user()->id)->sum('amount');

        $data['received']  = DB::table('balance_transaction')->where('to_id',auth('customer')->user()->id)->where('type', 2)->sum('amount');
        $data['product_delivery']  = Order::where('seller_id',auth('customer')->user()->id)->where('order_status', 'delivered')->sum('order_amount');
        $data['product_order']  = Order::where('customer_id',auth('customer')->user()->id)->where('order_status', 'delivered')->sum('order_amount');

        $data['transfer']  = DB::table('balance_transaction')->where('from_id',auth('customer')->user()->id)->where('type', 2)->sum('amount');

        return view('member-panel.reports.purchase_balance_summery', $data);
    }


}
