@extends('layouts.front-end.app')

@section('title', \App\CPU\translate('Register'))

@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css
    <div class="container py-4 py-lg-5 my-4 __inline-7"
         style="text-align: {{Session::get('direction') === "rtl" ? 'right' : 'left'}};">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card border-0 box-shadow">
                    <div class="card-body">
                         <form method="post" id="upload_form" enctype="multipart/form-data" >
                            @csrf
                            <!-- profile information -->
                            <div class="row mb-3">
                                <div class="col">
                                    <h6>Create Acccount </h6>
                                </div>
                            </div>
                            <div class="row h-100 mb-4">
                                <div class="col-12 col-md-6 col-lg-4">
                                    <div class="form-group form-floating  mb-3">
                                             <label for="full_name">Full Name</label>
                                        <input type="text" class="form-control" required value="" placeholder="Full Name" id="full_name" name="full_name">

                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-lg-4">
                                    <div class="form-group form-floating mb-3">
                                         <label for="email">Email</label>
                                        <input type="email" class="form-control" required value="" placeholder="Email" id="email" name="email">

                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-lg-4">
                                    <div class="form-group form-floating mb-3">
                                         <label for="phone">Phone</label>
                                        <input type="text" class="form-control" required value="" placeholder="phone" id="phone" name="phone">

                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-lg-4">
                                    <div class="form-group form-floating  mb-3">
                                          <label for="user_id">User ID</label>
                                        <input  oninput="validateInput(this);" type="text" class="form-control" required value="" placeholder="user id" id="user_id" name="user_id">

                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-lg-4">
                                    <div class="form-group form-floating  mb-3">
                                         <label for="sponsor">Sponsor ID</label>
                                        <input type="text" class="form-control" required value="{{ $sponsor }}" readonly placeholder="Sponsor ID" id="sponsor" name="sponsor">
                                    </div>
                                </div>


                                <div class="col-12 col-md-6 col-lg-4">
                                    <div class="form-group form-floating  mb-3">
                                          <label for="nid">Enter National ID number</label>
                                        <input type="text" class="form-control" required value="" placeholder="Enter National ID number" id="nid" name="nid">

                                    </div>
                                </div>
                            </div>


                            <!-- change password -->
                            <div class="row mb-3">
                                <div class="col">
                                    <h6>Password</h6>
                                </div>
                            </div>
                            <div class="row h-100 mb-4">


                                 <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="si-password">{{\App\CPU\translate('password')}}</label>
                                        <div class="password-toggle">
                                            <input class="form-control" name="password" type="password" id="si-password"
                                                   style="text-align: {{Session::get('direction') === "rtl" ? 'right' : 'left'}};"
                                                   placeholder="{{\App\CPU\translate('minimum_8_characters_long')}}"
                                                   required>
                                            <label class="password-toggle-btn">
                                                <input class="custom-control-input" type="checkbox"><i
                                                    class="czi-eye password-toggle-indicator"></i><span
                                                    class="sr-only">{{\App\CPU\translate('Show')}} {{\App\CPU\translate('password')}} </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                        <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="si-password">{{\App\CPU\translate('confirm_password')}}</label>
                                        <div class="password-toggle">
                                            <input class="form-control" name="confirmpassword" type="password"
                                                   style="text-align: {{Session::get('direction') === "rtl" ? 'right' : 'left'}};"
                                                   placeholder="{{\App\CPU\translate('minimum_8_characters_long')}}"
                                                   id="si-password"
                                                   required>
                                            <label class="password-toggle-btn">
                                                <input class="custom-control-input" type="checkbox"
                                                       style="text-align: {{Session::get('direction') === "rtl" ? 'right' : 'left'}};"><i
                                                    class="czi-eye password-toggle-indicator"></i><span
                                                    class="sr-only">{{\App\CPU\translate('Show')}} {{\App\CPU\translate('password')}} </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row h-100 ">
                                <div class="col-12 mb-4">
                                    <button type="submit" class="btn btn--primary btn-sm w-100 sned">  <i id="icon_class" class="" style="font-size: 25px;"></i> Create Account</button>
                                </div>
                            </div>

                             <div class="flex-between row" style="direction: {{ Session::get('direction') }}">
                                <div class="mx-1">
                                    <div class="text-right">
                                    </div>
                                </div>
                                <div class="mx-1">
                                    <a class="btn btn-outline-primary" href="{{route('customer.auth.login')}}">
                                        <i class="fa fa-sign-in"></i> {{\App\CPU\translate('sign_in')}}
                                    </a>
                                </div>
                            </div>
                            </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
    .loading {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      -ms-transform: translate(-50%, -50%);
      z-index:1000000000;
    }
   .myDiv {
      height: 150px;
      width: 150px;
      display: inline-block;
      background-color: orange;
      margin-bottom: 25px;
    }

    /* The block of code below tells the browsers what to do on a screen that has a width of 320px or less */

    @media screen and (max-width: 320px) {

      .myDiv {
      width: 90%;
      display: block; /* Stops it from floating */
      margin: auto; /* Ensures that it is centered */
      margin-bottom: 25px; /* Space between the stacked elements */

      }

    }
  </style>
@endsection


@push('script')

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
        var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
         $(document).ready(function () {
            $('#user_id').val('');
        });

       $('#check_id').on('click',function(){
            if ( !this.checked){
                $('#exist_search').hide();
            }else{
                $('#exist_search').show();
            }
       });

       $('#account_type').on('change',function(){
            let pack = $(this).val();
            if ( pack ==  1 ){
                $('#package').val(1600);
            }else  if ( pack ==  2 ){
                $('#package').val(25600);
            } else  if ( pack ==  3 ){
                $('#package').val(160000);
            }
       });


         $(document).ready(function () {
            $('#sponsor').on('blur', function () {
                event.preventDefault();
                var sponsor        = $('#sponsor').val();
                var _token          = $('#_token').val();
                if(sponsor == ""){
                  return false;
                }
                $(".sned").prop('disabled', true);
                $("#loader").css('display', 'block');
                $.ajax({
                    url: "{{ url('sponser_search') }}",
                    type: 'post',
                    dataType: 'json',
                    data: { sponsor: sponsor, _token: CSRF_TOKEN,},
                    success: function (data) {
                        if(data == 1){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled',false);
                               $(".messege2").text('Your sponsor is matched');
                               $(".messege2").show().delay(5000).fadeOut();
                               /*Swal.fire(
                                'Congratulations!',
                                'We have found the sponsor',
                                'succes'
                               )    */
                        } else if(data == 2){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', true);
                               $(".messege2").text('Your sponsor is matched');
                               Swal.fire(
                                'Sorry!',
                                'This sponsor is not exist',
                                'error'
                               )
                        }
                    }
                })
            });
         });


         $(document).ready(function () {
            $('#user_id').on('blur', function () {
                event.preventDefault();

                var user_id        = $('#user_id').val();
                var _token          = $('#_token').val();
                if(user_id == ""){
                  return false;
                }
                $("#loader").css('display', 'block');
                $(".sned").prop('disabled', true);
                $.ajax({
                    url: "{{ url('user_id_search') }}",
                    type: 'post',
                    dataType: 'json',
                    data: { user_id: user_id, _token: CSRF_TOKEN,},
                    success: function (data) {
                        if(data == 1){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled',false);
                               $(".messege").text('This user name is available');
                               $(".messege").show().delay(5000).fadeOut();

                        } else if(data == 2){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', true);
                               $(".messege").text('');
                               Swal.fire(
                                'Sorry!',
                                'This user id is not available',
                                'error'
                               )
                        }
                    }
                })
            });
         });


         $(document).ready(function () {
            $('#placement').on('change', function () {
                event.preventDefault();
                var placement_id        = $('#placement_id').val();
                var placement           = $('#placement option:selected').val();
                var _token              = $('#_token').val();
                $("#loader").css('display', 'block');
                $(".sned").prop('disabled', true);
                if(placement_id == ''){
                     $("#loader").css('display', 'none');
                      return false;
                }
                if(placement == ''){
                     $("#loader").css('display', 'none');
                      return false;
                }
                $.ajax({
                    url: "{{ url('placement_search') }}",
                    type: 'post',
                    dataType: 'json',
                    data: { placement_id: placement_id, placement: placement , _token: CSRF_TOKEN,},
                    success: function (data) {
                        if(data == 1){
                            $("#loader").css('display', 'none');
                               $(".sned").prop('disabled',false);
                               Swal.fire(
                                'Success!',
                                'Available position',
                                'succes'
                               )

                        } else if(data == 2){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', true);
                               Swal.fire(
                                'Sorry!',
                                'Sorry unavailable position',
                                'error'
                               )

                        } else if(data == 3){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);


                        }  else if(data == 4){
                             $(".sned").prop('disabled',true);
                             $("#loader").css('display', 'none');
                               Swal.fire(
                                'Sorry!',
                                'Placement id is not exist',
                                'error'
                              )
                        } else if(data == 10){
                             $(".sned").prop('disabled',true);
                             $("#loader").css('display', 'none');
                               Swal.fire(
                                'Sorry!',
                                'Placement id is not exist',
                                'error'
                              )
                        } else if(data == 0){
                              $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               Swal.fire(
                                'Sorry!',
                                'Placement id is not exist',
                                'error'
                              )

                        }
                    }
                })
            });
         });

         $(document).ready(function () {
            $('#placement_id').on('blur', function () {
                event.preventDefault();
                var placement_id        = $('#placement_id').val();
                var placement           = $('#placement option:selected').val();
                var _token              = $('#_token').val();
                $("#loader").css('display', 'block');
                if(placement == ''){
                     $("#loader").css('display', 'none');

                      return false;
                }

                if(placement_id == ''){
                     $("#loader").css('display', 'none');
                     Swal.fire(
                      'Empty field!',
                      'Please select placement id!',
                      'error'
                    )
                      return false;
                }
                $.ajax({
                    url: "{{ url('placement_search') }}",
                    type: 'post',
                    dataType: 'json',
                    data: { placement_id: placement_id, placement: placement , _token: CSRF_TOKEN,},
                    success: function (data) {
                        if(data == 1){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled',false);
                               Swal.fire(
                                'Succes!',
                                'Available position',
                                'succes'
                               )
                        } else if(data == 2){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', true);
                               Swal.fire(
                                'Sorry!',
                                'Sorry unavailable position',
                                'error'
                               )

                        } else if(data == 3){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               Swal.fire(
                                'Succes!',
                                'Both position is available',
                                'succes'
                               )

                        }  else if(data == 4){
                             $(".sned").prop('disabled',true);
                             $("#loader").css('display', 'none');
                               Swal.fire(
                                'Sorry!',
                                'This placement id is not exist',
                                'error'
                              )
                        } else if(data == 10){
                             $(".sned").prop('disabled',true);
                             $("#loader").css('display', 'none');
                               Swal.fire(
                                'Sorry!',
                                'This placement id is not exist',
                                'error'
                              )
                        }  else if(data == 0){
                              $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               Swal.fire(
                                'Succes!',
                                'Both position is available',
                                'succes'
                               )
                        }
                    }
                })
            });
         });



        $("#password, #confirmpassword").on('keyup', function(){
            var password = $("#password").val();
            var confirmPassword = $("#confirmpassword").val();
            if(confirmPassword == ""){
                      $("#msg").text("");
                } else {
                    if(password == confirmPassword){
                        $("#msg").text("");
                        $(".sned").removeAttr('disabled', 'disabled');
                    } else {
                        $("#msg").text("Password and Confirm Password Do not match!");
                        $(".sned").attr('disabled', 'disabled');
                        return false;
                    }
              }
        });

        $(document).ready(function () {
            $('#upload_form').on('submit', function () {
                event.preventDefault();
                $("#loader").css('display', 'block');
                $(".sned").prop('disabled', true);
                $(this).find('i').toggleClass('fa fa-spinner fa-spin');
                $.ajax({
                    url: "{{ url('member_account_create') }}",
                    method: "POST",
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: new FormData(this),
                    success: function (data) {
                        $('#icon_class').removeClass('fa fa-spinner fa-spin');
                        if(data == 1){
                             $("#loader").css('display', 'none');
                            Swal.fire(
                                'Success!',
                                'User has been created successfully!',
                                'success'
                            )
                            // window.location.href = "{{ url('member/refferd-member')}}";
                             window.location.reload();

                        }else if(data == 2){
                               $("#loader").css('display', 'none');
                               $(this).find('i').toggleClass('');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'This user id is taken please try another',
                                'error'
                           )
                        } else if(data == 3){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'This sponsor id is wrong please try another',
                                'error'
                           )
                        }else if(data == 4){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'You do not have sufficiant balance',
                                'error'
                           )
                        } else if(data == 5){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'This position is not empty',
                                'error'
                           )
                        } else if(data == 6){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'The position is not empty',
                                'error'
                           )
                        } else if(data == 7){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Placement is wrong',
                                'error'
                           )
                        } else if(data == 10){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Placement id is wrong',
                                'error'
                           )
                        }else if(data == 20){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Password Miss match',
                                'error'
                           )
                        } else if(data == 21){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Minimum 6 digit password',
                                'error'
                           )
                        } else if(data == 0){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Somthing went wrong',
                                'error'
                           )
                        } else {
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Somthing went wrong',
                                'error'
                           )
                        }
                     }
                })
            });
         });

         function validateInput(inputElement) {
          inputElement.value = inputElement.value.replace(/[^A-Za-z0-9]/g, '');
        }

    </script>

@endpush
