@extends('layouts.front-end.app')

@section('title', $web_config['name']->value.' '.\App\CPU\translate('Online Shopping').' | '.$web_config['name']->value.' '.\App\CPU\translate(' Ecommerce'))

@push('css_or_js')
    <meta property="og:image" content="{{asset('storage/app/public/company')}}/{{$web_config['web_logo']->value}}"/>
    <meta property="og:title" content="Welcome To {{$web_config['name']->value}} Home"/>
    <meta property="og:url" content="{{env('APP_URL')}}">
    <meta property="og:description" content="{!! substr($web_config['about']->value,0,100) !!}">

    <meta property="twitter:card" content="{{asset('storage/app/public/company')}}/{{$web_config['web_logo']->value}}"/>
    <meta property="twitter:title" content="Welcome To {{$web_config['name']->value}} Home"/>
    <meta property="twitter:url" content="{{env('APP_URL')}}">
    <meta property="twitter:description" content="{!! substr($web_config['about']->value,0,100) !!}">

    <link rel="stylesheet" href="{{asset('public/assets/front-end')}}/css/home.css"/>
    <style>
        .cz-countdown-days {
            border: .5px solid{{$web_config['primary_color']}};
        }

        .btn-scroll-top {
            background: {{$web_config['primary_color']}};
        }

        .__best-selling:hover .ptr,
        .flash_deal_product:hover .flash-product-title {
            color: {{$web_config['primary_color']}};
        }

        .cz-countdown-hours {
            border: .5px solid{{$web_config['primary_color']}};
        }

        .cz-countdown-minutes {
            border: .5px solid{{$web_config['primary_color']}};
        }

        .cz-countdown-seconds {
            border: .5px solid{{$web_config['primary_color']}};
        }

        .flash_deal_product_details .flash-product-price {
            color: {{$web_config['primary_color']}};
        }

        .featured_deal_left {
            background: {{$web_config['primary_color']}} 0% 0% no-repeat padding-box;
        }

        .category_div:hover {
            color: {{$web_config['secondary_color']}};
        }

        .deal_of_the_day {
            background: {{$web_config['secondary_color']}};
        }

        .best-selleing-image {
            background: {{$web_config['primary_color']}}10;
        }

        .top-rated-image {
            background: {{$web_config['primary_color']}}10;
        }

        @media (max-width: 800px) {
            .categories-view-all {
            {{session('direction') === "rtl" ? 'margin-left: 10px;' : 'margin-right: 6px;'}}

            }

            .categories-title {
            {{Session::get('direction') === "rtl" ? 'margin-right: 0px;' : 'margin-left: 6px;'}}

            }

            .seller-list-title {
            {{Session::get('direction') === "rtl" ? 'margin-right: 0px;' : 'margin-left: 10px;'}}

            }

            .seller-list-view-all {
            {{Session::get('direction') === "rtl" ? 'margin-left: 20px;' : 'margin-right: 10px;'}}

            }

            .category-product-view-title {
            {{Session::get('direction') === "rtl" ? 'margin-right: 16px;' : 'margin-left: -8px;'}}

            }

            .category-product-view-all {
            {{Session::get('direction') === "rtl" ? 'margin-left: -7px;' : 'margin-right: 5px;'}}

            }
        }

        @media (min-width: 801px) {
            .categories-view-all {
            {{session('direction') === "rtl" ? 'margin-left: 30px;' : 'margin-right: 27px;'}}

            }

            .categories-title {
            {{Session::get('direction') === "rtl" ? 'margin-right: 25px;' : 'margin-left: 25px;'}}

            }

            .seller-list-title {
            {{Session::get('direction') === "rtl" ? 'margin-right: 6px;' : 'margin-left: 10px;'}}

            }

            .seller-list-view-all {
            {{Session::get('direction') === "rtl" ? 'margin-left: 12px;' : 'margin-right: 10px;'}}

            }

            .seller-card {
            {{Session::get('direction') === "rtl" ? 'padding-left:0px !important;' : 'padding-right:0px !important;'}}

            }

            .category-product-view-title {
            {{Session::get('direction') === "rtl" ? 'margin-right: 10px;' : 'margin-left: -12px;'}}

            }

            .category-product-view-all {
            {{Session::get('direction') === "rtl" ? 'margin-left: -20px;' : 'margin-right: 0px;'}}

            }
        }

        .countdown-card {
            background: {{$web_config['primary_color']}}10;

        }

        .flash-deal-text {
            color: {{$web_config['primary_color']}};
        }

        .countdown-background {
            background: {{$web_config['primary_color']}};
        }

        }
        .czi-arrow-left {
            color: {{$web_config['primary_color']}};
            background: {{$web_config['primary_color']}}10;
        }

        .czi-arrow-right {
            color: {{$web_config['primary_color']}};
            background: {{$web_config['primary_color']}}10;
        }

        .flash-deals-background-image {
            background: {{$web_config['primary_color']}}10;
        }

        .view-all-text {
            color: {{$web_config['secondary_color']}}  !important;
        }

        .feature-product .czi-arrow-left {
            color: {{$web_config['primary_color']}};
            background: {{$web_config['primary_color']}}10
        }

        .feature-product .czi-arrow-right {
            color: {{$web_config['primary_color']}};
            background: {{$web_config['primary_color']}}10;
            font-size: 12px;
        }

        /* original style end here  */


         /* Service Gallery Styles */

        .service-gallery-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .service-gallery-title {
            font-size: 24px;
            font-weight: 600;
            color: #333;
            position: relative;
            padding-left: 15px;
        }

        .service-gallery-title:before {
            content: '';
            position: absolute;
            left: 0;
            top: 5px;
            height: 20px;
            width: 4px;
            background: {{$web_config['primary_color']}};
        }

        .view-all-services {
            color: {{$web_config['primary_color']}};
            font-weight: 500;
        }

        .service-gallery-container {
            position: relative;
        }

        .service-gallery-slider {
            padding: 10px 0;
        }

        .service-card {
            background: #fff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            margin: 0 10px;
            transition: all 0.3s ease;
        }

        .service-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.12);
        }

        .service-image-slider {
            height: 180px;
            position: relative;
        }

        .service-image-slider .owl-stage-outer,
        .service-image-slider .owl-stage,
        .service-image-slider .owl-item {
            height: 100%;
        }

        .service-image-slider img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .service-details {
            padding: 15px;
        }

        .service-name {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 5px;
            color: #333;
        }

        .service-description {
            font-size: 13px;
            color: #666;
            margin-bottom: 10px;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .service-link {
            color: {{$web_config['primary_color']}};
            font-size: 13px;
            font-weight: 500;
        }

        .service-nav-btn {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: #fff;
            box-shadow: 0 2px 8px rgba(0,0,0,0.15);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            z-index: 2;
            opacity: 0;
            transition: all 0.3s;
        }

        .service-gallery-container:hover .service-nav-btn {
            opacity: 1;
        }

        .service-prev-btn {
            left: -18px;
        }

        .service-next-btn {
            right: -18px;
        }

        /* Dots for image slider */
        .service-image-slider .owl-dots {
            position: absolute;
            bottom: 10px;
            left: 0;
            right: 0;
            display: flex;
            justify-content: center;
        }

        .service-image-slider .owl-dot span {
            width: 8px;
            height: 8px;
            margin: 0 3px;
            background: rgba(255,255,255,0.5);
            transition: all 0.3s;
        }

        .service-image-slider .owl-dot.active span {
            background: #fff;
            width: 20px;
            border-radius: 4px;
        }


    </style>

    <link rel="stylesheet" href="{{asset('public/assets/front-end')}}/css/owl.carousel.min.css"/>
    <link rel="stylesheet" href="{{asset('public/assets/front-end')}}/css/owl.theme.default.min.css"/>
@endpush

@section('content')
    @php($categories = \App\Model\Category::with('childes.childes')->where(['position' => 0])->priority()->take(11)->get())
    @php($brands = \App\Model\Brand::active()->take(15)->get())
    <div class="__inline-61">
        @php($decimal_point_settings = !empty(\App\CPU\Helpers::get_business_settings('decimal_point_settings')) ? \App\CPU\Helpers::get_business_settings('decimal_point_settings') : 0)
        <!-- Hero (Banners + Slider)-->
        <section class="bg-transparent mb-3">
            <div class="container">
                <div class="row ">
                    <div class="col-12">
                        @include('web-views.partials._home-top-slider',['main_banner'=>$main_banner])
                    </div>
                </div>
            </div>
        </section>

        {{--flash deal--}}
        @if ($web_config['flash_deals'])
            <section class="overflow-hidden">
                <div class="container">
                    <div
                        class="flash-deal-view-all-web row d-none d-lg-flex justify-content-{{Session::get('direction') === "rtl" ? 'start' : 'end'}}"
                        style="{{Session::get('direction') === "rtl" ? 'margin-left: 2px;' : 'margin-right:2px;'}}">
                        @if (count($web_config['flash_deals']->products)>0)
                            <a class="text-capitalize view-all-text"
                               href="{{route('flash-deals',[$web_config['flash_deals']?$web_config['flash_deals']['id']:0])}}">
                                {{ \App\CPU\translate('view_all')}}
                                <i class="czi-arrow-{{Session::get('direction') === "rtl" ? 'left mr-1 ml-n1 mt-1 float-left' : 'right ml-1 mr-n1'}}"></i>
                            </a>
                        @endif
                    </div>
                    <div class="row d-flex {{Session::get('direction') === "rtl" ? 'flex-row-reverse' : 'flex-row'}}">


                        <div class="col-xl-3 col-lg-4 mt-2 countdown-card">
                            <div class="m-2">
                                <div class="flash-deal-text">
                                    <span>{{ \App\CPU\translate('flash deal')}}</span>
                                </div>
                                <div class="text-center text-white">
                                    <div class="countdown-background">
                                <span class="cz-countdown d-flex justify-content-center align-items-center"
                                      data-countdown="{{$web_config['flash_deals']?date('m/d/Y',strtotime($web_config['flash_deals']['end_date'])):''}} 11:59:00 PM">
                                    <span class="cz-countdown-days">
                                        <span class="cz-countdown-value"></span>
                                        <span>{{ \App\CPU\translate('day')}}</span>
                                    </span>
                                    <span class="cz-countdown-value p-1">:</span>
                                    <span class="cz-countdown-hours">
                                        <span class="cz-countdown-value"></span>
                                        <span>{{ \App\CPU\translate('hrs')}}</span>
                                    </span>
                                    <span class="cz-countdown-value p-1">:</span>
                                    <span class="cz-countdown-minutes">
                                        <span class="cz-countdown-value"></span>
                                        <span>{{ \App\CPU\translate('min')}}</span>
                                    </span>
                                    <span class="cz-countdown-value p-1">:</span>
                                    <span class="cz-countdown-seconds">
                                        <span class="cz-countdown-value"></span>
                                        <span>{{ \App\CPU\translate('sec')}}</span>
                                    </span>
                                </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="flash-deal-view-all-mobile col-lg-12 d-block d-xl-none"
                             style="{{Session::get('direction') === "rtl" ? 'margin-left: 2px;' : 'margin-right:2px;'}}">
                        </div>
                        <div class="col-xl-9 col-lg-8 {{Session::get('direction') === "rtl" ? 'pr-md-4' : 'pl-md-4'}}">
                            <div class="d-lg-none {{Session::get('direction') === "rtl" ? 'text-left' : 'text-right'}}">
                                <a class="mt-2 text-capitalize view-all-text"
                                   href="{{route('flash-deals',[$web_config['flash_deals']?$web_config['flash_deals']['id']:0])}}">
                                    {{ \App\CPU\translate('view_all')}}
                                    <i class="czi-arrow-{{Session::get('direction') === "rtl" ? 'left mr-1 ml-n1 mt-1 float-left' : 'right ml-1 mr-n1'}}"></i>
                                </a>
                            </div>
                            <div class="carousel-wrap">
                                <div class="owl-carousel owl-theme mt-2" id="flash-deal-slider">
                                    @foreach($web_config['flash_deals']->products as $key=>$deal)
                                        @if( $deal->product)
                                            @include('web-views.partials._product-card-1',['product'=>$deal->product,'decimal_point_settings'=>$decimal_point_settings])
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        @endif

        {{--brands--}}
        @if($web_config['brand_setting'])
            <section class="container rtl mt-3">
                <!-- Heading-->
                <div class="section-header">
                    <div class="text-black font-bold __text-22px">
                        <span> {{\App\CPU\translate('brands')}}</span>
                    </div>
                    <div class="__mr-2px">
                        <a class="text-capitalize view-all-text" href="{{route('brands')}}">
                            {{ \App\CPU\translate('view_all')}}
                            <i class="czi-arrow-{{Session::get('direction') === "rtl" ? 'left mr-1 ml-n1 mt-1 float-left' : 'right ml-1 mr-n1'}}"></i>
                        </a>
                    </div>
                </div>
                <!-- Grid-->

                <div class="mt-sm-3 mb-3 brand-slider">
                    <div class="owl-carousel owl-theme p-2" id="brands-slider">
                        @foreach($brands as $brand)
                            <div class="text-center">
                                <a href="{{route('products',['id'=> $brand['id'],'data_from'=>'brand','page'=>1])}}"
                                   class="__brand-item">
                                    <img
                                        onerror="this.src='{{asset('public/assets/front-end/img/image-place-holder.png')}}'"
                                        src="{{asset("storage/app/public/brand/$brand->image")}}"
                                        alt="{{$brand->name}}">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </section>
        @endif


         <div class="__inline-61">
        <!-- Hotel Reservations -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Hotel Reservations</h3>

            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1571003123894-1f0594d2b5d9?fit=crop&w=600&h=450" alt="Luxury Hotel">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Luxury Hotels</h4>
                            <p class="service-description">Book 5-star accommodations.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://plus.unsplash.com/premium_photo-1687960116957-ab813e1e66e6?q=80&auto=format&fit=crop&w=600&h=450" alt="Hotel Pool">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">City Hotels</h4>
                            <p class="service-description">Convenient urban stays.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1454388683759-ee76c15fee26?fit=crop&w=600&h=450" alt="Hotel Pool">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">City Hotels</h4>
                            <p class="service-description">Convenient urban stays.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>
                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>

        <!-- Flight Reservations -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Flight Reservations</h3>

            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://plus.unsplash.com/premium_photo-1684407617295-b9324ba41413?fit=crop&w=600&h=450" alt="Airplane">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">International Flights</h4>
                            <p class="service-description">Travel the world easily.</p>
                            <a href="#" class="service-link">Search Flights →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1741795820235-a0e96e4ff6e4?fit=crop&w=600&h=450" alt="Airplane">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">International Flights</h4>
                            <p class="service-description">Travel the world easily.</p>
                            <a href="#" class="service-link">Search Flights →</a>
                        </div>
                    </div>

                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src=" https://images.unsplash.com/photo-1655722724447-2d2a3071e7f8?fit=crop&w=600&h=450" alt="Airport">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Domestic Flights</h4>
                            <p class="service-description">Affordable local travel.</p>
                            <a href="#" class="service-link">Search Flights →</a>
                        </div>
                    </div>
                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>

        <!-- Resort Getaways -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Resort Getaways</h3>

            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1549294413-26f195200c16?fit=crop&w=600&h=450" alt="Tropical Resort">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Tropical Resorts</h4>
                            <p class="service-description">Relax by the beach.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1605538032404-d7f061325b90?fit=crop&w=600&h=450" alt="Resort Villa">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Mountain Resorts</h4>
                            <p class="service-description">Scenic getaway retreats.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>

                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1600585154340-be6161a56a0c?fit=crop&w=600&h=450" alt="Resort Villa">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Mountain Resorts</h4>
                            <p class="service-description">Scenic getaway retreats.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>
                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>



        <!-- Land Investments -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Land Investments</h3>

            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://plus.unsplash.com/premium_photo-1744428942536-c2348bb9eedc?fit=crop&w=600&h=450" alt="Greenfield">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Prime Land</h4>
                            <p class="service-description">Invest in scenic plots.</p>
                            <a href="#" class="service-link">Explore Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1685266326473-5b99c3d08a7e?fit=crop&w=600&h=450" alt="Scenic Land">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Housing Land</h4>
                            <p class="service-description">Ideal for businesses.</p>
                            <a href="#" class="service-link">Explore Now →</a>
                        </div>
                    </div>

                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1648677186646-24e69fa29bb4?fit=crop&w=600&h=450" alt="Scenic Land">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Commercial Land</h4>
                            <p class="service-description">Ideal for businesses.</p>
                            <a href="#" class="service-link">Explore Now →</a>
                        </div>
                    </div>
                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>

        <!-- Plot Purchases -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Plot Purchases</h3>

            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://plus.unsplash.com/premium_photo-1673688832109-951d15d11d76?fit=crop&w=600&h=450" alt="Residential Plot">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Residential Plots</h4>
                            <p class="service-description">Build your dream home.</p>
                            <a href="#" class="service-link">Buy Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1600505850000-9e71c0fee2fa?fit=crop&w=600&h=450" alt="Plot Markers">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Urban Plots</h4>
                            <p class="service-description">Prime city locations.</p>
                            <a href="#" class="service-link">Buy Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1709078990420-bb08c1ca491f?fit=crop&w=600&h=450" alt="Plot Markers">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Urban Plots</h4>
                            <p class="service-description">Prime city locations.</p>
                            <a href="#" class="service-link">Buy Now →</a>
                        </div>
                    </div>
                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>

        <!-- Apartment Rentals -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Apartment Rentals</h3>

            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1522708323590-d24dbb6b0267?fit=crop&w=600&h=450" alt="Apartment Interior">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">City Apartments</h4>
                            <p class="service-description">Modern urban living.</p>
                            <a href="#" class="service-link">Rent Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://plus.unsplash.com/premium_photo-1711412119767-d0a4de960859?fit=crop&w=600&h=450" alt="Luxury Apartment">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Luxury Apartments</h4>
                            <p class="service-description">Premium city rentals.</p>
                            <a href="#" class="service-link">Rent Now →</a>
                        </div>
                    </div>

                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1707484687082-9493754d389f?fit=crop&w=600&h=450" alt="Luxury Apartment">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Luxury Apartments</h4>
                            <p class="service-description">Premium city rentals.</p>
                            <a href="#" class="service-link">Rent Now →</a>
                        </div>
                    </div>
                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>

        <!-- Agricultural Ventures -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Farming</h3>

            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src=" https://images.unsplash.com/photo-1598871570273-a52887b78f97?fit=crop&w=600&h=450" alt="Vegetable Farm">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Vegetable Farms</h4>
                            <p class="service-description">Sustainable organic farming.</p>
                            <a href="#" class="service-link">Invest Now →</a>
                        </div>
                    </div>

                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1629313471551-ba2052384b9b?fit=crop&w=600&h=450" alt="Cattle Farm">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Dairy Farms</h4>
                            <p class="service-description">Eco-friendly cattle farming.</p>
                            <a href="#" class="service-link">Invest Now →</a>
                        </div>
                    </div>

                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://plus.unsplash.com/premium_photo-1661963727132-9211f11634d5?fit=crop&w=600&h=450" alt="Cattle Farm">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Poultry Farms</h4>
                            <p class="service-description">Eco-friendly Poultry farming.</p>
                            <a href="#" class="service-link">Invest Now →</a>
                        </div>
                    </div>

                      <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1731552467185-aadc0dc27c7e?fit=crop&w=600&h=450" alt="Cattle Farm">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Fish Farms</h4>
                            <p class="service-description">Eco-friendly Fish farming.</p>
                            <a href="#" class="service-link">Invest Now →</a>
                        </div>
                    </div>


                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>

        <!-- Agricultural Ventures -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Project Salt</h3>

            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1534938364841-81528cf83b0a?fit=crop&w=600&h=450" alt="Vegetable Farm">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Salt Project</h4>
                            <p class="service-description">Salt Project</p>
                            <a href="#" class="service-link">Invest Now →</a>
                        </div>
                    </div> <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1671574374293-2a333dd34a77?fit=crop&w=600&h=450" alt="Vegetable Farm">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Salt Project</h4>
                            <p class="service-description">Salt Project</p>
                            <a href="#" class="service-link">Invest Now →</a>
                        </div>
                    </div> <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1560872236-a2550e4f2d4f?fit=crop&w=600&h=450" alt="Vegetable Farm">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Salt Project</h4>
                            <p class="service-description">Salt Project</p>
                            <a href="#" class="service-link">Invest Now →</a>
                        </div>
                    </div>
                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>

        <!-- Industrial Projects -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Industrial Projects</h3>

            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://plus.unsplash.com/premium_photo-1682144938545-a55e55554071?fit=crop&w=600&h=450" alt="Industrial Plant">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Manufacturing Plants</h4>
                            <p class="service-description">Modern industrial facilities.</p>
                            <a href="#" class="service-link">Explore Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://plus.unsplash.com/premium_photo-1682144932026-f5ea5364757a?fit=crop&w=600&h=450" alt="Factory">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Processing Units</h4>
                            <p class="service-description">Innovative industrial solutions.</p>
                            <a href="#" class="service-link">Explore Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1642212483481-d4c1bb23e901?fit=crop&w=600&h=450" alt="Factory">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Processing Units</h4>
                            <p class="service-description">Innovative industrial solutions.</p>
                            <a href="#" class="service-link">Explore Now →</a>
                        </div>
                    </div>
                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>

        <!-- Healthcare Services -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Healthcare Services</h3>
            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://plus.unsplash.com/premium_photo-1661627583616-fa2c360deb3f?q=80&w=1470&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D?fit=crop&w=600&h=450" alt="Hospital">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Modern Hospitals</h4>
                            <p class="service-description">World-class medical care.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">

                            <img src="https://images.unsplash.com/photo-1631507623112-0092cef9c70d?fit=crop&w=600&h=450" alt="Healthcare Facility">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Specialty Clinics</h4>
                            <p class="service-description">Expert healthcare services.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>  <div class="service-card">
                        <div class="service-image-slider owl-carousel">

                            <img src="https://images.unsplash.com/photo-1730701878011-a423ec61c328?fit=crop&w=600&h=450" alt="Healthcare Facility">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Specialty Clinics</h4>
                            <p class="service-description">Expert healthcare services.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>
                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>

        <!-- Educational Institutions -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Educational Institutions</h3>

            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1523050854058-8df90110c9f1?fit=crop&w=600&h=450" alt="University">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Universities</h4>
                            <p class="service-description">Top academic programs.</p>
                            <a href="#" class="service-link">Enroll Now →</a>
                        </div>
                    </div>

                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://plus.unsplash.com/premium_photo-1661963287421-40c9f4f7041d?fit=crop&w=600&h=450" alt="Classroom">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Schools</h4>
                            <p class="service-description">Quality education for all.</p>
                            <a href="#" class="service-link">Enroll Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1495727034151-8fdc73e332a8?fit=crop&w=600&h=450" alt="Classroom">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Schools</h4>
                            <p class="service-description">Quality education for all.</p>
                            <a href="#" class="service-link">Enroll Now →</a>
                        </div>
                    </div>
                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>



        <!-- Adventure Tours -->
        <section class="container rtl mt-3">
            <div class="service-gallery-header">
                <h3 class="service-gallery-title">Adventure Tours</h3>

            </div>
            <div class="service-gallery-container">
                <div class="service-nav-btn service-prev-btn">
                    <i class="czi-arrow-left"></i>
                </div>
                <div class="service-gallery-slider owl-carousel">
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">
                            <img src="https://images.unsplash.com/photo-1626239889138-a7e4f971059e?fit=crop&w=600&h=450" alt="Mountain Adventure">

                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Cox Bazar Tour</h4>
                            <p class="service-description">Thrilling hiking adventures.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">

                            <img src="https://images.unsplash.com/photo-1587222318667-31212ce2828d?fit=crop&w=600&h=450" alt="Beach Adventure">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Saint Martin Tours</h4>
                            <p class="service-description">Wildlife exploration tours.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>
                    <div class="service-card">
                        <div class="service-image-slider owl-carousel">

                            <img src="https://images.unsplash.com/photo-1585123388867-3bfe6dd4bdbf?fit=crop&w=600&h=450" alt="Beach Adventure">
                        </div>
                        <div class="service-details">
                            <h4 class="service-name">Bandarban Tours</h4>
                            <p class="service-description">Wildlife exploration tours.</p>
                            <a href="#" class="service-link">Book Now →</a>
                        </div>
                    </div>
                </div>
                <div class="service-nav-btn service-next-btn">
                    <i class="czi-arrow-right"></i>
                </div>
            </div>
        </section>


    </div>


        <!-- Continue with other services (Resort, Housing, Land, etc.) following the same pattern -->

        <!-- Products grid (featured products)-->
        @if ($featured_products->count() > 0 )
            <div class="container mb-4">
                <div class="row __inline-62">
                    <div class="col-md-12">
                        <div class="feature-product-title">
                            {{ \App\CPU\translate('featured_products')}}
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="feature-product">
                            <div class="carousel-wrap p-1">
                                <div class="owl-carousel owl-theme " id="featured_products_list">
                                    @foreach($featured_products as $product)
                                        <div>
                                            @include('web-views.partials._feature-product',['product'=>$product, 'decimal_point_settings'=>$decimal_point_settings])
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        {{--featured deal--}}

        @if($web_config['featured_deals'])
            <section class="featured_deal rtl">
                <div class="container">
                    <div class="row __featured-deal-wrap" style="background: {{$web_config['primary_color']}};">
                        <div class="col-12 pb-2">
                            @if (count($web_config['featured_deals'])>0)
                                <div
                                    class="{{Session::get('direction') === "rtl" ? 'text-left ml-lg-3' : 'text-right mr-lg-3'}}">
                                    <a class="text-capitalize text-white"
                                       href="{{route('products',['data_from'=>'featured_deal'])}}">
                                        {{ \App\CPU\translate('view_all')}}
                                        <i class="czi-arrow-{{Session::get('direction') === "rtl" ? 'left mr-1 ml-n1 mt-1' : 'right ml-1'}} text-white"></i>
                                    </a>
                                </div>
                            @endif
                        </div>
                        <div class="col-xl-3 col-lg-4">
                            <div class="m-lg-4 mb-4">
                                <span
                                    class="featured_deal_title __pt-12">{{ \App\CPU\translate('featured_deal')}}</span>
                                <br>

                                <span class="text-white text-left">{{ \App\CPU\translate('See the latest deals and exciting new offers')}}!</span>

                            </div>

                        </div>

                        <div
                            class="col-xl-9 col-lg-8 d-flex align-items-center justify-content-center {{Session::get('direction') === "rtl" ? 'pl-md-4' : 'pr-md-4'}}">
                            <div class="owl-carousel owl-theme" id="web-feature-deal-slider">
                                @foreach($web_config['featured_deals'] as $key=>$product)
                                    @include('web-views.partials._feature-deal-product',['product'=>$product, 'decimal_point_settings'=>$decimal_point_settings])
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        @endif
        {{--deal of the day--}}
        <div class="container rtl">
            <div class="row g-4 pt-2 mt-0 mb-4 pb-2 __deal-of">
                {{-- Deal of the day/Recommended Product --}}
                <div class="col-xl-3 col-md-4">
                    <div class="deal_of_the_day h-100" style="background: {{$web_config['primary_color']}}">
                        @if(isset($deal_of_the_day) && isset($deal_of_the_day->product))
                            <div class="d-flex justify-content-center align-items-center __w-70p mx-auto">
                                <h1 class="align-items-center text-white"> {{ \App\CPU\translate('deal_of_the_day') }}</h1>
                            </div>
                            <div class="recomanded-product-card">

                                <div class="d-flex justify-content-center align-items-center __pt-20 __m-20-r">
                                    <img class="__rounded-top"
                                         src="{{\App\CPU\ProductManager::product_image_path('thumbnail')}}/{{$deal_of_the_day->product['thumbnail']}}"
                                         onerror="this.src='{{asset('public/assets/front-end/img/image-place-holder.png')}}'"
                                         alt="">
                                </div>
                                <div class="__i-1">
                                    <div class="text-left __p-20px">

                                        @php($overallRating = \App\CPU\ProductManager::get_overall_rating($deal_of_the_day->product['reviews']))
                                        <div class="rating-show">
                                            <h5 class="font-semibold" style="color: {{$web_config['primary_color']}}">
                                                {{\Illuminate\Support\Str::limit($deal_of_the_day->product['name'],30)}}
                                            </h5>
                                            <span class="d-inline-block font-size-sm text-body">
                                            @for($inc=0;$inc<5;$inc++)
                                                    @if($inc<$overallRating[0])
                                                        <i class="p-0 sr-star czi-star-filled active"></i>
                                                    @else
                                                        <i class="p-0 sr-star czi-star __color-fea569"></i>
                                                    @endif
                                                @endfor
                                            <label
                                                class="badge-style">( {{$deal_of_the_day->product->reviews_count}} )</label>
                                        </span>
                                        </div>
                                        <div class="">

                                            @if($deal_of_the_day->product->discount > 0)
                                                <strike class="__text-12px __color-E96A6A __pl-2">
                                                    {{\App\CPU\Helpers::currency_converter($deal_of_the_day->product->ecommerce_price)}}
                                                </strike>
                                            @endif
                                            <span class="text-accent __text-22px __m-10px">
                                            {{\App\CPU\Helpers::currency_converter(
                                                $deal_of_the_day->product->ecommerce_price-(\App\CPU\Helpers::get_product_discount($deal_of_the_day->product,$deal_of_the_day->product->ecommerce_price))
                                            )}}
                                        </span>

                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="recomanded-buy-button">
                                <button class="buy_btn" style="color:{{$web_config['primary_color']}}"
                                        onclick="location.href='{{route('product',$deal_of_the_day->product->slug)}}'">{{\App\CPU\translate('buy_now')}}
                                </button>
                            </div>
                        @else
                            @php($product=\App\Model\Product::active()->inRandomOrder()->first())
                            @if(isset($product))
                                <div class="d-flex justify-content-center align-items-center">
                                    <h1 class="text-white"> {{ \App\CPU\translate('recommended_product') }}</h1>
                                </div>
                                <div class="recomanded-product-card">

                                    <div class="d-flex justify-content-center align-items-center  __pt-20 __m-20-r">
                                        <img
                                            src="{{\App\CPU\ProductManager::product_image_path('thumbnail')}}/{{$product['thumbnail']}}"
                                            onerror="this.src='{{asset('public/assets/front-end/img/image-place-holder.png')}}'"
                                            alt="">
                                    </div>
                                    <div class="__i-1">
                                        <div class="text-left __p-20px">

                                            @php($overallRating = \App\CPU\ProductManager::get_overall_rating($product['reviews']))
                                            <div class="rating-show">
                                                <h5 class="font-semibold"
                                                    style="color: {{$web_config['primary_color']}}">
                                                    {{\Illuminate\Support\Str::limit($product['name'],40)}}
                                                </h5>
                                                <span class="d-inline-block font-size-sm text-body">
                                                @for($inc=0;$inc<5;$inc++)
                                                        @if($inc<$overallRating[0])
                                                            <i class="p-0 sr-star czi-star-filled active"></i>
                                                        @else
                                                            <i class="p-0 sr-star czi-star __color-fea569"></i>
                                                        @endif
                                                    @endfor
                                                <label class="badge-style">( {{$product->reviews_count}} )</label>
                                            </span>
                                            </div>
                                            <div class="float-right">

                                                @if($product->discount > 0)
                                                    <strike class="__text-12px __color-E96A6A">
                                                        {{\App\CPU\Helpers::currency_converter($product->ecommerce_price)}}
                                                    </strike>
                                                @endif
                                                <span class="text-accent __text-22px __m-10px">
                                                {{\App\CPU\Helpers::currency_converter(
                                                    $product->ecommerce_price-(\App\CPU\Helpers::get_product_discount($product,$product->ecommerce_price))
                                                )}}
                                            </span>

                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="recomanded-buy-button">
                                    <button class="buy_btn" style="color:{{$web_config['primary_color']}}"
                                            onclick="location.href='{{route('product',$product->slug)}}'">{{\App\CPU\translate('buy_now')}}
                                    </button>
                                </div>

                            @endif
                        @endif
                    </div>

                </div>
                {{-- Latest products --}}
                <div class="col-xl-9 col-md-8 mt-2">
                    <div class="latest-product-margin">
                        <div class="d-flex justify-content-between">
                            <div class="text-center">
                                <span
                                    class="for-feature-title __text-22px font-bold text-center">{{ \App\CPU\translate('latest_products')}}</span>
                            </div>
                            <div class="mr-1">
                                <a class="text-capitalize view-all-text"
                                   href="{{route('products',['data_from'=>'latest'])}}">
                                    {{ \App\CPU\translate('view_all')}}
                                    <i class="czi-arrow-{{Session::get('direction') === "rtl" ? 'left mr-1 ml-n1 mt-1 float-left' : 'right ml-1 mr-n1'}}"></i>
                                </a>
                            </div>
                        </div>

                        <div class="row mt-0 g-3">
                            @php($latest_products = $latest_products->take(8))
                            @foreach($latest_products as $product)
                                <div class="col-xl-3 col-sm-4 col-md-6 col-lg-4 col-6">
                                    <div>
                                        @include('web-views.partials._single-product',['product'=>$product,'decimal_point_settings'=>$decimal_point_settings])
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>


        @if (isset($main_section_banner))
            <div class="container rtl mb-3">
                <div class="row">
                    <div class="col-12 pl-0 pr-0">
                        <a href="{{$main_section_banner->url}}"
                           class="cursor-pointer">
                            <img class="d-block footer_banner_img __inline-63"
                                 onerror="this.src='{{asset('public/assets/front-end/img/image-place-holder.png')}}'"
                                 src="{{asset('storage/app/public/banner')}}/{{$main_section_banner['photo']}}">
                        </a>
                    </div>
                </div>
            </div>
        @endif

        @php($business_mode=\App\CPU\Helpers::get_business_settings('business_mode'))
        {{--categries--}}
        <div class="container rtl">
            <div class="row">
                @if ($business_mode == 'multi')
                    <div class="col-md-6">
                        <div class="card __shadow h-100">
                            <div class="card-body">
                                <div class="row d-flex justify-content-between">
                                    <div class="categories-title">
                                        <span class="font-semibold">{{ \App\CPU\translate('categories')}}</span>
                                    </div>
                                    <div class="categories-view-all">
                                        <a class="text-capitalize view-all-text"
                                           href="{{route('categories')}}">{{ \App\CPU\translate('view_all')}}
                                            <i class="czi-arrow-{{Session::get('direction') === "rtl" ? 'left mr-1 ml-n1 mt-1 float-left' : 'right ml-1 mr-n1'}}"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="row mt-3">
                                    @foreach($categories as $key=>$category)

                                        @if ($key<10)
                                            <div class="text-center __m-5px __cate-item">
                                                <a href="{{route('products',['id'=> $category['id'],'data_from'=>'category','page'=>1])}}">
                                                    <div class="__img">
                                                        <img
                                                            onerror="this.src='{{asset('public/assets/front-end/img/image-place-holder.png')}}'"
                                                            src="{{asset("storage/app/public/category/$category->icon")}}"
                                                            alt="{{$category->name}}">
                                                    </div>
                                                    <p class="text-center small mt-2">{{Str::limit($category->name, 12)}}</p>
                                                </a>
                                            </div>
                                        @endif

                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="col-md-12">
                        <div class="card h-100">
                            <div class="card-body">
                                <div class="row d-flex justify-content-between">
                                    <div
                                        style="{{Session::get('direction') === "rtl" ? 'margin-right: 20px;' : 'margin-left: 22px;'}}">
                                        <span class="font-semibold">{{ \App\CPU\translate('categories')}}</span>
                                    </div>
                                    <div
                                        style="{{Session::get('direction') === "rtl" ? 'margin-left: 15px;' : 'margin-right: 13px;'}}">
                                        <a class="text-capitalize view-all-text"
                                           href="{{route('categories')}}">{{ \App\CPU\translate('view_all')}}
                                            <i class="czi-arrow-{{Session::get('direction') === "rtl" ? 'left mr-1 ml-n1 mt-1 float-left' : 'right ml-1 mr-n1'}}"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="row mt-3">
                                    @foreach($categories as $key=>$category)
                                        @if ($key<11)
                                            <div class="text-center __m-5px __cate-item">
                                                <a href="{{route('products',['id'=> $category['id'],'data_from'=>'category','page'=>1])}}">
                                                    <div class="__img">
                                                        <img
                                                            onerror="this.src='{{asset('public/assets/front-end/img/image-place-holder.png')}}'"
                                                            src="{{asset("storage/app/public/category/$category->icon")}}"
                                                            alt="{{$category->name}}">
                                                        <p class="text-center small mt-1">{{Str::limit($category->name, 12)}}</p>
                                                    </div>
                                                </a>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                <!-- top sellers -->

                @if ($business_mode == 'multi')
                    @if(count($top_sellers) > 0)
                        <div class="col-md-6 mt-2 mt-md-0 seller-card">
                            <div class="card __shadow h-100">
                                <div class="card-body">
                                    <div class="row d-flex justify-content-between">
                                        <div class="seller-list-title">
                                            <span class="font-semibold">{{ \App\CPU\translate('sellers')}}</span>
                                        </div>
                                        <div class="seller-list-view-all">
                                            <a class="text-capitalize view-all-text"
                                               href="{{route('sellers')}}">{{ \App\CPU\translate('view_all')}}
                                                <i class="czi-arrow-{{Session::get('direction') === "rtl" ? 'left mr-1 ml-n1 mt-1 float-left' : 'right ml-1 mr-n1'}}"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="row mt-3">
                                        @foreach($top_sellers as $key=>$seller)
                                            @if ($key<10)

                                                @if($seller->shop)
                                                    <div class="__m-5px __cate-item">
                                                        <a href="{{route('shopView',['id'=>$seller['id']])}}">
                                                            <div class="__img circle position-relative">
                                                                @php($shop=$seller->shop)
                                                                @php($current_date = date('Y-m-d'))
                                                                @php($start_date = date('Y-m-d', strtotime($shop['vacation_start_date'])))
                                                                @php($end_date = date('Y-m-d', strtotime($shop['vacation_end_date'])))
                                                                @if($shop->vacation_status && ($current_date >= $start_date) && ($current_date <= $end_date))
                                                                    <span class="temporary-closed">
                                                                        <small>{{\App\CPU\translate('closed_now')}}</small>
                                                                    </span>
                                                                @elseif($shop->temporary_close)
                                                                    <span class="temporary-closed">
                                                                        <small>{{\App\CPU\translate('closed_now')}}</small>
                                                                    </span>
                                                                @endif
                                                                <img
                                                                    onerror="this.src='{{asset('public/assets/front-end/img/image-place-holder.png')}}'"
                                                                    src="{{asset("storage/app/public/shop")}}/{{$seller->shop->image}}">
                                                            </div>
                                                            <p class="text-center small mt-2">{{Str::limit($seller->shop->name, 14)}}</p>
                                                        </a>
                                                    </div>
                                                @endif
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                @endif
            </div>
        </div>


        <div class="container rtl mt-4">
            <div class="arrival-title">
                <div>
                    <img src="{{asset("public/assets/front-end/png/new-arrivals.png")}}" alt="">

                </div>
                <div class="pl-2">
                    {{ \App\CPU\translate('ARRIVALS')}}
                </div>
            </div>
        </div>
        <div class="container rtl mb-3 overflow-hidden">
            <div class="py-2">
                <div class="new_arrival_product">
                    <div class="carousel-wrap">
                        <div class="owl-carousel owl-theme" id="new-arrivals-product">
                            @foreach($latest_products as $key=>$product)

                                @include('web-views.partials._product-card-1',['product'=>$product,'decimal_point_settings'=>$decimal_point_settings])

                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container rtl">
            <div class="row g-3">
                <div class="col-md-6">
                    <div class="card card __shadow h-100">
                        <div class="card-body p-xl-35">
                            <div class="row d-flex justify-content-between mx-1 mb-3">
                                <div>
                                    <img class="size-30"
                                         src="{{asset("public/assets/front-end/png/best sellings.png")}}"
                                         alt="">
                                    <span class="font-bold pl-1">{{ \App\CPU\translate('best sellings')}}</span>
                                </div>
                                <div>
                                    <a class="text-capitalize view-all-text"
                                       href="{{route('products',['data_from'=>'best-selling','page'=>1])}}">{{ \App\CPU\translate('view_all')}}
                                        <i class="czi-arrow-{{Session::get('direction') === "rtl" ? 'left mr-1 ml-n1 mt-1 float-left' : 'right ml-1 mr-n1'}}"></i>
                                    </a>
                                </div>
                            </div>
                            <div>
                                @foreach($bestSellProduct as $key=>$bestSell)
                                    @if($bestSell->product && $key<3)
                                        <a class="__best-selling" href="{{route('product',$bestSell->product->slug)}}">
                                            @if($bestSell->product->discount > 0)
                                                <div class="d-flex"
                                                     style="top:0;position:absolute;{{Session::get('direction') === "rtl" ? 'right:0;' : 'left:0;'}}">
                                                    <span class="for-discoutn-value p-1 pl-2 pr-2"
                                                          style="{{Session::get('direction') === "rtl" ? 'border-radius:0px 5px' : 'border-radius:5px 0px'}};">
                                                        @if ($bestSell->product->discount_type == 'percent')
                                                            {{round($bestSell->product->discount)}}%
                                                        @elseif($bestSell->product->discount_type =='flat')
                                                            {{\App\CPU\Helpers::currency_converter($bestSell->product->discount)}}
                                                        @endif {{\App\CPU\translate('off')}}
                                                    </span>
                                                </div>
                                            @endif
                                            <div class="d-flex flex-wrap p-2">
                                                <div class="best-selleing-image">
                                                    <img class="rounded"
                                                         onerror="this.src='{{asset('public/assets/front-end/img/image-place-holder.png')}}'"
                                                         src="{{\App\CPU\ProductManager::product_image_path('thumbnail')}}/{{$bestSell->product['thumbnail']}}"
                                                         alt="Product"/>
                                                </div>
                                                <div class="best-selling-details">
                                                    <h6 class="widget-product-title">
                                                    <span class="ptr">
                                                        {{\Illuminate\Support\Str::limit($bestSell->product['name'],100)}}
                                                    </span>
                                                    </h6>
                                                    @php($bestSell_overallRating = \App\CPU\ProductManager::get_overall_rating($bestSell->product['reviews']))
                                                    <div class="rating-show">
                                                    <span class="d-inline-block font-size-sm text-body">
                                                        @for($inc=0;$inc<5;$inc++)
                                                            @if($inc<$bestSell_overallRating[0])
                                                                <i class="p-0 sr-star czi-star-filled active"></i>
                                                            @else
                                                                <i class="p-0 sr-star czi-star __color-fea569"></i>
                                                            @endif
                                                        @endfor
                                                        <label class="badge-style">( {{$bestSell->product->reviews_count}} )</label>
                                                    </span>
                                                    </div>
                                                    <div>
                                                        @if($bestSell->product->discount > 0)
                                                            <strike class="__color-E96A6A __text-12px">
                                                                {{\App\CPU\Helpers::currency_converter($bestSell->product->ecommerce_price)}}
                                                            </strike>
                                                        @endif
                                                    </div>
                                                    <div class="widget-product-meta">
                                                    <span class="text-accent">
                                                        {{\App\CPU\Helpers::currency_converter(
                                                        $bestSell->product->ecommerce_price-(\App\CPU\Helpers::get_product_discount($bestSell->product,$bestSell->product->ecommerce_price))
                                                        )}}
                                                    </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mt-2 mt-md-0">
                    <div class="card card __shadow h-100">
                        <div class="card-body p-xl-35">
                            <div class="row d-flex justify-content-between mx-1 mb-3">
                                <div>
                                    <img class="size-30" src="{{asset("public/assets/front-end/png/top-rated.png")}}"
                                         alt="">
                                    <span class="font-bold pl-1">{{ \App\CPU\translate('top rated')}}</span>
                                </div>
                                <div>
                                    <a class="text-capitalize view-all-text"
                                       href="{{route('products',['data_from'=>'top-rated','page'=>1])}}">{{ \App\CPU\translate('view_all')}}
                                        <i class="czi-arrow-{{Session::get('direction') === "rtl" ? 'left mr-1 ml-n1 mt-1 float-left' : 'right ml-1 mr-n1'}}"></i>
                                    </a>
                                </div>
                            </div>
                            <div>
                                @foreach($topRated as $key=>$top)
                                    @if($top->product && $key<3)
                                        <a class="__best-selling" href="{{route('product',$top->product->slug)}}">
                                            @if($top->product->discount > 0)
                                                <div class="d-flex"
                                                     style="top:0;position:absolute;{{Session::get('direction') === "rtl" ? 'right:0;' : 'left:0;'}}">
                                                    <span class="for-discoutn-value p-1 pl-2 pr-2"
                                                          style="{{Session::get('direction') === "rtl" ? 'border-radius:0px 5px' : 'border-radius:5px 0px'}};">
                                                        @if ($top->product->discount_type == 'percent')
                                                            {{round($top->product->discount)}}%
                                                        @elseif($top->product->discount_type =='flat')
                                                            {{\App\CPU\Helpers::currency_converter($top->product->discount)}}
                                                        @endif {{\App\CPU\translate('off')}}
                                                    </span>
                                                </div>
                                            @endif
                                            <div class="d-flex flex-wrap p-2">
                                                <div class="top-rated-image">
                                                    <img class="rounded"
                                                         onerror="this.src='{{asset('public/assets/front-end/img/image-place-holder.png')}}'"
                                                         src="{{\App\CPU\ProductManager::product_image_path('thumbnail')}}/{{$top->product['thumbnail']}}"
                                                         alt="Product"/>
                                                </div>
                                                <div class="top-rated-details">
                                                    <h6 class="widget-product-title">
                                                    <span class="ptr">
                                                        {{\Illuminate\Support\Str::limit($top->product['name'],100)}}
                                                    </span>
                                                    </h6>
                                                    @php($top_overallRating = \App\CPU\ProductManager::get_overall_rating($top->product['reviews']))
                                                    <div class="rating-show">
                                                    <span class="d-inline-block font-size-sm text-body">
                                                        @for($inc=0;$inc<5;$inc++)
                                                            @if($inc<$top_overallRating[0])
                                                                <i class="p-0 sr-star czi-star-filled active"></i>
                                                            @else
                                                                <i class="p-0 sr-star czi-star __color-fea569"></i>
                                                            @endif
                                                        @endfor
                                                        <label
                                                            class="badge-style">( {{$top->product->reviews_count}} )</label>
                                                    </span>
                                                    </div>
                                                    <div>
                                                        @if($top->product->discount > 0)
                                                            <strike class="__text-12px __color-E96A6A">
                                                                {{\App\CPU\Helpers::currency_converter($top->product->ecommerce_price)}}
                                                            </strike>
                                                        @endif
                                                    </div>
                                                    <div class="widget-product-meta">
                                                    <span class="text-accent">
                                                        {{\App\CPU\Helpers::currency_converter(
                                                        $top->product->ecommerce_price-(\App\CPU\Helpers::get_product_discount($top->product,$top->product->ecommerce_price))
                                                        )}}
                                                    </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                    @endif
                                @endforeach
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Banner  --}}
        <div class="container rtl py-4 ">
            <div class="row g-3">
                @foreach(\App\Model\Banner::where('banner_type','Footer Banner')->where('published',1)->orderBy('id','desc')->take(2)->get() as $banner)
                    <div class="col-md-6">
                        <a href="{{$banner->url}}" class="d-block">
                            <img class="footer_banner_img"
                                 onerror="this.src='{{asset('public/assets/front-end/img/image-place-holder.png')}}'"
                                 src="{{asset('storage/app/public/banner')}}/{{$banner['photo']}}">
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
        {{-- Categorized product --}}
        @foreach($home_categories as $category)
            <section class="container rtl pb-4">
                <!-- Heading-->
                <div class="__p-20px rounded bg-white">
                    <div class="flex-wrap __gap-6px flex-between pl-xl-4">
                        <div class="category-product-view-title">
                        <span
                            class="for-feature-title {{Session::get('direction') === "rtl" ? 'float-right' : 'float-left'}} font-bold __text-20px text-uppercase"
                            style="{{Session::get('direction') === "rtl" ? 'text-align:right;' : 'text-align:left;'}}">
                                {{Str::limit($category['name'],18)}}
                        </span>
                        </div>
                        <div class="category-product-view-all">
                            <a class="text-capitalize view-all-text "
                               href="{{route('products',['id'=> $category['id'],'data_from'=>'category','page'=>1])}}">{{ \App\CPU\translate('view_all')}}
                                <i class="czi-arrow-{{Session::get('direction') === "rtl" ? 'left mr-1 ml-n1 mt-1 float-left' : 'right ml-1 mr-n1'}}"></i>
                            </a>

                        </div>
                    </div>

                    <div class="row mt-2 justify-content-between g-3">
                        <div class="col-md-3 col-12">
                            <a href="{{route('products',['id'=> $category['id'],'data_from'=>'category','page'=>1])}}"
                               class="cursor-pointer d-block h-100 __cate-product-side-img">
                                <img class="h-100"
                                     onerror="this.src='{{asset('public/assets/front-end/img/image-place-holder.png')}}'"
                                     src="{{asset('storage/app/public/category')}}/{{$category['icon']}}">
                            </a>
                        </div>
                        <div class="col-md-9 col-12 ">
                            <div class="row g-2">
                                @foreach($category['products'] as $key=>$product)
                                    @if ($key<4)
                                        <div class="col-md-3 col-sm-4 col-6">
                                            @include('web-views.partials._category-single-product',['product'=>$product,'decimal_point_settings'=>$decimal_point_settings])
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>


                    </div>
                </div>
            </section>
        @endforeach

        {{--delivery type --}}

        <div class="container rtl pb-4 pt-3">
            <div class="shipping-policy-web">
                <div class="row g-3">
                    <div class="col-md-3 d-flex justify-content-center">
                        <div class="shipping-method-system">
                            <div class="text-center">
                                <img class="size-60" src="{{asset("public/assets/front-end/png/delivery.png")}}"
                                     alt="">
                            </div>
                            <div class="text-center">
                                <p class="m-0">
                                    {{ \App\CPU\translate('Fast Delivery all accross the country')}}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 d-flex justify-content-center">
                        <div class="shipping-method-system">
                            <div class="text-center">
                                <img class="size-60" src="{{asset("public/assets/front-end/png/Payment.png")}}"
                                     alt="">
                            </div>
                            <div class="text-center">
                                <p class="m-0">
                                    {{ \App\CPU\translate('Safe Payment')}}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 d-flex justify-content-center">
                        <div class="shipping-method-system">
                            <div class="text-center">
                                <img class="size-60" src="{{asset("public/assets/front-end/png/money.png")}}"
                                     alt="">
                            </div>
                            <div class="text-center">
                                <p class="m-0">
                                    {{ \App\CPU\translate('7 Days Return Policy')}}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 d-flex justify-content-center">
                        <div class="shipping-method-system">
                            <div class="text-center">
                                <img class="size-60" src="{{asset("public/assets/front-end/png/Genuine.png")}}"
                                     alt="">
                            </div>
                            <div class="text-center">
                                <p class="m-0">
                                    {{ \App\CPU\translate('100% Authentic Products')}}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    {{-- Owl Carousel --}}
    <script src="{{asset('public/assets/front-end')}}/js/owl.carousel.min.js"></script>

      <script>
        $(document).ready(function(){
            $('.service-gallery-slider').each(function(){
                $(this).owlCarousel({
                    loop: true,
                    margin: 15,
                    nav: false,
                    dots: false,
                    responsive: {
                        0: { items: 1 },
                        600: { items: 2 },
                        1000: { items: 3 }
                    }
                });
            });
            $('.service-image-slider').each(function(){
                $(this).owlCarousel({
                    loop: true,
                    margin: 0,
                    nav: false,
                    dots: true,
                    items: 1
                });
            });
            $('.service-prev-btn').click(function(){
                $(this).closest('.service-gallery-container').find('.service-gallery-slider').trigger('prev.owl.carousel');
            });
            $('.service-next-btn').click(function(){
                $(this).closest('.service-gallery-container').find('.service-gallery-slider').trigger('next.owl.carousel');
            });
        });
    </script>
     <script>
        $(document).ready(function(){
            // Initialize service gallery sliders
            $('.service-gallery-slider').owlCarousel({
                loop: true,
                margin: 15,
                nav: false,
                dots: false,
                responsive: {
                    0: {
                        items: 1
                    },
                    576: {
                        items: 2
                    },
                    768: {
                        items: 3
                    },
                    992: {
                        items: 4
                    }
                }
            });

            // Initialize image sliders inside each service card
            $('.service-image-slider').owlCarousel({
                items: 1,
                loop: true,
                nav: false,
                dots: true,
                autoplay: true,
                autoplayTimeout: 3000,
                autoplayHoverPause: true
            });

            // Custom navigation for service galleries
            $('.service-next-btn').click(function() {
                $(this).siblings('.service-gallery-slider').trigger('next.owl.carousel');
            });

            $('.service-prev-btn').click(function() {
                $(this).siblings('.service-gallery-slider').trigger('prev.owl.carousel');
            });
        });
    </script>

    <script>
        $('#flash-deal-slider').owlCarousel({
            loop: false,
            autoplay: false,
            margin: 20,
            nav: true,
            navText: ["<i class='czi-arrow-left'></i>", "<i class='czi-arrow-right'></i>"],
            dots: false,
            autoplayHoverPause: true,
            '{{session('direction')}}': false,
            // center: true,
            responsive: {
                //X-Small
                0: {
                    items: 1
                },
                360: {
                    items: 1
                },
                375: {
                    items: 1
                },
                540: {
                    items: 2
                },
                //Small
                576: {
                    items: 2
                },
                //Medium
                768: {
                    items: 2
                },
                //Large
                992: {
                    items: 2
                },
                //Extra large
                1200: {
                    items: 2
                },
                //Extra extra large
                1400: {
                    items: 3
                }
            }
        })

        $('#web-feature-deal-slider').owlCarousel({
            loop: false,
            autoplay: true,
            margin: 20,
            nav: false,
            //navText: ["<i class='czi-arrow-left'></i>", "<i class='czi-arrow-right'></i>"],
            dots: false,
            autoplayHoverPause: true,
            '{{session('direction')}}': true,
            // center: true,
            responsive: {
                //X-Small
                0: {
                    items: 1
                },
                360: {
                    items: 1
                },
                375: {
                    items: 1
                },
                540: {
                    items: 2
                },
                //Small
                576: {
                    items: 2
                },
                //Medium
                768: {
                    items: 2
                },
                //Large
                992: {
                    items: 2
                },
                //Extra large
                1200: {
                    items: 2
                },
                //Extra extra large
                1400: {
                    items: 2
                }
            }
        })

        $('#new-arrivals-product').owlCarousel({
            loop: true,
            autoplay: false,
            margin: 20,
            nav: true,
            navText: ["<i class='czi-arrow-{{Session::get('direction') === "rtl" ? 'right' : 'left'}}'></i>", "<i class='czi-arrow-{{Session::get('direction') === "rtl" ? 'left' : 'right'}}'></i>"],
            dots: false,
            autoplayHoverPause: true,
            '{{session('direction')}}': true,
            // center: true,
            responsive: {
                //X-Small
                0: {
                    items: 1
                },
                360: {
                    items: 1
                },
                375: {
                    items: 1
                },
                540: {
                    items: 2
                },
                //Small
                576: {
                    items: 2
                },
                //Medium
                768: {
                    items: 2
                },
                //Large
                992: {
                    items: 2
                },
                //Extra large
                1200: {
                    items: 4
                },
                //Extra extra large
                1400: {
                    items: 4
                }
            }
        })
    </script>
    <script>
        $('#featured_products_list').owlCarousel({
            loop: true,
            autoplay: false,
            margin: 20,
            nav: true,
            navText: ["<i class='czi-arrow-left'></i>", "<i class='czi-arrow-right'></i>"],
            dots: false,
            autoplayHoverPause: true,
            '{{session('direction')}}': false,
            // center: true,
            responsive: {
                //X-Small
                0: {
                    items: 1
                },
                360: {
                    items: 1
                },
                375: {
                    items: 1
                },
                540: {
                    items: 2
                },
                //Small
                576: {
                    items: 2
                },
                //Medium
                768: {
                    items: 3
                },
                //Large
                992: {
                    items: 4
                },
                //Extra large
                1200: {
                    items: 5
                },
                //Extra extra large
                1400: {
                    items: 5
                }
            }
        });
    </script>
    <script>
        $('#brands-slider').owlCarousel({
            loop: false,
            autoplay: false,
            margin: 10,
            nav: false,
            '{{session('direction')}}': true,
            dots: true,
            autoplayHoverPause: true,
            // center: true,
            responsive: {
                //X-Small
                0: {
                    items: 4
                },
                360: {
                    items: 5
                },
                375: {
                    items: 5
                },
                540: {
                    items: 5
                },
                //Small
                576: {
                    items: 6
                },
                //Medium
                768: {
                    items: 7
                },
                //Large
                992: {
                    items: 9
                },
                //Extra large
                1200: {
                    items: 11
                },
                //Extra extra large
                1400: {
                    items: 12
                }
            }
        })
    </script>

    <script>
        $('#category-slider, #top-seller-slider').owlCarousel({
            loop: false,
            autoplay: false,
            margin: 20,
            nav: false,
            // navText: ["<i class='czi-arrow-left'></i>","<i class='czi-arrow-right'></i>"],
            dots: true,
            autoplayHoverPause: true,
            '{{session('direction')}}': true,
            // center: true,
            responsive: {
                //X-Small
                0: {
                    items: 2
                },
                360: {
                    items: 3
                },
                375: {
                    items: 3
                },
                540: {
                    items: 4
                },
                //Small
                576: {
                    items: 5
                },
                //Medium
                768: {
                    items: 6
                },
                //Large
                992: {
                    items: 8
                },
                //Extra large
                1200: {
                    items: 10
                },
                //Extra extra large
                1400: {
                    items: 11
                }
            }
        })
    </script>
@endpush

