@extends('layouts.back-end.app')

@section('title', \App\CPU\translate('Cash In Approval'))

@push('css_or_js')

@endpush

@section('content')
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 d-flex gap-2">
                <img width="20" src="{{asset('/public/assets/back-end/img/brand.png')}}" alt="">
                {{\App\CPU\translate('Cash In Approval ')}} 
                <span class="badge badge-soft-dark radius-50 fz-14">{{ $report->total() }}</span>
            </h2>
        </div>
        <!-- End Page Title -->

        <div class="row mt-20">
            <div class="col-md-12">
                <div class="card">
                    <!-- Data Table Top -->
                    <div class="px-3 py-4">
                        <div class="row g-2 flex-grow-1">
                            <div class="col-sm-8 col-md-6 col-lg-4">
                                <!-- Search -->
                                <form action="{{ url()->current() }}" method="GET">
                                    <div class="input-group input-group-custom input-group-merge">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <input id="datatableSearch_" type="search" name="search" class="form-control"
                                            placeholder="{{ \App\CPU\translate('Search_by_Transaction ID')}}" aria-label="Search by ID or name" value="{{ $search }}" required>
                                        <button type="submit" class="btn btn--primary input-group-text">{{ \App\CPU\translate('Search')}}</button>
                                    </div>
                                </form>

                                <!-- End Search -->
                            </div>
                            <div class="col-sm-4 col-md-6 col-lg-8 d-flex justify-content-end">

                                <!-- <button type="button" class="btn btn-outline--primary" data-toggle="dropdown">
                                    <i class="tio-download-to"></i>
                                    {{\App\CPU\translate('export')}}
                                    <i class="tio-chevron-down"></i>
                                </button> -->

                                <ul class="dropdown-menu">
                                    <!-- <li><a class="dropdown-item" href="{{ route('admin.brand.export') }}">Excel</a></li> -->
                                </ul>

                            </div>
                        </div>
                        <!-- End Row -->
                    </div>
                    <!-- End Data Table Top -->

                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table style="text-align: {{Session::get('direction') === "rtl" ? 'right' : 'left'}};"
                                class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                                <thead class="thead-light thead-50 text-capitalize">
                                    <tr>
                                        <th>{{ \App\CPU\translate('SL') }}</th>
                                        <th>{{ \App\CPU\translate('Time & Date') }}</th>
                                      
                                        <th>{{ \App\CPU\translate('Payment Method') }}</th>
                                          <th>{{ \App\CPU\translate('UserID') }}</th>
                                        <th>{{ \App\CPU\translate('Amount') }}</th>
                                        <th>{{ \App\CPU\translate('Transaction ID') }}</th>
                                        <th class="text-center">{{\App\CPU\translate('Upload Document') }}</th>
                                        <th class="text-center"> {{ \App\CPU\translate('Comment')}}</th>
                                        <th class="text-center"> {{ \App\CPU\translate('Status')}}</th>
                                        <th class="text-center"> {{ \App\CPU\translate('Action')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @php
                                $total = 0;
                            @endphp
                            @foreach($report as $key=>$banner)
                            @php
                            $user  = DB::table('users')->where('id', $banner->user_id)->first(); 
                            $total = $total + $banner->amount;
                            @endphp
                                <tr>
                                    <th scope="row">{{$key+1}}</th>
                                    <td>{{  date('h:i:s a d M Y ', strtotime($banner->created_at)) }}</td>
                                    <td>
                                       <img style="max-height: 20px;max-width: 100px;" src="{{ asset('storage/app/public/brand/'. payment_method_name($banner->method_id)->image ) }}" alt="" class="label-image" >
                                    </td>
                                    <td>{{$user->user_id}}</td>
                                    <td>{{$banner->amount}}</td>
                                    <td>{{$banner->trx_id}}</td>
                                    <td> <a download href="{{ asset('storage/app/public/brand/'. $banner->image ) }}"> <img style="max-height: 40px;" src="{{ asset('storage/app/public/brand/'. $banner->image ) }}" alt="" class="label-image" ></a></td>
                                    <td>{{$banner->comment}}</td>

                                    @if($banner->status == 0)
                                          <td><button class="btn btn-danger btn-sm">Pending</button></td>
                                    @elseif($banner->status== 1)
                                          <td><button class="btn btn-success btn-sm">Paid</button></td>
                                    @endif
                                    <td>
                                    @if($banner->status == 0)
                                            <div class="d-flex justify-content-center gap-2">
                                                <a class="btn btn-outline-info btn-sm square-btn" title="{{ \App\CPU\translate('Edit')}}"
                                                href="{{route('admin.business-settings.cashin-approve.status-update',[$banner->id])}}">
                                                <i class="tio-checkmark-circle"></i>
                                                </a>
                                            </div>
                                    @elseif($banner->status== 1)
                                         <button class="btn btn-success btn-sm">Apporved</button>
                                    @endif
                                        
                                    </td>
                                </tr>
                            @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="table-responsive mt-4">
                        <div class="d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            {{$report->links()}}
                        </div>
                    </div>
                    @if(count($report)==0)
                        <div class="text-center p-4">
                            <img class="mb-3 w-160" src="{{asset('public/assets/back-end')}}/svg/illustrations/sorry.svg" alt="Image Description">
                            <p class="mb-0">{{ \App\CPU\translate('No_data_to_show')}}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(document).on('click', '.delete', function () {
            var id = $(this).attr("id");
            Swal.fire({
                title: '{{ \App\CPU\translate('Are_you_sure_delete_this_brand')}}?',
                text: "{{ \App\CPU\translate('You_will_not_be_able_to_revert_this')}}!",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '{{ \App\CPU\translate('Yes')}}, {{ \App\CPU\translate('delete_it')}}!',
                cancelButtonText: "{{ \App\CPU\translate('cancel')}}",
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "{{route('admin.brand.delete')}}",
                        method: 'POST',
                        data: {id: id},
                        success: function () {
                            toastr.success('{{ \App\CPU\translate('Brand_deleted_successfully')}}');
                            location.reload();
                        }
                    });
                }
            })
        });

        $(document).on('change', '.status', function () {
            var id = $(this).attr("id");
            if ($(this).prop("checked") == true) {
                var status = 1;
            } else if ($(this).prop("checked") == false) {
                var status = 0;
            }
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({ 
                url: "{{route('admin.business-settings.payment-method.status-update')}}",
                method: 'POST',
                data: {
                    id: id,
                    status: status
                },
                success: function (data) {
                    console.log(data)
                    if (data.success == true) {
                        toastr.success('{{\App\CPU\translate('Status updated successfully')}}');
                    } else {
                        toastr.error('{{\App\CPU\translate('Status updated failed. Gateway must be approved')}}');
                        location.reload();
                    }
                }
            });
        });
    </script>
@endpush
