@extends('layouts.back-end.app')
@section('title', \App\CPU\translate('Payment Gateway Add'))

@push('css_or_js')
    <link href="{{asset('public/assets/back-end')}}/css/select2.min.css" rel="stylesheet"/>
    <meta name="csrf-token" content="{{ csrf_token() }}">
@endpush

@section('content')
<div class="content container-fluid">
    <!-- Page Title -->
    <div class="d-flex flex-wrap gap-2 align-items-center mb-3">
        <h2 class="h1 mb-0 d-flex align-items-center gap-2">
            <img width="20" src="{{asset('/public/assets/back-end/img/Payment Gateway.png')}}" alt="">
            {{\App\CPU\translate('Payment Gateway')}} {{\App\CPU\translate('Setup')}}
        </h2>
    </div>
    <!-- End Page Title -->

    <!-- Content Row -->
    <div class="row">
        <div class="col-md-12">
            <div class="card mb-3">
                <div class="card-body" style="text-align: {{Session::get('direction') === "rtl" ? 'right' : 'left'}};">
                    <form action="{{route('admin.business-settings.payment-method.store')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        @php($default_lang = json_decode($language)[0])
                        <ul class="nav nav-tabs w-fit-content mb-4">
                            @foreach(json_decode($language) as $lang)
                                <li class="nav-item">
                                    <a class="nav-link lang_link {{$lang == $default_lang? 'active':''}}" href="#"
                                        id="{{$lang}}-link">{{ucfirst(\App\CPU\Helpers::get_language_name($lang)).'('.strtoupper($lang).')'}}</a>
                                </li>
                            @endforeach
                        </ul>
                        <div class="row">
                            <div class="col-md-6">
                            
                                <div class="form-group {{$lang != $default_lang ? 'd-none':''}} lang_form"
                                        id="{{$lang}}-form">
                                    <label for="method_name" class="title-color">{{ \App\CPU\translate('Payment Method')}}<span class="text-danger">*</span> ({{strtoupper($lang)}})</label>
                                    <input type="text" name="method_name" class="form-control" id="method_name" value="" placeholder="{{\App\CPU\translate('Ex')}} : {{\App\CPU\translate('bKash')}}" required {{$lang == $default_lang? 'required':''}}>
                                </div>

                                <div class="form-group {{$lang != $default_lang ? 'd-none':''}} lang_form"
                                        id="{{$lang}}-form">
                                    <label for="method_name" class="title-color">{{ \App\CPU\translate('Account Number')}}<span class="text-danger">*</span> ({{strtoupper($lang)}})</label>
                                    <input type="text" name="account_no" class="form-control" id="account_no" value="" placeholder="{{\App\CPU\translate('Ex')}} : {{\App\CPU\translate('017xxxxxxx')}}" required {{$lang == $default_lang? 'required':''}}>
                                </div>
                                        

                                <div class="form-group {{$lang != $default_lang ? 'd-none':''}} lang_form"
                                        id="{{$lang}}-form">
                                    <label for="method_name" class="title-color">{{ \App\CPU\translate('Minimum Amount')}}<span class="text-danger">*</span> ({{strtoupper($lang)}})</label>
                                    <input type="text" name="min" class="form-control" id="min" value="" placeholder="{{\App\CPU\translate('Ex')}} : {{\App\CPU\translate('100')}}" required {{$lang == $default_lang? 'required':''}}>
                                </div>
                              
                                <div class="form-group {{$lang != $default_lang ? 'd-none':''}} lang_form"
                                        id="{{$lang}}-form">
                                    <label for="method_name" class="title-color">{{ \App\CPU\translate('Maximum Amount')}}<span class="text-danger">*</span> ({{strtoupper($lang)}})</label>
                                    <input type="text" name="max" class="form-control" id="max" value="" placeholder="{{\App\CPU\translate('Ex')}} : {{\App\CPU\translate('100000')}}" required {{$lang == $default_lang? 'required':''}}>
                                </div>
                                                             

                                <div class="form-group">
                                    <label for="name" class="title-color">{{ \App\CPU\translate('Brand_Logo')}}<span class="text-danger">*</span></label>
                                    <span class="ml-1 text-info">( {{\App\CPU\translate('ratio')}} 1:1 )</span>
                                    <div class="custom-file text-left" required>
                                        <input type="file" name="image" id="customFileUpload" class="custom-file-input"
                                            accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*">
                                        <label class="custom-file-label" for="customFileUpload">{{\App\CPU\translate('choose')}} {{\App\CPU\translate('file')}}</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-4">
                                <div class="text-center">
                                    <img class="upload-img-view" id="viewer"
                                        src="{{asset('public\assets\back-end\img\400x400\img2.jpg')}}" alt="banner image"/>
                                </div>
                            </div>
                        </div>


                        <div class="d-flex gap-3 justify-content-end">
                            <button type="reset" id="reset" class="btn btn-secondary px-4">{{ \App\CPU\translate('reset')}}</button>
                            <button type="submit" class="btn btn--primary px-4">{{ \App\CPU\translate('submit')}}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
    <script>
        $(".lang_link").click(function (e) {
            e.preventDefault();
            $(".lang_link").removeClass('active');
            $(".lang_form").addClass('d-none');
            $(this).addClass('active');

            let form_id = this.id;
            let lang = form_id.split("-")[0];

            $("#" + lang + "-form").removeClass('d-none');
            if (lang == '{{$default_lang}}') {
                $(".from_part_2").removeClass('d-none');
            } else {
                $(".from_part_2").addClass('d-none');
            }
        });

        $(document).ready(function () {
            $('#dataTable').DataTable();
        });
    </script>
    <script src="{{asset('public/assets/back-end')}}/js/select2.min.js"></script>
    <script>
        $(".js-example-theme-single").select2({
            theme: "classic"
        });

        $(".js-example-responsive").select2({
            width: 'resolve'
        });
    </script>

    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewer').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#customFileUpload").change(function () {
            readURL(this);
        });


        $(document).ready(function() {
            $('#dataTable').DataTable();
        });
        $(document).on('click', '.delete', function () {
            var id = $(this).attr("id");
            Swal.fire({
                title: '{{\App\CPU\translate('are_you_sure?')}}',
                text: "{{\App\CPU\translate('You_will_not_be_able_to_revert_this!')}}",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '{{\App\CPU\translate('Yes')}} {{\App\CPU\translate('delete_it')}}!'
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "{{route('admin.brand.delete')}}",
                        method: 'POST',
                        data: {id: id},
                        success: function () {
                            toastr.success('{{\App\CPU\translate('Brand_deleted_successfully')}}');
                            location.reload();
                        }
                    });
                }
            })
        });
    </script>
@endpush
