@extends('member-panel.layouts.app')

@section('title', 'Balance Transfer')

@push('css')

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
@endpush

@section('content')

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4  card adminuiux-card shadow-sm mb-4">
            <div class="col-12 px-2">
               <div class="col align-self-center text-left">
                    <h5>Balance Transfer Report</h5>
                </div>

                <form id="search-form" action="{{ route('member.generation-commission') }}" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-sm btn-primary">Search</button>
                              </div>
                              <div class="col">
                                    <a href="{{ route('member.balance-received') }}" class="btn btn-sm btn-primary">Received Report</a>
                              </div>
                              <div class="col">
                                    <a href="{{ route('member.transfer') }}" class="btn btn-sm btn-success"><i class="fa fa-plus"></i> Transfer</a>
                              </div>
                        </div>
                </form>


                <table class="table ">
                        <thead>
                        <tr>
                            <th>SL</th>
                            <th>Time & Date</th>
                            <th>User Name</th>
                            <th>Amount</th>
                            <th>Type</th>
                        </tr>
                        </thead>
                        <tbody>
                            @php
                                $total = 0;
                            @endphp
                            @foreach($report as $key=>$banner)
                            @php
                            $user  = DB::table('users')->where('id', $banner->to_id)->first();
                            $total = $total + $banner->amount;
                            @endphp
                                <tr>
                                    <th scope="row">{{$key+1}}</th>
                                    <td>{{  date('h:i:s a d M Y ', strtotime($banner->created_at)) }}</td>
                                    <td>{{$user->user_id}}</td>
                                    <td>{{$banner->amount}}</td>

                                    @if($banner->type == 2)
                                    <td>Purchase Balance Transfer</td>
                                    @elseif($banner->type== 1)
                                    <td>Income Balance Transfer</td>
                                    @elseif($banner->type== 3)
                                    <td>Roi To Income</td>
                                    @elseif($banner->type== 4)
                                    <td>Roi To Trade</td>
                                    @endif

                                </tr>
                            @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td>  </td>
                                    <td>  </td>
                                    <td class="3">  Total</td>
                                    <td>{{ $web_config['currency_sign']->value }} {{ number_format($total,2) }}</td>
                                     <td>  </td>
                                </tr>
                            </tfoot>
                </table>

                         {{ $report->appends(request()->input())->links() }}
               </div>
            </div>

      </div>

   <!-- main page content ends -->
@endsection


@push('js')
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
@endpush
