@extends('member-panel.layouts.app')

@section('title', 'Cash In')

@push('css')
<link rel="stylesheet" href="{{asset('public/assets/member-panel')}}/assets/css/toastr.css?{{ time() }}">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
<style>
:root {
    --primary: #6366f1;
    --primary-light: #818cf8;
    --secondary: #8b5cf6;
    --success: #10b981;
    --danger: #ef4444;
    --warning: #f59e0b;
    --info: #3b82f6;
    --light: #f8fafc;
    --dark: #1e293b;
    --gray: #64748b;
    --gray-light: #e2e8f0;
}

.cashin-container {

    min-height: 100vh;
    padding: 2rem 0;
}

.cashin-card {

    border-radius: 1.5rem;
    box-shadow: 0 10px 25px rgba(0,0,0,0.08);
    overflow: hidden;
    max-width: 800px;
    margin: 0 auto;
    border: none;
}

.card-header {

    padding: 1.5rem;
    text-align: center;

}

.card-header h2 {
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.card-body {
    padding: 2rem;
}

/* Payment Methods */
.payment-methods {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 1rem;
    margin-bottom: 2rem;
}

.payment-option {
    position: relative;
}

.payment-option input[type="radio"] {
    position: absolute;
    opacity: 0;
}

.payment-label {
    display: flex;
    flex-direction: column;
    align-items: center;

    border: 2px solid var(--gray-light);
    border-radius: 0.75rem;
    padding: 1.5rem 1rem;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
    height: 100%;
}

.payment-label:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    border-color: var(--primary-light);
}

.payment-option input[type="radio"]:checked + .payment-label {
    border-color: var(--primary);

}

.payment-image {
    width: 60px;
    height: 60px;
    object-fit: contain;
    margin-bottom: 0.75rem;
    border-radius: 0.5rem;

    padding: 0.5rem;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.payment-name {
    font-size: 0.9rem;
    font-weight: 600;

}

.checkmark {
    position: absolute;
    top: 0.5rem;
    right: 0.5rem;
    width: 1.5rem;
    height: 1.5rem;

    background: var(--success);
    border-radius: 50%;
    display: none;
    align-items: center;
    justify-content: center;
    font-size: 0.75rem;
}

.payment-option input[type="radio"]:checked + .payment-label .checkmark {
    display: flex;
}

/* Payment Details */
.payment-details {

    border-radius: 1rem;
    padding: 1.5rem;
    margin-bottom: 2rem;
    box-shadow: 0 2px 15px rgba(0,0,0,0.05);
    display: none;
    animation: fadeInUp 0.3s ease;
}

.payment-details.show {
    display: block;
}

.detail-row {
    display: flex;
    margin-bottom: 0.75rem;
}

.detail-label {
    font-weight: 600;

    width: 40%;
}

.detail-value {

    width: 60%;
}

.detail-instructions {
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid var(--gray-light);

    font-size: 0.9rem;
}

/* Form Elements */
.form-group {
    margin-bottom: 1.5rem;
}

.form-label {
    font-weight: 600;

    margin-bottom: 0.5rem;
    display: block;
}

.form-control {

    border: 2px solid var(--gray-light);
    border-radius: 0.75rem;
    padding: 0.875rem 1.25rem;
    font-size: 1rem;
    transition: all 0.3s ease;

    width: 100%;
}

.form-control:focus {
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.2);
    outline: none;
}

.file-input-wrapper {
    position: relative;
    overflow: hidden;
    display: inline-block;
    width: 100%;
}

.file-input-wrapper input[type="file"] {
    position: absolute;
    left: 0;
    top: 0;
    opacity: 0;
    width: 100%;
    height: 100%;
    cursor: pointer;
}

.file-input-label {
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 1rem;
    border: 2px dashed var(--gray-light);
    border-radius: 0.75rem;

    transition: all 0.3s ease;
    cursor: pointer;
}

.file-input-label:hover {
    border-color: var(--primary-light);

}

.file-input-label i {
    margin-right: 0.5rem;

}

.file-name {
    margin-top: 0.5rem;
    font-size: 0.9rem;

    display: none;
}

/* Amount Summary */
.amount-summary {

    border-radius: 1rem;
    padding: 1.5rem;
    margin-bottom: 2rem;
    box-shadow: 0 2px 15px rgba(0,0,0,0.05);
}

.summary-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 0.75rem;
    padding: 0.5rem 0;
}

.summary-label {

}

.summary-value {
    font-weight: 600;

}

/* Submit Button */
.submit-btn {
    width: 100%;
    padding: 1rem;
    font-size: 1.1rem;
    font-weight: 600;


    border: none;
    border-radius: 0.75rem;
    transition: all 0.3s ease;
    margin-top: 1rem;
    display: flex;
    align-items: center;
    justify-content: center;
}

.submit-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(99, 102, 241, 0.4);
}

.submit-btn:disabled {


    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}

.submit-btn i {
    margin-right: 0.5rem;
}

/* Responsive Design */
@media (max-width: 768px) {
    .cashin-container {
        padding: 1rem;
    }

    .card-body {
        padding: 1.5rem;
    }

    .payment-methods {
        grid-template-columns: repeat(2, 1fr);
    }

    .detail-label {
        width: 50%;
    }

    .detail-value {
        width: 50%;
    }
}

/* Animations */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.cashin-card {
    animation: fadeInUp 0.5s ease;
}

/* Loading State */
.loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;

    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

.spinner {
    width: 3rem;
    height: 3rem;
    border: 3px solid rgba(99, 102, 241, 0.2);
    border-radius: 50%;
    border-top-color: var(--primary);
    animation: spin 1s linear infinite;
    margin-bottom: 1rem;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}
</style>
@endpush

@section('content')
<div class="cashin-container">
    <div class="container">
        <div class="cashin-card card adminuiux-card shadow-sm mb-4">
            <!-- Header -->
            <div class="card-header">
                <h2 class="mb-2">
                    <i class="bi bi-cash-coin me-2"></i>
                    Cash In
                </h2>
                <p class="mb-0">Deposit funds to your account</p>
            </div>

            <!-- Body -->
            <div class="card-body">
                <form action="{{ url('member/cashin-store') }}" method="post" enctype="multipart/form-data" id="cashinForm">
                    @csrf
                    <input type="hidden" name="method_id" id="method_id">

                    <!-- Payment Method Selection -->
                    <div class="form-group">
                        <label class="form-label">
                            <i class="bi bi-credit-card me-2"></i>
                            Select Payment Method
                        </label>
                        <div class="payment-methods">
                            @foreach($payment as $v)
                                <div class="payment-option">
                                    <input type="radio"
                                           id="method_{{ $v->id }}"
                                           name="wallet_type"
                                           value="{{ $v->id }}"
                                           onclick="selectPaymentMethod('{{ $v->id }}','{{ $v->method_name }}','{{ $v->account_no }}','{{ $v->min }}','{{ $v->max }}','{{ $v->comment }}')">
                                    <label for="method_{{ $v->id }}" class="payment-label">
                                        <img src="{{ asset('storage/app/public/brand/'. $v->image) }}"
                                             alt="{{ $v->method_name }}"
                                             class="payment-image">
                                        <div class="payment-name">{{ $v->method_name }}</div>
                                        <div class="checkmark">
                                            <i class="bi bi-check-lg"></i>
                                        </div>
                                    </label>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- Payment Details -->
                    <div class="payment-details" id="paymentDetails">
                        <div class="detail-row">
                            <div class="detail-label">Deposit Account:</div>
                            <div class="detail-value" id="method_name">-</div>
                        </div>
                        <div class="detail-row">
                            <div class="detail-label">Account Number:</div>
                            <div class="detail-value" id="account_no">-</div>
                        </div>
                        <div class="detail-row">
                            <div class="detail-label">Minimum Deposit:</div>
                            <div class="detail-value" id="min">-</div>
                        </div>
                        <div class="detail-row">
                            <div class="detail-label">Maximum Deposit:</div>
                            <div class="detail-value" id="max">-</div>
                        </div>
                        <div class="detail-instructions" id="comment">
                            Please follow the payment instructions carefully
                        </div>
                    </div>

                    <!-- Amount Input -->
                    <div class="form-group">
                        <label class="form-label" for="final_amount">
                            <i class="bi bi-currency-dollar me-2"></i>
                            Deposit Amount
                        </label>
                        <input type="number"
                               name="final_amount"
                               id="final_amount"
                               class="form-control"
                               placeholder="Enter amount"
                               min="1"
                               step="1"
                               required>
                        <small class="text-muted">Minimum deposit amount varies by payment method</small>
                    </div>

                    <!-- Document Upload -->
                    <div class="form-group">
                        <label class="form-label">
                            <i class="bi bi-file-earmark-arrow-up me-2"></i>
                            Payment Proof
                        </label>
                        <div class="file-input-wrapper">
                            <input type="file" name="image" id="image" class="form-control" required>
                            <label for="image" class="file-input-label">
                                <i class="bi bi-cloud-arrow-up"></i>
                                <span>Upload payment receipt/screenshot</span>
                            </label>
                            <div class="file-name" id="fileName"></div>
                        </div>
                    </div>

                    <!-- Transaction ID -->
                    <div class="form-group">
                        <label class="form-label" for="trx_id">
                            <i class="bi bi-receipt me-2"></i>
                            Transaction ID
                        </label>
                        <input type="text"
                               name="trx_id"
                               id="trx_id"
                               class="form-control"
                               placeholder="Enter transaction/reference ID"
                               required>
                    </div>

                    <!-- Comment -->
                    <div class="form-group">
                        <label class="form-label" for="comment">
                            <i class="bi bi-chat-text me-2"></i>
                            Additional Notes (Optional)
                        </label>
                        <textarea name="comment"
                                  id="comment"
                                  class="form-control"
                                  rows="3"
                                  placeholder="Any special instructions or notes"></textarea>
                    </div>

                    <!-- Amount Summary -->
                    <div class="amount-summary">
                        <div class="summary-item">
                            <span class="summary-label">Total Deposit Amount:</span>
                            <span class="summary-value" id="entered_amount">0.00</span>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-success submit-btn" id="submitBtn" disabled>
                        <i class="bi bi-send-check me-2"></i>
                        Submit Deposit Request
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div class="loading-overlay d-none" id="loadingOverlay">
    <div class="spinner"></div>
    <p class="text-primary fw-bold mt-3">Processing your deposit request...</p>
</div>
@endsection

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="{{asset('public/assets/member-panel/assets')}}/js/toastr.js?{{ time() }}"></script>
{!! Toastr::message() !!}

<script>
$(document).ready(function() {
    // Initialize toastr
    toastr.options = {
        positionClass: 'toast-top-right',
        timeOut: 4000,
        closeButton: true,
        progressBar: true,
        newestOnTop: true
    };

    // File input change handler
    $('#image').change(function() {
        const fileName = $(this).val().split('\\').pop();
        if (fileName) {
            $('#fileName').text(fileName).show();
        } else {
            $('#fileName').hide();
        }
        validateForm();
    });

    // Amount input handler
    $('#final_amount').on('input', function() {
        const amount = $(this).val();
        $('#entered_amount').text(amount);
        validateForm();
    });

    // Form validation
    function validateForm() {
        const methodSelected = $('#method_id').val() !== '';
        const amount = parseFloat($('#final_amount').val()) || 0;
        const fileSelected = $('#image').val() !== '';
        const trxId = $('#trx_id').val().trim();

        let isValid = methodSelected &&
                     amount > 0 &&
                     fileSelected &&
                     trxId.length > 0;

        $('#submitBtn').prop('disabled', !isValid);
    }

    // Form elements change handler
    $('input, textarea').on('input change', function() {
        validateForm();
    });

    // Form submission
    $('#cashinForm').on('submit', function(e) {
        const amount = parseFloat($('#final_amount').val()) || 0;
        const methodId = $('#method_id').val();

        if (!methodId) {
            e.preventDefault();
            toastr.error('Please select a payment method');
            return false;
        }

        if (amount <= 0) {
            e.preventDefault();
            toastr.error('Please enter a valid deposit amount');
            return false;
        }

        // Show loading overlay
        $('#loadingOverlay').removeClass('d-none');
        $('#submitBtn').prop('disabled', true).html('<i class="bi bi-hourglass-top me-2"></i>Processing...');

        return confirm(`Confirm deposit request of ${amount.toFixed(2)}?`);
    });
});

function selectPaymentMethod(id, methodName, accountNo, min, max, comment) {
    $('#method_id').val(id);

    // Update payment details
    $('#paymentDetails #method_name').text(methodName);
    $('#paymentDetails #account_no').text(accountNo);
    $('#paymentDetails #min').text(min);
    $('#paymentDetails #max').text(max);
    $('#paymentDetails #comment').text(comment);
    $('#paymentDetails').addClass('show');
     toastr.success(`${methodName} selected`);
    // Update amount field constraints
    $('#final_amount').attr('min', min).attr('max', max);

    // Validate current amount against new limits
    const currentAmount = parseFloat($('#final_amount').val()) || 0;
    if (currentAmount > 0) {
        if (currentAmount < parseFloat(min)) {
            toastr.warning(`Minimum deposit for ${methodName} is ${min}`);
            $('#final_amount').val(min);
        } else if (currentAmount > parseFloat(max)) {
            toastr.warning(`Maximum deposit for ${methodName} is ${max}`);
            $('#final_amount').val(max);
        }
        $('#entered_amount').text($('#final_amount').val());
    }

    validateForm();
    toastr.success(`${methodName} selected`);
}
</script>
@endpush
