<!DOCTYPE html>
<html lang="en">
<!-- dir="rtl"-->
<head>
    <!-- Required meta tags  -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">

    <meta name="application-name" content="eShopUIUX">
    <meta name="apple-mobile-web-app-title" content="eShopUIUX">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="white">
    <link rel="apple-touch-icon" href="{{asset("storage/app/public/company")."/".$web_config['mob_logo']->value}}">

    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <title>
            @yield('title')
    </title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="Shopping e-Commerce .">
    <link rel="icon" type="image/png" href="{{asset("storage/app/public/company")."/".$web_config['mob_logo']->value}}">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300..800;1,300..800&amp;family=Poppins:wght@300;400;500;600&amp;display=swap" rel="stylesheet">
    @stack('css')
    <style>
            :root {
                --adminuiux-content-font: "Open Sans", serif;
                --adminuiux-content-font-weight: 400;
                --adminuiux-title-font: "Poppins", serif;
                --adminuiux-title-font-weight: 600;
            }
    </style>
    <script defer src="{{asset('public/assets/member-panel2')}}/assets/js/app6cdf.js?1.1"></script>
    <link href="{{asset('public/assets/member-panel2')}}/assets/css/app6cdf.css?1.1" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

   <script>

        if (!document.cookie.includes("adminuiuxlayoutmode")) {
            document.cookie = "adminuiuxlayoutmode=dark; path=/; SameSite=None; Secure";
            document.documentElement.setAttribute('data-bs-theme', 'dark');
        }


    </script>

</head>

    <body class="main-bg main-bg-opac main-bg-blur roundedui adminuiux-header-standard adminuiux-sidebar-standard adminuiux-mobile-footer-fill-theme adminuiux-header-transparent theme-pista bg-r-gradient adminuiux-sidebar-fill-none scrollup" data-theme="theme-pista" data-sidebarfill="adminuiux-sidebar-fill-none" data-bs-spy="scroll" data-bs-target="#list-example" data-bs-smooth-scroll="true" tabindex="0" data-sidebarlayout="adminuiux-sidebar-standard" data-headerlayout="adminuiux-header-standard" data-headerfill="adminuiux-header-transparent" data-bggradient="bg-r-gradient" style="">
        <!-- Pageloader -->
                    <div class="pageloader">
                        <div class="container h-100">
                            <div class="row justify-content-center align-items-center text-center h-100 pb-ios">
                                <div class="col-12 mb-auto pt-4"></div>
                                <div class="col-auto">
                                    <img src="{{asset("storage/app/public/company")."/".$web_config['mob_logo']->value}}" alt="" class="height-80 mb-3">
                                    <p class="h2 mb-0 text-theme-accent-1"></p>
                                    <p class="display-3 text-theme-1 fw-bold mb-4"></p>
                                    <div class="loader5 mb-2 mx-auto"></div>
                                </div>
                                <div class="col-12 mt-auto pb-4">
                                    <p class="small text-secondary">We are preparing awesome things...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- standard header -->
                    <header class="adminuiux-header">
                        <!-- Fixed navbar -->
                        <nav class="navbar navbar-expand-lg fixed-top">
                            <div class="container-fluid">
                                <!-- main sidebar toggle -->
                                <button class="btn btn-link btn-square sidebar-toggler" type="button" onclick="initSidebar()">
                                    <i class="sidebar-svg" data-feather="menu"></i>
                                </button>
                                <!-- logo -->
                                <a class="navbar-brand" href="{{ url('member/dashboard') }}">
                                    <img data-bs-img="light" src="{{asset("storage/app/public/company")."/".$web_config['mob_logo']->value}}" alt="" class="avatar avatar-120">
                                    <img data-bs-img="dark" src="{{asset("storage/app/public/company")."/".$web_config['mob_logo']->value}}" alt="" class="avatar avatar-120">
                                    <!-- <div class="d-block ps-2">
                                        <h6 class="fs-6 mb-0">eShop<span class="fs-6">UIUX</span></h6>
                                        <p class="company-tagline">Mobile App HTML</p>
                                    </div> -->
                                </a>

                                <!-- right icons button -->
                                <div class="ms-auto">
                                    <!-- fullscreen toggle -->
                                    <!-- <button class="btn btn-link btn-square btn-icon btn-link-header" type="button" data-bs-toggle="modal" data-bs-target="#searchmodalfull">
                                        <i data-feather="search"></i>
                                    </button> -->
                                    <button class="btn btn-link btn-square btn-icon btn-link-header dropdown-toggle no-caret" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i data-feather="grid"></i>
                                    </button>
                                    <!-- dark mode -->
                                    <button class="btn btn-link btn-square btnsunmoon btn-link-header" id="btn-layout-modes-dark-page">
                                        <i class="sun mx-auto" data-feather="sun"></i>
                                        <i class="moon mx-auto" data-feather="moon"></i>
                                    </button>

                                    <button class="btn btn-link btn-square btn-icon btn-link-header position-relative" data-bs-toggle="offcanvas" data-bs-target="#view-notification">
                                        <i data-feather="bell"></i>
                                        <span class="position-absolute top-0 end-0 badge rounded-pill bg-danger p-1">
                                            <small>1+</small>
                                            <span class="visually-hidden">unread messages</span>
                                        </span>
                                    </button>
                                    <!-- application list dropdown -->
                                    <div class="dropdown  d-sm-inline-block">

                                        <div class="dropdown-menu dropdown-menu-end width-300 pt-0 px-0 overflow-hidden">
                                            <div class="py-3 mb-2 dropdown-dontclose text-center">
                                                <h5 class="mb-0">Applications</h5>
                                                <p class="text-secondary small">Make your app innovative</p>
                                            </div>
                                            <div class="px-2">
                                                <div class="row g-2 text-center mb-2">
                                                    <div class="col-4">
                                                        <a class="dropdown-item square-item position-relative" href="#">
                                                            <div class="avatar avatar-40 rounded mb-2">
                                                                <i class="bi bi-bank fs-4 mx-0"></i>
                                                            </div>
                                                            <p class="mb-0">Finance</p>
                                                            <p class="fs-12 opacity-50 mb-2">Accounting</p>
                                                        </a>
                                                    </div>
                                                    <div class="col-4">
                                                        <a class="dropdown-item square-item position-relative" href="#">
                                                            <div class="avatar avatar-40 rounded mb-2">
                                                                <i class="bi bi-globe fs-4 mx-0"></i>
                                                            </div>
                                                            <p class="mb-0">Network</p>
                                                            <p class="fs-12 opacity-50 mb-2">Stabilize</p>
                                                        </a>
                                                    </div>
                                                    <div class="col-4">
                                                        <a class="dropdown-item square-item position-relative" href="#">
                                                            <div class="avatar avatar-40 rounded mb-2">
                                                                <i class="bi bi-box fs-4 mx-0"></i>
                                                            </div>
                                                            <p class="mb-0">Inventory</p>
                                                            <p class="fs-12 opacity-50 mb-2">Assuring</p>
                                                        </a>
                                                    </div>
                                                    <div class="col-4">
                                                        <a class="dropdown-item square-item position-relative" href="#">
                                                            <div class="avatar avatar-40 rounded mb-2">
                                                                <i class="bi bi-folder fs-4 mx-0"></i>
                                                            </div>
                                                            <p class="mb-0">Project</p>
                                                            <p class="fs-12 opacity-50 mb-2">Management</p>
                                                        </a>
                                                    </div>
                                                    <div class="col-4">
                                                        <a class="dropdown-item square-item position-relative" href="#">
                                                            <div class="avatar avatar-40 rounded mb-2">
                                                                <i class="bi bi-people fs-4 mx-0"></i>
                                                            </div>
                                                            <p class="mb-0">Social</p>
                                                            <p class="fs-12 opacity-50 mb-2">Tracking</p>
                                                        </a>
                                                    </div>
                                                    <div class="col-4">
                                                        <a class="dropdown-item square-item position-relative" href="#">
                                                            <div class="avatar avatar-40 rounded mb-2">
                                                                <i class="bi bi-journal-bookmark fs-4 mx-0"></i>
                                                            </div>
                                                            <p class="mb-0">eComm</p>
                                                            <p class="fs-12 opacity-50 mb-2">Make-easy</p>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="text-center">
                                                <a class="btn btn-link text-center" href="#">View all <i class="bi bi-arrow-right fs-14"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- language dropdown -->
                                    <!-- <div class="dropdown d-none d-sm-inline-block">
                                        <button class="btn btn-link btn-square btn-icon btn-link-header dropdown-toggle no-caret" type="button" data-bs-toggle="dropdown" aria-expanded="false"> <i class="bi bi-translate"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li><a class="dropdown-item active" data-value="EN">EN - English</a></li>
                                            <li><a class="dropdown-item" data-value="FR">FR - French</a></li>
                                            <li><a class="dropdown-item" data-value="CH">CH - Chinese</a></li>
                                            <li><a class="dropdown-item" data-value="HI">HI - Hindi</a></li>
                                        </ul>
                                    </div> -->
                                    <!-- notification dropdown -->

                                </div>
                            </div>
                        </nav>

                    </header>

                        <div class="adminuiux-wrap">
                            <!-- Standard sidebar -->
                            <!-- Standard sidebar -->

                            @include('member-panel.layouts.partials._sidebar')


                                <main class="adminuiux-content has-sidebar" onclick="contentClick()">

                                        @yield('content')
                                </main>
                        </div>
                        <!-- View Product details -->
                        <div class="offcanvas offcanvas-end shadow border-0 maxwidth-dynamic" tabindex="-1" id="view-product" data-bs-scroll="true" data-bs-backdrop="false" aria-labelledby="view-productlabel" style="--mw-dynamic:450px; --bs-offcanvas-width:300px">
                            <div class="offcanvas-header border-bottom">
                                <div>
                                    <button class="btn btn-square btn-theme"><i class="bi bi-pencil"></i></button>
                                    <button class="btn btn-square btn-link mx-1"><i class="bi bi-copy"></i></button>
                                    <button class="btn btn-square btn-link mx-1"><i class="bi bi-printer"></i></button>
                                    <div class="d-inline-block">
                                        <div class="dropdown">
                                            <button class="btn btn-link btn-square dropdown-toggle no-caret" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i class="bi bi-three-dots-vertical"></i>
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end">
                                                <li><a class="dropdown-item" href="#">Orders <span class="badge text-bg-theme-1">15</span></a></li>
                                                <li><a class="dropdown-item" href="#">Manufacture</a></li>
                                                <li><a class="dropdown-item theme-red" href="#">Delete</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                            </div>
                            <div class="offcanvas-body">
                                <div class="offcanvas-title mb-3 mb-lg-4" id="view-productlabel">
                                    <figure class="w-100 height-120 coverimg rounded mb-3">
                                        <img src="{{asset('public/assets/member-panel2')}}/assets/img/ecommerce/image-12.jpg" alt="">
                                    </figure>
                                    <h6 class="mb-0 text-truncated">Chromiums Bagizard</h6>
                                    <p class="text-secondary mb-2">ID: RT15246246</p>
                                    <p><span class="badge badge-light text-bg-success">Active</span>
                                        <span class="badge badge-light text-bg-primary">15 Orders</span>
                                    </p>

                                </div>

                                <h6 class="mb-2">Product Info</h6>
                                <dl class="row mb-2">
                                    <dt class="col-sm-3 small text-secondary fw-normal">Category</dt>
                                    <dd class="col-sm-9">Fashion <i class="bi bi-arrow-right text-secondary"></i> Woman</dd>
                                </dl>
                                <dl class="row mb-2">
                                    <dt class="col-sm-3 small text-secondary fw-normal">ID/SKU</dt>
                                    <dd class="col-sm-9">RT15246246 <i class="bi bi-copy"></i></dd>
                                </dl>
                                <dl class="row mb-2">
                                    <dt class="col-sm-3 small text-secondary fw-normal">Orders</dt>
                                    <dd class="col-sm-9">5 / 11 In stock</dd>
                                </dl>
                                <dl class="row mb-2">
                                    <dt class="col-sm-3 small text-secondary fw-normal">Price</dt>
                                    <dd class="col-sm-9">$ 49.00<br><small class="text-secondary">Discount $ 10.00 with Coupon <i class="bi bi-tag"></i> 15% </small></dd>
                                </dl>
                                <dl class="row mb-2">
                                    <dt class="col-sm-3 small text-secondary fw-normal">Total Sales</dt>
                                    <dd class="col-sm-9">125</dd>
                                </dl>
                                <dl class="row mb-2">
                                    <dt class="col-sm-3 small text-secondary fw-normal">Status</dt>
                                    <dd class="col-sm-9">
                                        <div class="form-check form-switch d-inline-block mx-2">
                                            <input class="form-check-input" type="checkbox" role="switch" id="flexSwitchCheckChecked" checked>
                                            <label class="form-check-label" for="flexSwitchCheckChecked">Active</label>
                                        </div>
                                    </dd>

                                </dl>

                            </div>
                        </div>
                        <!-- notification -->
                        <div class="offcanvas offcanvas-end shadow border-0 maxwidth-300" tabindex="-1" id="view-notification" data-bs-scroll="true" data-bs-backdrop="false">
                            <div class="offcanvas-header border-bottom">
                                <div class="flex-grow-1">
                                    <h6 class="mb-0">Notifications</h6>
                                    <p class="text-secondary">6 new updates</p>
                                </div>
                                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                            </div>
                            <div class="small text-center p-3 bg-theme-1-subtle text-theme-1 theme-blue">
                                <div class="input-group">
                                    <input type="text" class="form-control" id="" value="">
                                    <span class="input-group-text text-secondary">
                                        <i class="bi bi-clipboard"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="offcanvas-body">
                                <div class="card bg-none mb-2">
                                    <div class="card-body">
                                        <div class="row gx-3">
                                            <div class="col-auto">
                                                <figure class="avatar avatar-30 coverimg rounded-circle">
                                                    <img src="{{asset('public/assets/member-panel2')}}/assets/img/modern-ai-image/user-2.jpg" alt="">
                                                </figure>
                                            </div>
                                            <div class="col">
                                                <p class="small mb-2"><a href="ecommerce-profile.html">Alex Smith</a>, <a href="ecommerce-profile.html">John McMillan</a> and <span class="fw-medium">36 others</span> are also ordered from same website</p>

                                                <div class="row gx-3 gx-lg-4 align-items-center">
                                                    <div class="col">
                                                        <p class="text-secondary small">2:14 pm</p>
                                                    </div>
                                                    <div class="col-auto">
                                                        <a href="javascript:void(0)" class="btn btn-sm btn-square btn-link theme-red"><i class="bi bi-trash"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                <!-- mobile footer -->
                <footer class="adminuiux-mobile-footer hide-on-scrolldown style-1">
                    <div class="container">
                        <ul class="nav nav-pills nav-justified">
                            <li class="nav-item">
                                <a class="nav-link" href="{{ url('member/dashboard') }}">
                                    <span>
                                        <i class="nav-icon bi bi-shop"></i>
                                        <span class="nav-text">Dashboard</span>
                                    </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="{{ url('member/product/0') }}">
                                    <span>
                                        <i class="nav-icon bi bi-bag-check"></i>
                                        <span class="nav-text">Shop</span>
                                    </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a  href="{{ url('member/placement-tree/'.auth('customer')->user()->user_id) }}" class="nav-link ">
                                    <span>
                                        <i class="nav-icon bi bi-people"></i>
                                        <span class="nav-text">Genealogy</span>
                                    </span>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="{{ url('member/profile') }}">
                                    <span>
                                        <span class="avatar avatar-20 rounded-circle coverimg align-middle mb-2">
                                            <img src="{{ asset('storage/app/public/profile/' . auth('customer')->user()->image) }}" alt="">
                                        </span><br>
                                        <span class="nav-text">Profile</span>
                                    </span>
                                </a>
                            </li>

                              <li class="nav-item">
                                <a class="nav-link" href="{{ route('customer.auth.logout') }}">
                                    <span>
                                        <i class="nav-icon bi bi-person-gear"></i>
                                        <span class="nav-text">Logout</span>
                                    </span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </footer>

                                <!-- footer -->
                                <!-- theming offcanvas-->
        <div class="offcanvas offcanvas-end shadow border-0 maxwidth-250" tabindex="-1" id="theming" data-bs-scroll="true" data-bs-backdrop="false" aria-labelledby="theminglabel">
            <div class="offcanvas-header border-bottom">
                <div>
                    <h5 class="offcanvas-title" id="theminglabel">Personalize</h5>
                    <p class="text-secondary small">Make it more like your own</p>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body">
                <h6 class="offcanvas-title">Colors</h6>
                <p class="text-secondary small mb-4">Change colors of templates</p>
                <div class="row gx-3 mb-3 theme-select">
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-default">
                                <i class="bi bi-arrow-clockwise"></i>
                            </span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-blue">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-blue"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-indigo">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-indigo"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-purple">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-purple"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-pink">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-pink"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-red">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-red"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-orange">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-orange"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-yellow">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-yellow"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-green">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-green"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-teal">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-teal"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-pista">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-pista"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-cyan">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-cyan"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-grey">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-grey"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-brown">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-brown"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-chocolate">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-chocolate"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="theme-black">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-dark"></span>
                        </div>
                    </div>
                </div>
                <h6 class="offcanvas-title">Backgrounds</h6>
                <p class="text-secondary small mb-4">Change color for background</p>
                <div class="row gx-3 mb-3 theme-background">
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-default">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-default"><i class="bi bi-arrow-clockwise"></i></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-white">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-white"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-r-gradient">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-r-gradient"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-gradient-1">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-gradient-1"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-gradient-2">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-gradient-2"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-gradient-3">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-gradient-3"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-gradient-4">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-gradient-4"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-gradient-5">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-gradient-5"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-gradient-6">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-gradient-6"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-gradient-7">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-gradient-7"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-gradient-8">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-gradient-8"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-gradient-9">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-gradient-9"></span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="gradient-box text-center mb-2" data-title="bg-gradient-10">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-gradient-10"></span>
                        </div>
                    </div>
                </div>
                <h6 class="offcanvas-title">Sidebar Layout</h6>
                <p class="text-secondary small mb-4">Change sidebar layout style</p>
                <div class="col-12 col-md">
                    <h6 class="fw-normal mb-3">Color Fill</h6>
                    <div class="row gx-3" id="personalise-preview-sidebar">
                        <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="adminuiux-sidebar-fill-none">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-default">
                            <i class="bi bi-arrow-clockwise"></i>
                            </span>
                            <p class="small">None</p>
                        </div>
                        </div>
                        <div class="col-auto" data-bs-img="dark">
                        <div class="select-box text-center mb-2" data-title="adminuiux-sidebar-fill-white">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-black"></span>
                            <p class="small">Black</p>
                        </div>
                        </div>
                        <div class="col-auto" data-bs-img="light">
                        <div class="select-box text-center mb-2" data-title="adminuiux-sidebar-fill-white">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-white"></span>
                            <p class="small">White</p>
                        </div>
                        </div>
                        <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="adminuiux-sidebar-fill-bg">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-body-1"></span>
                            <p class="small">BgTheme</p>
                        </div>
                        </div>
                        <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="adminuiux-sidebar-fill-theme">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-theme-1"></span>
                            <p class="small">Theme</p>
                        </div>
                        </div>
                        <div class="col-auto">
                        <div class="select-box text-center mb-2 active" data-title="adminuiux-sidebar-fill-accent">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-theme-accent-1"></span>
                            <p class="small">Accent</p>
                        </div>
                        </div>
                    </div>
                </div>
                <div class="row gx-3 mb-3 sidebar-layout">
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="adminuiux-sidebar-standard" data-bs-toggle="tooltip" title="None">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-default">
                                <i class="bi bi-arrow-clockwise"></i>
                            </span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="adminuiux-sidebar-iconic" data-bs-toggle="tooltip" title="Iconic">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-default">
                                <i class="bi bi-bezier h4"></i>
                            </span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="adminuiux-sidebar-boxed" data-bs-toggle="tooltip" title="Boxed">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-default">
                                <i class="bi bi-box h5"></i>
                            </span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="select-box text-center mb-2" data-title="adminuiux-sidebar-boxed adminuiux-sidebar-iconic" data-bs-toggle="tooltip" title="Iconic+Boxed">
                            <span class="avatar avatar-40 rounded-circle mb-2 bg-default">
                                <i class="bi bi-bounding-box h5"></i>
                            </span>
                        </div>
                    </div>
                </div>


            <h6 class="offcanvas-title">Background Image</h6>
                <p class="text-secondary small mb-4">Create depth with images & blur effect</p>
                <div class="col-12 col-md">
                    <div class="col-12 col-lg-12 mb-3 mb-lg-4 mb-xl-5">
                    <div class="row gx-3 theme-background theme-bg">
                      <div class="col-auto mb-3">
                        <div class="select-box text-center" data-title="bg-none">
                          <span class="avatar avatar-70 rounded mb-2">
                            <i class="bi bi-arrow-clockwise"></i>
                          </span>
                          <p class="fs-12 opacity-50">None</p>
                        </div>
                      </div>
                      <div class="col-auto mb-3">
                        <div class="select-box text-center">
                          <span class="avatar avatar-70 rounded coverimg mb-2" style="background-image: url(&quot;{{ asset('public/assets/member-panel2/assets/img/background-image/') }}/backgorund-image-1.jpg&quot;);">
                            <img src="assets/img/background-image/backgorund-image-1.jpg" alt="" class="w-100" style="display: none;">
                          </span>
                          <p class="fs-12 opacity-50">Bg 1</p>
                        </div>
                      </div>
                      <div class="col-auto mb-3">
                        <div class="select-box text-center">
                          <span class="avatar avatar-70 rounded coverimg mb-2" style="background-image: url(&quot;{{ asset('public/assets/member-panel2/assets/img/background-image/') }}backgorund-image-2.jpg&quot;);">
                            <img src="assets/img/background-image/backgorund-image-2.jpg" alt="" class="w-100" style="display: none;">
                          </span>
                          <p class="fs-12 opacity-50">Bg 2</p>
                        </div>
                      </div>
                      <div class="col-auto">
                        <div class="select-box text-center">
                          <span class="avatar avatar-70 rounded coverimg mb-2" style="background-image: url(&quot;{{ asset('public/assets/member-panel2/assets/img/background-image/') }}backgorund-image-3.jpg&quot;);">
                            <img src="assets/img/background-image/backgorund-image-3.jpg" alt="" class="w-100" style="display: none;">
                          </span>
                          <p class="fs-12 opacity-50">Bg 3</p>
                        </div>
                      </div>
                      <div class="col-auto mb-3">
                        <div class="select-box text-center">
                          <span class="avatar avatar-70 rounded coverimg" style="background-image: url(&quot;{{ asset('public/assets/member-panel2/assets/img/background-image/') }}backgorund-image-4.jpg&quot;);">
                            <img src="assets/img/background-image/backgorund-image-4.jpg" alt="" class="w-100" style="display: none;">
                          </span>
                          <p class="fs-12 opacity-50">Bg 4</p>
                        </div>
                      </div>
                      <div class="col-auto">
                        <div class="select-box text-center">
                          <span class="avatar avatar-70 rounded coverimg mb-2" style="background-image: url(&quot;{{ asset('public/assets/member-panel2/assets/img/background-image/') }}backgorund-image-5.jpg&quot;);">
                            <img src="assets/img/background-image/backgorund-image-5.jpg" alt="" class="w-100" style="display: none;">
                          </span>
                          <p class="fs-12 opacity-50">Bg 5</p>
                        </div>
                      </div>
                      <div class="col-auto mb-3">
                        <div class="select-box text-center">
                          <span class="avatar avatar-70 rounded coverimg mb-2" style="background-image: url(&quot;{{ asset('public/assets/member-panel2/assets/img/background-image/') }}backgorund-image-7.jpg&quot;);">
                            <img src="assets/img/background-image/backgorund-image-7.jpg" alt="" class="w-100" style="display: none;">
                          </span>
                          <p class="fs-12 opacity-50">Bg 6</p>
                        </div>
                      </div>
                      <div class="col-auto mb-3">
                        <div class="select-box text-center">
                          <span class="avatar avatar-70 rounded coverimg mb-2" style="background-image: url(&quot;{{ asset('public/assets/member-panel2/assets/img/background-image/') }}backgorund-image-8.jpg&quot;);">
                            <img src="assets/img/background-image/backgorund-image-8.jpg" alt="" class="w-100" style="display: none;">
                          </span>
                          <p class="fs-12 opacity-50">Bg 7</p>
                        </div>
                      </div>
                      <div class="col-auto mb-3">
                        <div class="select-box text-center">
                          <span class="avatar avatar-70 rounded coverimg mb-2" style="background-image: url(&quot;{{ asset('public/assets/member-panel2/assets/img/background-image/') }}backgorund-image-9.jpg&quot;);">
                            <img src="assets/img/background-image/backgorund-image-9.jpg" alt="" class="w-100" style="display: none;">
                          </span>
                          <p class="fs-12 opacity-50">Bg 8</p>
                        </div>
                      </div>
                      <div class="col-auto mb-3">
                        <div class="select-box text-center">
                          <span class="avatar avatar-70 rounded coverimg mb-2" style="background-image: url(&quot;{{ asset('public/assets/member-panel2/assets/img/background-image/') }}backgorund-image-10.jpg&quot;);">
                            <img src="assets/img/background-image/backgorund-image-10.jpg" alt="" class="w-100" style="display: none;">
                          </span>
                          <p class="fs-12 opacity-50">Bg 9</p>
                        </div>
                      </div>
                      <div class="col-auto mb-3">
                        <div class="select-box text-center">
                          <span class="avatar avatar-70 rounded coverimg mb-2" style="background-image: url(&quot;{{ asset('public/assets/member-panel2/assets/img/background-image/') }}backgorund-image-11.jpg&quot;);">
                            <img src="assets/img/background-image/backgorund-image-11.jpg" alt="" class="w-100" style="display: none;">
                          </span>
                          <p class="fs-12 opacity-50">Bg 10</p>
                        </div>
                      </div>
                      <div class="col-auto mb-3">
                        <div class="select-box text-center">
                          <span class="avatar avatar-70 rounded coverimg mb-2" style="background-image: url(&quot;{{ asset('public/assets/member-panel2/assets/img/background-image/') }}backgorund-image-12.jpg&quot;);">
                            <img src="assets/img/background-image/backgorund-image-12.jpg" alt="" class="w-100" style="display: none;">
                          </span>
                          <p class="fs-12 opacity-50">Bg 11</p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>



            <h6 class="offcanvas-title">Header Layout</h6>
                <p class="text-secondary small mb-4">Change sidebar layout style</p>
                <div class="col-12 col-md">

                    <div class="row" id="personalise-preview-sidebar">
                       <div class="row gx-3">
                          <div class="col-12 col-md">
                            <h6 class="fw-normal mb-3">Color Fill</h6>
                            <div class="row gx-3" id="personalise-preview-header">
                              <div class="col-auto">
                                <div class="select-box text-center mb-2" data-title="adminuiux-header-transparent">
                                  <span class="avatar avatar-40 rounded-circle mb-2 bg-default">
                                    <i class="bi bi-arrow-clockwise"></i>
                                  </span>
                                  <p class="small">None</p>
                                </div>
                              </div>
                              <div class="col-auto" data-bs-img="dark">
                                <div class="select-box text-center mb-2" data-title="adminuiux-header-fill-white">
                                  <span class="avatar avatar-40 rounded-circle mb-2 bg-black"></span>
                                  <p class="small">Black</p>
                                </div>
                              </div>
                              <div class="col-auto" data-bs-img="light">
                                <div class="select-box text-center mb-2" data-title="adminuiux-header-fill-white">
                                  <span class="avatar avatar-40 rounded-circle mb-2 bg-white"></span>
                                  <p class="small">White</p>
                                </div>
                              </div>
                              <div class="col-auto">
                                <div class="select-box text-center mb-2" data-title="adminuiux-header-fill-bg">
                                  <span class="avatar avatar-40 rounded-circle mb-2 bg-body-1"></span>
                                  <p class="small">BgTheme</p>
                                </div>
                              </div>
                              <div class="col-auto">
                                <div class="select-box text-center mb-2" data-title="adminuiux-header-fill-theme">
                                  <span class="avatar avatar-40 rounded-circle mb-2 bg-theme-1"></span>
                                  <p class="small">Theme</p>
                                </div>
                              </div>
                              <div class="col-auto">
                                <div class="select-box text-center mb-2" data-title="adminuiux-header-fill-accent">
                                  <span class="avatar avatar-40 rounded-circle mb-2 bg-theme-accent-1"></span>
                                  <p class="small">Accent</p>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <h6 class="fw-normal mb-3">Layout Style</h6>
                            <div class="row gx-3" id="header-layout">
                              <div class="col-auto">
                                <div class="select-box text-center mb-2" data-title="adminuiux-header-standard">
                                  <span class="avatar avatar-40 rounded-circle mb-2 bg-default">
                                    <i class="bi bi-arrow-clockwise"></i>
                                  </span>
                                  <p class="small">None</p>
                                </div>
                              </div>
                              <div class="col-auto">
                                <div class="select-box text-center mb-2" data-title="adminuiux-header-boxed">
                                  <span class="avatar avatar-40 rounded-circle mb-2 bg-default">
                                    <i class="bi bi-box h5"></i>
                                  </span>
                                  <p class="small">Boxed</p>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>

                    </div>
                </div>


            </div>
        </div>



    <!-- theming action-->
    <div class="position-fixed bottom-0 end-0 m-3 z-index-5" id="fixedbuttons">
        <button class="btn btn-square btn-theme shadow rounded-circle" type="button" data-bs-toggle="offcanvas" data-bs-target="#theming" aria-controls="theming"><i class="bi bi-palette"></i></button>
        <br>
        <button class="btn btn-theme btn-square shadow mt-2 d-none rounded-circle" id="backtotop"><i class="bi bi-arrow-up"></i></button>
    </div>

    <script>
            var l = i("adminuiuxsetimagepath");
            if (!l) {
                l = "assets/img/background-image/background-image-1.jpg";
                n("adminuiuxsetimagepath", l, 1);
            }
            l && (document.querySelectorAll(".main-bg").forEach((function(e) {
                e.style.setProperty("--adminuiux-main-bg", 'url("../../' + l + '")');
            })), document.querySelectorAll(".theme-background .select-box").forEach((function(e) {
                var img = e.querySelector("img");
                if (img && img.getAttribute("src") === l) {
                    e.classList.add("active");
                }
            })));
    </script>
                                    <!-- Page Level js -->
    <script src="{{asset('public/assets/member-panel2')}}/assets/js/ecommerce/ecommerce-dashboard.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

@stack('js')
    </body>
</html>
