@extends('member-panel.layouts.app')

@section('title', 'Orders List')

@push('css')

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
@endpush

@section('content')

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-2">
            <div class="col align-self-center text-left">
                    <h5>Orders List Report</h5>
                </div>

                <form id="search-form" action="{{ route('member.orders') }}" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-primary">Search</button>
                              </div>
                        </div>
                </form>

             <div class="table-responsive">
                        <table class="table ">
                              <thead>
                                    <tr>
                                          <td>Date</td>
                                          <td>Invoice ID </td>
                                          <td>Purchase From</td>
                                          <td>Order Amount</td>
                                          <td>Payment Status</td>
                                          <td>Delivery Status</td>
                                    </tr>
                              </thead>
                              <tbody>
                              @php
                                    $total = 0;
                              @endphp
                              @foreach ($report as $item)
                              @php
                                    $total += $item->order_amount;
                              @endphp

                              @if($item->seller_id == 'admin')
                                 @php  $sellername = $item->seller_id;  @endphp
                              @else
                                @php   $sellername = DB::table('users')->where('id',$item->seller_id)->first()->user_id;  @endphp
                              @endif
                                    <tr>
                                          <td>{{  date('h:i a d/m/Y', strtotime( $item->created_at)) }}</td>
                                          <td><a href="{{ url('member/order-detail/'.$item->id) }}" target="_blank">#{{$item->id}}</td>
                                          <td>{{ $sellername }}</td>
                                          <td>{{ number_format($item->order_amount,2) }}</td>
                                          @if(  $item->payment_status  == 'paid')
                                                 <td> <button class="btn btn-success btn-sm">{{ $item->payment_status }}</button>  </td>
                                          @else
                                                 <td> <button class="btn btn-danger btn-sm">{{ $item->payment_status }}</button>  </td>
                                          @endif

                                          @if(  $item->order_status  == 'pending')
                                                 <td> <button class="btn btn-danger btn-sm">{{ $item->order_status }}</button>  </td>
                                          @else
                                                <td> <button class="btn btn-success btn-sm">{{ $item->order_status }}</button>  </td>
                                          @endif


                                    </tr>
                              @endforeach
                              </tbody>
                              <tfoot>
                                    <tr>
                                          <td></td>
                                          <td></td>
                                          <td>Total</td>
                                          <td>{{ $web_config['currency_sign']->value }}  {{ number_format($total,2) }}  </td>
                                          <td></td>
                                          <td></td>
                                    </tr>
                              </tfoot>
                        </table>

                         {{ $report->appends(request()->input())->links() }}
               </div>
                </div>
            </div>

      </div>

   <!-- main page content ends -->
@endsection


@push('js')
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
@endpush
