@extends('member-panel.layouts.app')

@section('title', 'Order Details')

@push('css')
<meta name="_token" content="{{ csrf_token() }}">
<link rel="stylesheet" href="{{asset('public/assets/back-end/css/sweet_alert.css')}}?{{ time() }}">
<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<link rel="stylesheet" href="{{asset('public/assets/member-panel')}}/assets/css/toastr.css?{{ time() }}">
<style>
      #search-form {
        text-align: right;
      }
      @media print {
      .printable {
      background-color: white;
      border: 2px solid black;
      padding: 20px;
      margin: 20px;
      }
      }
</style>
@endpush

@section('content')

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-2">
            <div class="col align-self-center text-left">
                  <h5>Order Details </h5>
            </div>
            @php   $custimerDetails = DB::table('users')->where('id',$order['customer_id'])->first();  @endphp
                <div class="card h-100 printable" id="printable">
                    <!-- Body -->
                    <div class="card-body">
                        <div class="d-flex flex-wrap gap-10 justify-content-between mb-4">
                            <div class="d-flex flex-column gap-10">
                                <h4 class="text-capitalize">{{\App\CPU\translate('Order_ID')}} #{{$order['id']}}</h4>
                                <div class="">
                                    <i class="tio-date-range"></i> {{date('d M Y H:i:s',strtotime($order['created_at']))}}
                                </div>
                                <div class="">{{ $custimerDetails->f_name }} {{ $custimerDetails->l_name }} ({{ $custimerDetails->user_id }})</div>
                                <div class="">Phone : {{ $custimerDetails->phone }} </div>
                                <div class="">Address : {{ $custimerDetails->street_address }} </div>
                            </div>
                            <div class="text-sm-right">
                                <div class="d-flex flex-wrap gap-10">
                                    <button class="btn btn-primary px-4 btn-sm" id="printButton" onclick="printDiv('printable')">Print </button>
                                </div>
                                <div class="d-flex flex-column gap-2 mt-3">
                                    <!-- Order status -->
                                    <div class="order-status d-flex justify-content-sm-end gap-10 text-capitalize">
                                        <span class="title-color">{{\App\CPU\translate('Status')}}: </span>
                                        @if($order['order_status']=='pending')
                                            <span class="btn btn-sm btn-info d-flex align-items-center py-1 px-2">{{str_replace('_',' ',$order['order_status'])}}</span>
                                        @elseif($order['order_status']=='failed')
                                            <span class="btn btn-danger  btn-sm d-flex align-items-center py-1 px-2">{{str_replace('_',' ',$order['order_status'] == 'failed' ? 'Failed to Deliver' : '')}}
                                            </span>
                                        @elseif($order['order_status']=='processing' || $order['order_status']=='out_for_delivery')
                                            <span class="btn btn-sm btn-warning d-flex align-items-center py-1 px-2">
                                                {{str_replace('_',' ',$order['order_status'] == 'processing' ? 'Packaging' : $order['order_status'])}}
                                            </span>
                                        @elseif($order['order_status']=='delivered' || $order['order_status']=='confirmed')
                                            <span class="btn btn-sm btn-success d-flex align-items-center py-1 px-2">
                                                {{str_replace('_',' ',$order['order_status'])}}
                                            </span>
                                        @else
                                            <span class="btn btn-sm btn-danger d-flex align-items-center py-1 px-2">
                                                {{str_replace('_',' ',$order['order_status'])}}
                                            </span>
                                        @endif
                                    </div>

                                    <!-- Payment Method -->
                                    <div class="payment-method d-flex justify-content-sm-end gap-10 text-capitalize">
                                        <span class="title-color">{{\App\CPU\translate('Payment')}} {{\App\CPU\translate('Method')}} :</span>
                                        <strong>{{\App\CPU\translate($order['payment_method'])}}  Online</strong>
                                    </div>


                                    <!-- Payment Status -->
                                    <div class="payment-status d-flex justify-content-sm-end gap-10">
                                        <span class="title-color">{{\App\CPU\translate('Payment_Status')}}:</span>
                                        @if($order['payment_status']=='paid')
                                            <span class="text-success font-weight-bold">
                                                {{\App\CPU\translate('Paid')}}
                                            </span>
                                        @else
                                            <span class="text-danger font-weight-bold">
                                                {{\App\CPU\translate('Unpaid')}}
                                            </span>
                                        @endif
                                    </div>

                                    @if($order->payment_method == 'offline_payment')
                                        <div class="col-md-12 payment-status d-flex justify-content-sm-end gap-10">
                                            <span class="title-color">{{\App\CPU\translate('Payment_Note')}}:</span>
                                            <span>
                                                {{ $order->payment_note }}
                                            </span>
                                        </div>
                                    @endif

                                    @if(\App\CPU\Helpers::get_business_settings('order_verification'))
                                        <span class="ml-2 ml-sm-3">
                                            <b>
                                                {{\App\CPU\translate('order_verification_code')}} : {{$order['verification_code']}}
                                            </b>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>

                        <!-- Order Note -->
                        <div class="mb-5">
                            @if ($order->order_note !=null)
                                <div class="d-flex align-items-center gap-10">
                                    <strong class="c1 bg-soft--primary text-capitalize py-1 px-2">
                                        # {{\App\CPU\translate('note')}} :
                                    </strong>
                                    <div>{{$order->order_note}}</div>
                                </div>
                            @endif
                        </div>

                        <div class="table-responsive datatable-custom">
                            <table class="table fz-12 table-hover table-borderless table-thead-bordered  table-nowrap table-align-middle card-table w-100">
                                <thead class="thead-light thead-50 text-capitalize">
                                <tr>
                                    <th>{{\App\CPU\translate('SL')}}</th>
                                    <th>{{\App\CPU\translate('Item Image')}}</th>
                                    <th>{{\App\CPU\translate('Item Name')}}</th>
                                    <th>{{\App\CPU\translate('Qty')}}</th>
                                    <th>{{\App\CPU\translate('Amount')}}</th>
                                    <th>{{\App\CPU\translate('SV')}}</th>
                                    <th>{{\App\CPU\translate('Sub Total')}}</th>
                                </tr>
                                </thead>

                                <tbody>
                                @php($subtotal=0)
                                @php($total=0)
                                @php($totalsv=0)
                                @php($row=0)

                                @foreach($order->details as $key=>$detail)
                                    @if($detail->product_all_status)
                                        <tr>
                                            <td>{{ ++$row }}</td>
                                            <td>
                                                <div class="media align-items-center gap-10">
                                                    <img class="avatar avatar-60 rounded"
                                                         onerror="this.src='{{asset('public/assets/back-end/img/160x160/img2.jpg')}}'"
                                                         src="{{\App\CPU\ProductManager::product_image_path('thumbnail')}}/{{$detail->product_all_status['thumbnail']}}"
                                                         alt="Image Description">
                                                    <div>
                                                     </div>
                                                </div>
                                            </td>
                                            <td>
                                                 <h6 class="title-color">{{substr($detail->product_all_status['name'],0,30)}}{{strlen($detail->product_all_status['name'])>10?'...':''}} (SV {{$detail->sv_point }}) </h6>
                                            </td>
                                            <td>{{$detail->qty }}</td>
                                            <td>{{$detail->price }}</td>

                                            <td>{{$detail->sv_point * $detail->qty }}</td>
                                                @php($subtotal=$detail['price']*$detail->qty+$detail['tax']-$detail['discount'])
                                            <td>{{ $subtotal }}</td>
                                        </tr>

                                        @php($total+=$subtotal)
                                        @php($totalsv+=$detail->sv_point * $detail->qty )
                                        <!-- End Media -->
                                    @endif
                                    @php($sellerId=$detail->seller_id)


                                @endforeach
                                </tbody>

                                    <tfoot>
                                          <tr>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td>Total</td>
                                                <td>{{ $totalsv }} SV</td>
                                                <td>{{ $web_config['currency_sign']->value }}  {{ number_format($total,2) }}  </td>
                                          </tr>
                                    </tfoot>
                           </table>






                        <div class="col-lg-4 col-xl-3 d-flex flex-column gap-3" style="float: right;">
                            <div class="card">
                                <div class="card-body text-capitalize d-flex flex-column gap-4">

                                    @if($order['order_status'] != 'delivered')

                                    <div class="">
                                        <label class="font-weight-bold title-color fz-14">{{\App\CPU\translate('Order Status')}}</label>
                                        <select name="order_status" onchange="order_status(this.value)" class="status form-control" data-id="{{$order['id']}}">
                                            <option value="" > Please Select</option>
                                            <option value="delivered" {{$order->order_status == 'delivered'?'selected':''}} >{{\App\CPU\translate('Delivered')}} </option>
                                            <!-- <option
                                                value="pending" {{$order->order_status == 'pending'?'selected':''}} > {{\App\CPU\translate('Pending')}}</option>
                                            <option
                                                value="confirmed" {{$order->order_status == 'confirmed'?'selected':''}} > {{\App\CPU\translate('Confirmed')}}</option>
                                            <option
                                                value="processing" {{$order->order_status == 'processing'?'selected':''}} >{{\App\CPU\translate('Packaging')}} </option>
                                            <option class="text-capitalize"
                                                    value="out_for_delivery" {{$order->order_status == 'out_for_delivery'?'selected':''}} >{{\App\CPU\translate('out_for_delivery')}} </option>

                                            <option
                                                value="returned" {{$order->order_status == 'returned'?'selected':''}} > {{\App\CPU\translate('Returned')}}</option>
                                            <option
                                                value="failed" {{$order->order_status == 'failed'?'selected':''}} >{{\App\CPU\translate('Failed_to_Deliver')}} </option>
                                            <option
                                                value="canceled" {{$order->order_status == 'canceled'?'selected':''}} >{{\App\CPU\translate('Canceled')}} </option> -->
                                        </select>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                       </div>
                        <!-- End Row -->
                  </div>
                    <!-- End Body -->
                </div>

               </div>
            </div>

      </div>

   <!-- main page content ends -->
@endsection


@push('js')
      <script src="{{asset('public/assets/back-end/js/sweet_alert.js')}}?{{ time() }}"></script>
      <script src="{{asset('public/assets/member-panel/assets')}}/js/toastr.js?{{ time() }}"></script>
      <script>
           function printDiv(divId) {
                  var printButton = document.getElementById('printButton');
                  printButton.style.display = 'none';
                  var printContents = document.getElementById(divId).innerHTML;
                  var originalContents = document.body.innerHTML;
                  document.body.innerHTML = printContents;
                  window.print();
                  document.body.innerHTML = originalContents;
            }
            toastr.options   = {positionClass: 'toast-top-right'};
            function order_status(status) {
            @if($order['order_status']=='delivered')
            Swal.fire({
                title: '{{\App\CPU\translate('Order is already delivered, and transaction amount has been disbursed, changing status can be the reason of miscalculation')}}!',
                text: "{{\App\CPU\translate('Think before you proceed')}}.",
                showCancelButton: true,
                confirmButtonColor: '#377dff',
                cancelButtonColor: 'secondary',
                confirmButtonText: '{{\App\CPU\translate('Yes, Change it')}}!'
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "{{route('member.orders.status')}}",
                        method: 'POST',
                        data: {
                            "id": '{{$order['id']}}',
                            "order_status": status
                        },
                        success: function (data) {

                            if (data.success == 0) {
                                toastr.warning('{{\App\CPU\translate('Order is already delivered, You can not change it')}} !!')
                                // location.reload();
                            } else {

                                if(data.payment_status == 0){
                                   toastr.warning('{{\App\CPU\translate('Before delivered you need to make payment status paid!')}}!');

                                    // location.reload();
                                }else if(data.customer_status==0)
                                {
                                   toastr.warning('{{\App\CPU\translate('Account has been deleted, you can not change the status!')}}!');
                                    // location.reload();
                                }
                                else{
                                    toastr.warning('{{\App\CPU\translate('Product delivered successfully')}}!');
                                     location.reload();
                                }
                            }

                        }
                    });
                }
            })
            @else
            Swal.fire({
                title: '{{\App\CPU\translate('Are you sure Change this')}}?',
                text: "{{\App\CPU\translate('You will not be able to revert this')}}!",
                showCancelButton: true,
                confirmButtonColor: '#377dff',
                cancelButtonColor: 'secondary',
                confirmButtonText: '{{\App\CPU\translate('Yes, Change it')}}!'
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "{{route('member.orders.status')}}",
                        method: 'POST',
                        data: {
                            "id": '{{$order['id']}}',
                            "order_status": status
                        },
                        success: function (data) {
                            if (data.success == 0) {
                                toastr.warning('{{\App\CPU\translate('Order is already delivered, You can not change it')}} !!');
                                // location.reload();
                            } else {
                                if(data.payment_status == 0){
                                   toastr.warning('{{\App\CPU\translate('Before delivered you need to make payment status paid!')}}!');
                                    // location.reload();
                                }if(data.sv_status == 0){
                                   toastr.warning('{{\App\CPU\translate('Insufficiant SV. You can not delivered the product')}}!');
                                    // location.reload();
                                }else if(data.customer_status==0){
                                   toastr.success('{{\App\CPU\translate('Account has been deleted, you can not change the status!')}}!');
                                    // location.reload();
                                }else{
                                    toastr.success('{{\App\CPU\translate('Product delivered successfully ')}}!');
                                     location.reload();
                                }
                            }

                        }
                    });
                }
            })
            @endif
        }

	</script>
@endpush
