@extends('member-panel.layouts.app')
@section('title', 'Product Purchase')

@push('css')
<link rel="stylesheet" href="{{ asset('public/assets/member-panel/assets/css/toastr.css') }}?{{ time() }}">
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.0/font/bootstrap-icons.css">
<style>
:root {
    --primary-color: #5e72e4;
    --secondary-color: #825ee4;
    --success-color: #2dce89;
    --danger-color: #f5365c;
    --warning-color: #fb6340;
    --info-color: #11cdef;
    --light-color: #f8f9fa;
    --dark-color: #212529;
}

/* Main Layout */
.purchase-container {
    padding: 20px 0;
    min-height: calc(100vh - 100px);
}

.header-section {
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 25px;
    box-shadow: 0 4px 20px rgba(94, 114, 228, 0.3);
}

.balance-card {
    border-radius: 10px;
    padding: 15px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    border-left: 4px solid var(--success-color);
}

/* Product Cards */
.product-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.product-card {
    border-radius: 12px;
    overflow: hidden;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    box-shadow: 0 2px 15px rgba(0,0,0,0.08);
}

.product-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.12);
}

.product-image-container {
    height: 180px;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
}

.product-image {
    max-height: 100%;
    max-width: 100%;
    object-fit: contain;
    transition: transform 0.3s ease;
}

.product-card:hover .product-image {
    transform: scale(1.05);
}

.product-body {
    padding: 15px;
}

.product-title {
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 8px;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.product-price {
    font-size: 1.2rem;
    font-weight: 700;

    margin-bottom: 10px;
}

.product-sv {
    padding: 3px 10px;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
}

/* Stock Indicator */
.stock-indicator {
    display: flex;
    align-items: center;
    margin: 10px 0;
}

.stock-bar {
    flex-grow: 1;
    height: 6px;

    border-radius: 3px;
    margin: 0 10px;
    overflow: hidden;
}

.stock-progress {
    height: 100%;
    border-radius: 3px;
    transition: width 0.3s ease;
}

.stock-text {
    font-size: 0.8rem;
    font-weight: 600;
}

.quantity-controls {
    display: flex;
    align-items: center;
    margin-top: 15px;
}

.quantity-btn {
    width: 32px;
    height: 32px;
    border: none;

    font-size: 1rem;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: background-color 0.2s ease, color 0.2s ease;
    border-radius: 6px;
}

.quantity-btn:hover:not(:disabled) {


}

.quantity-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
}

.quantity-input {
    width: 50px;
    text-align: center;
    margin: 0 8px;
    border: 1px solid #e9ecef;
    border-radius: 6px;
    padding: 5px;
    font-weight: 600;

}

.quantity-input:focus {
    border-color: var(--primary-color);
    outline: none;
    box-shadow: 0 0 0 0.2rem rgba(94, 114, 228, 0.25);
}

/* Cart Summary */
.cart-summary {

    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 2px 15px rgba(0,0,0,0.08);
    position: sticky;
    top: 20px;
}

.summary-title {
    font-size: 1.2rem;
    font-weight: 600;
    margin-bottom: 20px;

    border-bottom: 1px solid #e9ecef;
    padding-bottom: 10px;
}

.summary-item {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    font-size: 0.95rem;
}

.summary-total {
    font-weight: 700;
    font-size: 1.3rem;

    margin-top: 15px;
    padding-top: 15px;
    border-top: 1px solid #e9ecef;
}

.checkout-btn {
    width: 100%;
    padding: 12px;
    font-weight: 600;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border: none;
    border-radius: 8px;

    transition: transform 0.3s ease, box-shadow 0.3s ease;
    cursor: pointer;
}

.checkout-btn:hover:not(:disabled) {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(94, 114, 228, 0.4);
}

.checkout-btn:disabled {
    background: #e9ecef;

    cursor: not-allowed;
}



.selector-title {
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 15px;

}

.select2-container .select2-selection--single {
    height: 46px;
    border: 1px solid #e9ecef;
    border-radius: 8px;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 46px;
    padding-left: 15px;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 46px;
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .product-grid {
        grid-template-columns: 1fr;
    }

    .cart-summary {
        margin-top: 30px;
        position: static;
    }

    .header-section {
        padding: 15px;
    }
}

/* Success Message */
.alert-success-custom {
    background: linear-gradient(135deg, var(--success-color), #5cb85c);
    border: none;
    border-radius: 10px;

    padding: 15px;
    margin-bottom: 20px;
    box-shadow: 0 4px 15px rgba(45, 206, 137, 0.3);
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 40px 20px;

    border-radius: 12px;
    box-shadow: 0 2px 15px rgba(0,0,0,0.08);
}

.empty-icon {
    font-size: 3rem;

    margin-bottom: 15px;
}

/* Animations */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.product-card {
    animation: fadeIn 0.3s ease forwards;
}

/* Loading State */
.loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;

    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
    flex-direction: column;
}

.spinner {
    width: 50px;
    height: 50px;
    border: 5px solid rgba(94, 114, 228, 0.2);
    border-radius: 50%;
    border-top-color: var(--primary-color);
    animation: spin 1s ease-in-out infinite;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}
</style>
@endpush

@section('content')
<div class="purchase-container">
    <div class="container  card adminuiux-card shadow-sm mb-4">
        <!-- Header Section -->
        <div class="header-section">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h3 class="mb-2"><i class="bi bi-cart-check me-2" aria-hidden="true"></i> Product Purchase Center</h3>
                    <p class="mb-0">Browse products and place your orders with distributors</p>
                </div>
                <div class="col-md-4 mt-3 mt-md-0">
                    <div class="balance-card" role="region" aria-label="Available Balance">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                                <i class="bi bi-wallet2 fs-3 text-success" aria-hidden="true"></i>
                            </div>
                            <div>
                                <small class="text-muted">Available Balance</small>
                                <h4 class="mb-0" aria-label="Balance amount">
                                    {{ number_format(auth('customer')->user()->register_wallet, 2) }}
                                    {{ $web_config['currency_sign']->value }}
                                </h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Success Message -->
        @if ($message = Session::get('success'))
            <div class="alert-success-custom" role="alert">
                <div class="d-flex align-items-center">
                    <i class="bi bi-check-circle-fill me-3 fs-4" aria-hidden="true"></i>
                    <div>
                        <strong>{{ $message }}</strong>
                        <p class="mb-0">Your order has been processed successfully.</p>
                    </div>
                </div>
            </div>
        @endif

        <!-- Distributor Selector -->
        <div class="card adminuiux-card shadow-sm p-2 mb-2">
            <h5 class="selector-title">
                <i class="bi bi-person-gear me-2" aria-hidden="true"></i>
                Select Distributor
            </h5>
            <select class="form-control js-states" required name="agent" id="agent"
                    aria-label="Select Distributor">
                <option value="">Choose your distributor...</option>
                @if(auth('customer')->user()->account_type != 0)
                    <option @if($id == 'admin') selected @endif value="{{ url('member/product/admin') }}">
                        <i class="bi bi-building me-2" aria-hidden="true"></i> Order to Company
                    </option>
                @endif
                @foreach($users as $v)
                    <option @if($id == $v->id) selected @endif value="{{ url('member/product/'.$v->id) }}">
                        <i class="bi bi-person me-2" aria-hidden="true"></i> {{ $v->f_name }} (CID:{{ $v->id }}) - {{ dealer_type($v->id) }} - 📞 {{ $v->phone }}
                    </option>
                @endforeach
            </select>
            @if($id)
                <div class="mt-3">
                    <span class="badge bg-primary">
                        @if($id == 'admin')
                            Currently viewing: Company Products
                        @else
                            Currently viewing: {{ $users->firstWhere('id', $id)->f_name }}'s Products
                        @endif
                    </span>
                </div>
            @endif
        </div>

        <!-- Main Content -->
        <div class="row">
            <!-- Products Grid -->
            <div class="col-lg-8">
                @if(count($product) > 0)
                    <div class="product-grid" id="productGrid" role="grid">
                        @foreach($product as $v)
                        <div class="product-card bg-theme-accent-r-gradient" data-product-id="{{ $v->id }}" role="gridcell">
                            <div class="product-image-container">
                                <img src="{{ asset('storage/app/public/product/thumbnail/'.$v->thumbnail) }}"
                                     class="product-image" alt="{{ $v->name }}" loading="lazy">
                            </div>
                            <div class="product-body">
                                <h5 class="product-title">{{ $v->name }}</h5>
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="product-price" aria-label="Price">
                                        {{ $v->unit_price }} {{ $web_config['currency_sign']->value }}
                                    </span>
                                    <span class="product-sv" aria-label="SV Points">
                                        {{ $v->sv_point }} SV
                                    </span>
                                </div>

                                @php
                                    $stock = ($id == 'admin') ? $v->current_stock : $v->qty;
                                    $stockPercentage = min($stock, 100);
                                    $stockClass = $stock > 50 ? 'stock-high' : ($stock > 10 ? 'stock-medium' : 'stock-low');
                                @endphp

                                <div class="stock-indicator {{ $stockClass }}" role="status" aria-label="Stock status">
                                    <span class="stock-text">{{ $stock }} available</span>
                                    <div class="stock-bar">
                                        <div class="stock-progress" style="width: {{ $stockPercentage }}%" aria-valuenow="{{ $stockPercentage }}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>

                                <div class="quantity-controls" role="group" aria-label="Quantity controls">
                                    <button type="button" class="quantity-btn decrease-btn"
                                            onclick="adjustQuantity({{ $v->id }}, -1)"
                                            aria-label="Decrease quantity">
                                        <i class="bi bi-dash" aria-hidden="true"></i>
                                    </button>
                                    <input type="number" class="quantity-input"
                                           id="qty_{{ $v->id }}"
                                           min="0"
                                           max="{{ $stock }}"
                                           value="0"
                                           onchange="updateProductTotal({{ $v->id }})"
                                           aria-label="Quantity"
                                           aria-describedby="qty_check_{{ $v->id }}">
                                    <button type="button" class="quantity-btn increase-btn"
                                            onclick="adjustQuantity({{ $v->id }}, 1)"
                                            aria-label="Increase quantity">
                                        <i class="bi bi-plus" aria-hidden="true"></i>
                                    </button>
                                </div>

                                <input type="hidden" name="product_id[]" value="{{ $v->id }}">
                                <input type="hidden" name="qty_check[]" id="qty_check_{{ $v->id }}" value="{{ $stock }}">
                                <input type="hidden" class="product_price_{{ $v->id }}" name="amounts[]" value="{{ $v->unit_price }}">
                                <input type="hidden" name="total_amounts[]" id="total_price_{{ $v->id }}" value="0">
                            </div>
                        </div>
                        @endforeach
                    </div>
                @else
                    <div class="empty-state" role="alert">
                        <div class="empty-icon">
                            <i class="bi bi-box-seam" aria-hidden="true"></i>
                        </div>
                        <h4>No Products Available</h4>
                        <p class="text-muted">This distributor doesn't have any products listed yet.</p>
                        <a href="{{ url('member/product/admin') }}" class="btn btn-primary mt-3">
                            <i class="bi bi-building me-2" aria-hidden="true"></i> Browse Company Products
                        </a>
                    </div>
                @endif
            </div>

            <!-- Cart Summary -->
            <div class="col-lg-4 card adminuiux-card shadow-sm  " >
                <form method="post" enctype="multipart/form-data" id="orderForm" action="{{ route('member.create-order') }}">
                    @csrf
                    <input type="hidden" value="{{ $id }}" name="seller_id">

                    <div class="cart-summary" role="region" aria-label="Order Summary">
                        <h5 class="summary-title">
                            <i class="bi bi-cart3 me-2" aria-hidden="true"></i>
                            Order Summary
                        </h5>

                        <div id="selectedProducts">
                            <div class="text-muted text-center py-3 d-none" id="emptyCartMessage">
                                <i class="bi bi-cart-x fs-1" aria-hidden="true"></i>
                                <p class="mt-2">Your cart is empty</p>
                                <p>Select products to continue</p>
                            </div>
                        </div>

                        <div class="d-none" id="cartItemsContainer">
                            <div class="summary-item">
                                <span>Subtotal:</span>
                                <span id="subtotalAmount">0.00 {{ $web_config['currency_sign']->value }}</span>
                            </div>
                            <div class="summary-item">
                                <span>Total SV:</span>
                                <span id="totalSv">0 SV</span>
                            </div>
                            <div class="summary-total">
                                <span>Total:</span>
                                <span id="grandTotal">0.00 {{ $web_config['currency_sign']->value }}</span>
                            </div>

                            <input type="hidden" name="grand_total" id="total_amount_pay_amount" value="0">

                            <button type="submit" class="checkout-btn" id="checkoutBtn" disabled
                                    aria-label="Confirm Purchase">
                                <i class="bi bi-lock-fill me-2" aria-hidden="true"></i>
                                Confirm Purchase
                            </button>

                            <div class="text-center mt-3">
                                <small class="text-muted">
                                    <i class="bi bi-info-circle me-1" aria-hidden="true"></i>
                                    Your available balance:
                                    <strong>{{ number_format(auth('customer')->user()->register_wallet, 2) }} {{ $web_config['currency_sign']->value }}</strong>
                                </small>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div class="loading-overlay d-none" id="loadingOverlay" role="status" aria-label="Loading">
    <div class="spinner"></div>
    <p class="mt-3 text-primary fw-bold">Processing your order...</p>
</div>
@endsection

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="{{ asset('public/assets/member-panel/assets/js/toastr.js') }}?{{ time() }}"></script>
{!! Toastr::message() !!}

<script>
$(document).ready(function() {
    // Initialize select2
    $("#agent").select2({
        placeholder: "Select Distributor",
        allowClear: true,
        templateResult: formatDistributor,
        templateSelection: formatDistributorSelection
    }).on('change', function() {
        const url = $(this).val();
        if (url) {
            window.location = url;
        }
    });

    // Initialize toastr
    toastr.options = {
        positionClass: 'toast-top-right',
        timeOut: 3000,
        closeButton: true,
        progressBar: true,
        preventDuplicates: true
    };

    // Form submission handler
    $('#orderForm').on('submit', function(e) {
        e.preventDefault();
        const total = parseFloat($('#total_amount_pay_amount').val()) || 0;
        const balance = {{ auth('customer')->user()->register_wallet }};

        if (total <= 0) {
            toastr.error('Please select at least one product to purchase');
            return false;
        }

        if (total > balance) {
            toastr.error('Insufficient balance! Please add funds to your wallet.');
            return false;
        }

        if (confirm(`Confirm purchase for ${total.toFixed(2)} {{ $web_config['currency_sign']->value }}?`)) {
            $('#loadingOverlay').removeClass('d-none');
            this.submit();
        }
    });

    // Initialize cart summary
    updateCartSummary();

    // Add keyboard accessibility for quantity inputs
    $('.quantity-input').on('keydown', function(e) {
        if (e.key === 'ArrowUp') {
            adjustQuantity($(this).attr('id').split('_')[1], 1);
            e.preventDefault();
        } else if (e.key === 'ArrowDown') {
            adjustQuantity($(this).attr('id').split('_')[1], -1);
            e.preventDefault();
        }
    });
});

function formatDistributor(distributor) {
    if (!distributor.id) return distributor.text;
    return $(`<span>${distributor.text}</span>`);
}

function formatDistributorSelection(distributor) {
    if (!distributor.id) return distributor.text;
    return $(`<span><i class="bi bi-person me-2" aria-hidden="true"></i>${distributor.text}</span>`);
}

function adjustQuantity(productId, change) {
    const input = $(`#qty_${productId}`);
    const maxStock = parseInt($(`#qty_check_${productId}`).val());
    let newValue = parseInt(input.val()) + change;

    if (isNaN(newValue)) newValue = 0;
    if (newValue < 0) newValue = 0;
    if (newValue > maxStock) {
        toastr.warning(`Only ${maxStock} units available in stock`);
        newValue = maxStock;
    }

    input.val(newValue);
    updateProductTotal(productId);
}

function updateProductTotal(productId) {
    const quantity = parseInt($(`#qty_${productId}`).val()) || 0;
    const price = parseFloat($(`.product_price_${productId}`).val());
    const total = quantity * price;

    $(`#total_price_${productId}`).val(total.toFixed(2));
    updateCartSummary();
}

function updateCartSummary() {
    let subtotal = 0;
    let totalSv = 0;
    let productCount = 0;
    let cartItemsHtml = '';

    const products = $('.product-card').map(function() {
        const productId = $(this).data('product-id');
        const quantity = parseInt($(`#qty_${productId}`).val()) || 0;

        if (quantity > 0) {
            const price = parseFloat($(`.product_price_${productId}`).val());
            const sv = parseFloat($(this).find('.product-sv').text().split(' ')[0]);
            const productTotal = quantity * price;
            const productName = $(this).find('.product-title').text();
            const productImage = $(this).find('.product-image').attr('src');

            subtotal += productTotal;
            totalSv += quantity * sv;
            productCount++;

            cartItemsHtml += `
                <div class="d-flex align-items-center mb-3">
                    <img src="${productImage}" class="rounded me-3" width="50" height="50" alt="${productName}" loading="lazy">
                    <div class="flex-grow-1">
                        <h6 class="mb-0">${productName}</h6>
                        <small class="text-muted">${quantity} × ${price.toFixed(2)} {{ $web_config['currency_sign']->value }}</small>
                    </div>
                    <div class="fw-bold">${productTotal.toFixed(2)} {{ $web_config['currency_sign']->value }}</div>
                </div>
            `;
        }
    }).get();

    if (productCount > 0) {
        $('#emptyCartMessage').addClass('d-none');
        $('#cartItemsContainer').removeClass('d-none');
        $('#selectedProducts').html(cartItemsHtml);
        $('#subtotalAmount').text(`${subtotal.toFixed(2)} {{ $web_config['currency_sign']->value }}`);
        $('#totalSv').text(`${totalSv.toFixed(2)} SV`);
        $('#grandTotal').text(`${subtotal.toFixed(2)} {{ $web_config['currency_sign']->value }}`);
        $('#total_amount_pay_amount').val(subtotal.toFixed(2));
        $('#checkoutBtn').prop('disabled', false);
    } else {
        $('#emptyCartMessage').removeClass('d-none');
        $('#cartItemsContainer').addClass('d-none');
        $('#selectedProducts').html('');
        $('#subtotalAmount').text(`0.00 {{ $web_config['currency_sign']->value }}`);
        $('#totalSv').text('0 SV');
        $('#grandTotal').text(`0.00 {{ $web_config['currency_sign']->value }}`);
        $('#total_amount_pay_amount').val(0);
        $('#checkoutBtn').prop('disabled', true);
    }
}
</script>
@endpush
