@extends('member-panel.layouts.app')

@section('title', 'Product Stock Report')

@push('css')

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
@endpush

@section('content')

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-2">
            <div class="col align-self-center text-left">
                    <h5>Product Stock Report </h5>
                </div>

                <form id="search-form" action="{{ route('member.stock') }}" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-primary">Search</button>
                              </div>
                        </div>
                </form>


                        <table class="table ">
                              <thead>
                                    <tr>
                                          <td align="center">SL</td>
                                          <td align="left">Product Name</td>
                                          <td align="left">Stock</td>
                                          <td align="center">SV</td>
                                          <td align="center">Price</td>

                                    </tr>
                              </thead>
                              <tbody>
                              @php
                                    $total = 0;
                              @endphp
                              @foreach ($report as $v)
                              @php
                                    $total += $v->qty;
                              @endphp
                                    <tr>
                                          <td align="center" class="serial">{{ $v->id }}</td>
                                          <td align="left" style="color:#0909EC;">
                                                 <img style="max-height: 30px;" src="{{ asset('storage/app/public/product/thumbnail/'.$v->thumbnail ) }}" /> {{ $v->name }}
                                          </td>
                                          <td align="center" >{{  $v->qty }} </td>
                                          <td align="center" >{{ $v->sv_point }}</td>
                                          <td align="center">{{ $v->unit_price }}</td>

                                    </tr>
                              @endforeach
                              </tbody>
                              <tfoot>
                                    <tr>
                                          <td colspan="2" align="right">Total  </td>
                                          <td align="center">{{ $total }}</td>
                                          <td class="text-left"></td>
                                          <td class="text-left"></td>
                                    </tr>
                              </tfoot>
                        </table>

                         {{ $report->appends(request()->input())->links() }}
               </div>
            </div>

      </div>

   <!-- main page content ends -->
@endsection


@push('js')
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
@endpush
