@extends('member-panel.layouts.app')
@section('title', 'Member Panel')
@push('css')

@endpush

@section('content')

    <!-- breadcrumb -->
    <div class="container mt-3">
        <div class="row gx-1 align-items-center">
            <div class="col col-sm mb-3 mb-md-0">
                <nav aria-label="breadcrumb" class="mb-1">
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="{{ route('member.dashboard') }}"><i class="bi bi-house-door"></i> Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Profile</li>
                    </ol>
                </nav>
                <h5>Member Profile</h5>
            </div>
            <div class="col-auto mb-3 mb-md-0">
                <a href="{{ route('member.profile-edit') }}" class="btn btn-square btn-theme"><i class="bi bi-pencil"></i></a>
            </div>
        </div>
    </div>

    <!-- content -->
    <div class="container mt-3 mt-lg-4 mt-xl-5" id="main-content">
        <!-- welcome section -->
        <div class="row gx-3">
            <!-- Profile Card -->
            <div class="col-12 col-md-12 col-xl-4">
                <div class="card bg-none mb-3 mb-lg-4">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <!-- User Photo -->
                            <div class="col-12 col-md-auto mb-3 mb-lg-4 text-center">
                              <figure class="avatar avatar-120 rounded coverimg align-middle mx-auto"
                                        style="background-image: url('{{ asset('storage/app/public/profile/' . auth('customer')->user()->image) }}');">
                                    <img src="{{ asset('storage/app/public/profile/' . auth('customer')->user()->image) }}" alt="Profile Picture" style="display: none;">
                                </figure>
                            </div>
                            <!-- Welcome Section -->
                            <div class="col mb-3 mb-lg-4">
                                <h4 class="fw-bold text-theme-accent-1 mb-0">{{ auth('customer')->user()->f_name .' '. auth('customer')->user()->l_name }}</h4>
                                <p class="mb-2 text-truncated">{{ auth('customer')->user()->email }}</p>
                                <p class="small text-secondary">Member since {{ date('Y', strtotime(auth('customer')->user()->created_at)) }}</p>
                            </div>
                        </div>

                        <div class="row gx-3">
                            <div class="col stats-card">
                                <h3 class="stats-number mb-0">{{ auth('customer')->user()->left_count }}</h3>
                                <p class="stats-label">A Team Members</p>
                            </div>
                            <div class="col stats-card text-end">
                                <h3 class="stats-number mb-0">{{ auth('customer')->user()->right_count }}</h3>
                                <p class="stats-label">B Team Members</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contact Information -->
            <div class="col-12 col-md-6 col-xl-4">
                <div class="card bg-none mb-3 mb-lg-4">
                    <div class="card-body">
                        <p class="text-secondary mb-3"><i class="bi bi-person-badge info-icon"></i>Rank: {{ auth('customer')->user()->rank }}</p>
                        <p class="text-secondary mb-3"><i class="bi bi-envelope info-icon"></i>{{ auth('customer')->user()->email }}</p>
                        <p class="text-secondary mb-3"><i class="bi bi-telephone info-icon"></i>{{ auth('customer')->user()->phone }}</p>
                        <p class="text-secondary mb-3"><i class="bi bi-cake info-icon"></i>{{ auth('customer')->user()->dob }}</p>
                        <p class="text-secondary mb-3"><i class="bi bi-droplet info-icon"></i>Blood Group: {{ auth('customer')->user()->blood }}</p>
                        <p class="text-secondary d-flex"><i class="bi bi-geo-alt info-icon"></i><span>{{ auth('customer')->user()->street_address }}</span></p>
                    </div>
                </div>
            </div>

            <!-- Membership Status -->
            <div class="col-12 col-md-6 col-xl-4">
                <div class="card border-0 position-relative overflow-hidden subscription-card p-1 mb-3 mb-lg-4">
                    <div class="subscription-bg" style="background-image: url('assets/img/bg-pattern.jpg');"></div>
                    <div class="height-110 p-3 text-white z-index-1">
                        <div class="row gx-3 align-items-center">
                            <div class="col">
                                <h5 class="mb-0">Membership Status</h5>
                                <p>{{ @DB::table('invest_manages')->where('id',auth('customer')->user()->pack_id)->first()->amount }} SV Active</p>
                            </div>
                            <div class="col-auto">
                                <div class="btn btn-light btn-sm btn-square"><i class="bi bi-star-fill"></i></div>
                            </div>
                        </div>
                    </div>
                    <div class="card adminuiux-card shadow-sm bg-none blur-overlay overflow-hidden position-relative" style="--bs-border-radius: 1.15rem;">
                        <div class="card-body z-index-1">
                            <div class="row gx-3 align-items-center">
                                <div class="col-auto">
                                    <div class="avatar avatar-50 rounded border border-theme-1 bg-light"><i class="bi bi-person-check text-theme-accent-1"></i></div>
                                </div>
                                <div class="col">
                                    <h6 class="mb-0">ID: {{ auth('customer')->user()->user_id }}</h6>
                                    <p class="small text-secondary">
                                        Joined:
                                        @php
                                            $specifiedDate = new DateTime(auth('customer')->user()->created_at);
                                            $currentDate = new DateTime();
                                            $interval = $currentDate->diff($specifiedDate);
                                            $days = $interval->days;
                                            echo "$days days ago";
                                        @endphp
                                    </p>
                                </div>
                                <div class="col-auto text-end">
                                    <h6 class="mb-0">CID: {{ auth('customer')->user()->id }}</h6>
                                    <p class="small text-success"><i class="bi bi-check-circle"></i> Active</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row gx-3">
            <!-- Menu Items -->
            <div class="col-12 col-md-12 col-xl-8">
                <div class="list-group adminuiux-list-group mb-3 mb-lg-4">
                    <a class="list-group-item list-group-item-action" href="{{ route('member.dashboard') }}">
                        <div class="row gx-0 align-items-center">
                            <div class="col"><i class="bi bi-speedometer2 avatar avatar-18 me-3"></i>My Dashboard</div>
                            <div class="col-auto">
                                <span class="small text-success">Active</span>
                            </div>
                            <div class="col-auto"><span class="arrow bi bi-chevron-right ms-2"></span></div>
                        </div>
                    </a>

                    <div class="list-group-item">
                        <div class="row gx-0 align-items-center">
                            <div class="col"><i class="bi bi-people avatar avatar-18 me-3"></i>Genealogy Information</div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-6">
                                <small class="text-muted">Sponsor ID:</small>
                                <div class="fw-bold">{{ auth('customer')->user()->sponser }}</div>
                            </div>
                            <div class="col-6">
                                <small class="text-muted">Placement ID:</small>
                                <div class="fw-bold">{{ auth('customer')->user()->placement_id }}</div>
                            </div>
                        </div>
                    </div>

                    <div class="list-group-item">
                        <div class="row gx-0 align-items-center">
                            <div class="col"><i class="bi bi-person-hearts avatar avatar-18 me-3"></i>Family Information</div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-6">
                                <small class="text-muted">Father's Name:</small>
                                <div class="fw-bold">{{ auth('customer')->user()->father }}</div>
                            </div>
                            <div class="col-6">
                                <small class="text-muted">Mother's Name:</small>
                                <div class="fw-bold">{{ auth('customer')->user()->mother }}</div>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-6">
                                <small class="text-muted">Nominee:</small>
                                <div class="fw-bold">{{ auth('customer')->user()->nominee }}</div>
                            </div>
                            <div class="col-6">
                                <small class="text-muted">Religion:</small>
                                <div class="fw-bold">{{ auth('customer')->user()->religion }}</div>
                            </div>
                        </div>
                    </div>

                    <div class="list-group-item">
                        <div class="row gx-0 align-items-center">
                            <div class="col"><i class="bi bi-card-text avatar avatar-18 me-3"></i>Identity Information</div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-12">
                                <small class="text-muted">NID/Birth Certificate:</small>
                                <div class="fw-bold">{{ auth('customer')->user()->nid }}</div>
                            </div>
                        </div>
                    </div>
                    <a class="list-group-item list-group-item-action" href="{{ route('member.profile-edit') }}">
                        <div class="row">
                            <div class="col"><i class="bi bi-gear avatar avatar-18 me-3"></i>Account Settings</div>
                            <div class="col-auto"><span class="arrow bi bi-chevron-right"></span></div>
                        </div>
                    </a>
                    <a class="list-group-item list-group-item-action theme-red" href="{{ route('customer.auth.logout') }}">
                        <div class="row">
                            <div class="col"><i class="bi bi-power avatar avatar-18 me-3"></i>Logout</div>
                            <div class="col-auto"><span class="arrow bi bi-chevron-right"></span></div>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Additional Stats -->
            <div class="col-12 col-md-12 col-xl-4">
                <div class="card bg-none mb-3 mb-lg-4">
                    <div class="card-body">
                        <h6 class="mb-3">Account Overview</h6>
                        <div class="row mb-3">
                            <div class="col">
                                <small class="text-muted">Join Duration</small>
                                <div class="fw-bold">
                                    @php
                                        $specifiedDate = new DateTime(auth('customer')->user()->created_at);
                                        $currentDate = new DateTime();
                                        $interval = $currentDate->diff($specifiedDate);
                                        $days = $interval->days;
                                        $hours = $interval->h;
                                        echo "$days days, $hours hours";
                                    @endphp
                                </div>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-6">
                                <small class="text-muted">Total A Team</small>
                                <div class="fw-bold text-success">{{ auth('customer')->user()->left_count }}</div>
                            </div>
                            <div class="col-6">
                                <small class="text-muted">Total B Team</small>
                                <div class="fw-bold text-primary">{{ auth('customer')->user()->right_count }}</div>
                            </div>
                        </div>
                        <div class="progress" style="height: 8px;">
                            @php
                                $totalTeam = auth('customer')->user()->left_count + auth('customer')->user()->right_count;
                                $leftPercentage = $totalTeam > 0 ? (auth('customer')->user()->left_count / $totalTeam) * 100 : 50;
                            @endphp
                            <div class="progress-bar bg-success" style="width: {{ $leftPercentage }}%"></div>
                            <div class="progress-bar bg-primary" style="width: {{ 100 - $leftPercentage }}%"></div>
                        </div>
                        <div class="row mt-2">
                            <div class="col text-center">
                                <small class="text-success">A Team {{ number_format($leftPercentage, 1) }}%</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')
<script>
// Add loading animations
document.addEventListener('DOMContentLoaded', function() {
    // Animate cards on load
    const cards = document.querySelectorAll('.card');
    cards.forEach((card, index) => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(20px)';

        setTimeout(() => {
            card.style.transition = 'all 0.6s ease';
            card.style.opacity = '1';
            card.style.transform = 'translateY(0)';
        }, index * 100);
    });

    // Add ripple effect to buttons
    const buttons = document.querySelectorAll('.btn');
    buttons.forEach(button => {
        button.addEventListener('click', function(e) {
            const ripple = document.createElement('div');
            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            const x = e.clientX - rect.left - size / 2;
            const y = e.clientY - rect.top - size / 2;

            ripple.style.cssText = `
                position: absolute;
                width: ${size}px;
                height: ${size}px;
                left: ${x}px;
                top: ${y}px;
                background: rgba(255, 255, 255, 0.3);
                border-radius: 50%;
                transform: scale(0);
                animation: ripple 0.6s linear;
                pointer-events: none;
            `;

            this.style.position = 'relative';
            this.style.overflow = 'hidden';
            this.appendChild(ripple);

            setTimeout(() => {
                ripple.remove();
            }, 600);
        });
    });
});

// Add CSS for ripple animation
const style = document.createElement('style');
style.textContent = `
    @keyframes ripple {
        to {
            transform: scale(4);
            opacity: 0;
        }
    }
`;
document.head.appendChild(style);
</script>
@endpush
