@extends('member-panel.layouts.app')

@section('title', 'Member Panel | Profile Edit')

@push('css')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
@endpush

@section('content')

   <!-- main page content -->
   <div class="main-container card adminuiux-card shadow-sm container">
        <form method="post" id="upload_form" enctype="multipart/form-data" >
            @csrf
            <!-- profile information -->
            <div class="row mb-3">
                <div class="col">
                    <h6>Profile Update </h6>
                </div>
            </div>
            <div class="row h-100 mb-4">
                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating  mb-3">
                        <input type="text" class="form-control" required  placeholder="First name" id="f_name" name="f_name" value="{{ $infos->f_name }}" >
                        <label for="f_name">First Name</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating  mb-3">
                        <input type="text" class="form-control" required  placeholder="Last name" id="l_name" name="l_name" value="{{ $infos->l_name }}" >
                        <label for="l_name">Last Name</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <input type="text" class="form-control" required  placeholder="phone" id="phone" name="phone" value="{{ $infos->phone }}">
                        <label for="phone">Phone</label>
                    </div>
                </div>


                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <input type="text" class="form-control" required  placeholder="Father" id="father" name="father" value="{{ $infos->father }}">
                        <label for="Father">Father</label>
                    </div>
                </div>


                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <input type="text" class="form-control" required  placeholder="Mother" id="mother" name="mother" value="{{ $infos->mother }}">
                        <label for="Mother">Mother</label>
                    </div>
                </div>


                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <input type="text" class="form-control" required  placeholder="Address" id="street_address" name="street_address" value="{{ $infos->street_address }}">
                        <label for="street_address">Address</label>
                    </div>
                </div>


                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <input type="text" class="form-control" required  placeholder="nid" id="nid" name="nid" value="{{ $infos->nid }}">
                        <label for="nid">National/Birth ID CARD</label>
                    </div>
                </div>


                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <input type="text" class="form-control" required  placeholder="nominee" id="nominee" name="nominee" value="{{ $infos->nominee }}">
                        <label for="nominee">Nominee</label>
                    </div>
                </div>


                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <input type="text" class="form-control" required  placeholder="Enter relation" id="relation" name="relation" value="{{ $infos->relation }}">
                        <label for="relation">relation</label>
                    </div>
                </div>


                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <input type="date" class="form-control" required  placeholder="dob" id="dob" name="dob" value="{{ $infos->dob }}">
                        <label for="dob">Date of Birth</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <select class="form-control" name="blood" required id="blood">
                            <option value="">Select Blood Group</option>
                            <option {{ ($infos->blood == 'A+')? 'selected':'' }} value="A+">A+</option>
                            <option {{ ($infos->blood == 'A-')? 'selected':'' }} value="A-">A-</option>
                            <option {{ ($infos->blood == 'B+')? 'selected':'' }} value="B+">B+</option>
                            <option {{ ($infos->blood == 'B-')? 'selected':'' }} value="B-">B-</option>
                            <option {{ ($infos->blood == 'AB+')? 'selected':'' }} value="AB+">AB+</option>
                            <option {{ ($infos->blood == 'AB-')? 'selected':'' }} value="AB-">AB-</option>
                            <option {{ ($infos->blood == 'O+')? 'selected':'' }} value="O+">O+</option>
                            <option {{ ($infos->blood == 'O-')? 'selected':'' }} value="O-">O-</option>
                        </select>
                        <label for="blood">Blood Group</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <select class="form-control" name="religion" required id="religion">
                            <option value="">Select Religion</option>
                            <option  {{ ($infos->religion == 'Islam')? 'selected':'' }} value="Islam"> Islam </option>
                            <option {{ ($infos->religion == 'Hinduism')? 'selected':'' }} value="Hinduism"> Hinduism </option>
                            <option  {{ ($infos->religion == 'Christianity')? 'selected':'' }} value="Christianity"> Christianity </option>
                            <option {{ ($infos->religion == 'Buddhism')? 'selected':'' }} value="Buddhism"> Buddhism </option>
                            <option {{ ($infos->religion == 'Others')? 'selected':'' }} value="Others"> Others </option>
                        </select>
                        <label for="religion">Religion</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group mb-3">
                        <label for="image" class="form-label">Profile Picture</label>
                        <input type="file" class="form-control" placeholder="picture" id="image" name="image" accept="image/*">
                        <div class="form-text">Upload JPG, PNG, or GIF (Max: 2MB)</div>
                    </div>
                </div>

                <div class="col-12">
                    <button type="submit" class="btn btn-primary btn-lg w-100 sned">
                        <i id="icon_class" class="" style="font-size: 16px;"></i>
                        <span class="ms-2">Update Profile</span>
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Password Update Section -->
    <div class="main-container card adminuiux-card shadow-sm container mt-5">
        <form method="post" id="password_update" enctype="multipart/form-data">
            @csrf
            <div class="row mb-3">
                <div class="col">
                    <h6>Change Password</h6>
                </div>
            </div>
            <div class="row h-100 mb-4">
                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" required placeholder="Current Password" name="oldpassword" id="oldpassword">
                        <label for="oldpassword">Current Password</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" required placeholder="New Password" name="password" id="password" minlength="6">
                        <label for="password">New Password</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" required placeholder="Confirm Password" name="confirmpassword" id="confirmpassword" minlength="6">
                        <label for="confirmpassword">Confirm New Password</label>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <button type="submit" class="btn btn-warning btn-lg w-100 snedp">
                        <i id="icon_class2" class="" style="font-size: 16px;"></i>
                        <span class="ms-2">Update Password</span>
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Transaction Password Section -->
    <div class="main-container card adminuiux-card shadow-sm container mt-5">
        <form method="post" id="tran_password_update" enctype="multipart/form-data">
            @csrf
            <div class="row mb-3">
                <div class="col">
                    <h6>Transaction Password</h6>
                </div>
            </div>
            <div class="row h-100 mb-4">
                @if(auth('customer')->user()->trans_password)
                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" required placeholder="Current Transaction Password" name="toldpassword" id="toldpassword">
                        <label for="toldpassword">Current Transaction Password</label>
                    </div>
                </div>
                @endif

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" required placeholder="Transaction Password" name="tpassword" id="tpassword" minlength="4">
                        <label for="tpassword">New Transaction Password</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-floating mb-3">
                        <input type="password" class="form-control" required placeholder="Confirm Transaction Password" name="tconfirmpassword" id="tconfirmpassword" minlength="4">
                        <label for="tconfirmpassword">Confirm Transaction Password</label>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <button type="submit" class="btn btn-success btn-lg w-100 snedt">
                        <i id="icon_class3" class="" style="font-size: 16px;"></i>
                        <span class="ms-2">Update Transaction Password</span>
                    </button>
                </div>
            </div>
        </form>
    </div>

@endsection

@push('js')


<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
<script>
    var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');

    $(document).ready(function () {
        // Profile Update Form
        $('#upload_form').on('submit', function (event) {
            event.preventDefault();
            $(".sned").prop('disabled', true);
            $('#icon_class').addClass('fa fa-spinner fa-spin');

            $.ajax({
                url: "{{ route('member.profile-update') }}",
                method: "POST",
                cache: false,
                contentType: false,
                processData: false,
                data: new FormData(this),
                success: function (data) {
                    $('#icon_class').removeClass('fa fa-spinner fa-spin');
                    $(".sned").prop('disabled', false);

                    Toastify({
                        text: data.message,
                        duration: 3000,
                        newWindow: true,
                        close: true,
                        gravity: "top",
                        position: "center",
                        stopOnFocus: true,
                        style: {
                            background: data.color,
                        },
                        onClick: function(){}
                    }).showToast();
                },
                error: function(xhr, status, error) {
                    $('#icon_class').removeClass('fa fa-spinner fa-spin');
                    $(".sned").prop('disabled', false);

                    Toastify({
                        text: "An error occurred. Please try again.",
                        duration: 3000,
                        gravity: "top",
                        position: "center",
                        style: {
                            background: "linear-gradient(to right, #ff5f6d, #ffc371)",
                        }
                    }).showToast();
                }
            });
        });

        // Password Update Form
        $('#password_update').on('submit', function (event) {
            event.preventDefault();

            // Client-side validation
            if ($('#password').val() !== $('#confirmpassword').val()) {
                Toastify({
                    text: "Passwords do not match!",
                    duration: 3000,
                    gravity: "top",
                    position: "center",
                    style: {
                        background: "linear-gradient(to right, #ff5f6d, #ffc371)",
                    }
                }).showToast();
                return;
            }

            $(".snedp").prop('disabled', true);
            $('#icon_class2').addClass('fa fa-spinner fa-spin');

            $.ajax({
                url: "{{ route('member.password-update') }}",
                method: "POST",
                cache: false,
                contentType: false,
                processData: false,
                data: new FormData(this),
                success: function (data) {
                    $('#icon_class2').removeClass('fa fa-spinner fa-spin');
                    $(".snedp").prop('disabled', false);

                    Toastify({
                        text: data.message,
                        duration: 3000,
                        newWindow: true,
                        close: true,
                        gravity: "top",
                        position: "center",
                        stopOnFocus: true,
                        style: {
                            background: data.color,
                        },
                        onClick: function(){}
                    }).showToast();

                    if(data.status === 200){
                        $('#oldpassword').val('');
                        $('#password').val('');
                        $('#confirmpassword').val('');
                    }
                },
                error: function(xhr, status, error) {
                    $('#icon_class2').removeClass('fa fa-spinner fa-spin');
                    $(".snedp").prop('disabled', false);

                    Toastify({
                        text: "An error occurred. Please try again.",
                        duration: 3000,
                        gravity: "top",
                        position: "center",
                        style: {
                            background: "linear-gradient(to right, #ff5f6d, #ffc371)",
                        }
                    }).showToast();
                }
            });
        });

        // Transaction Password Update Form
        $('#tran_password_update').on('submit', function (event) {
            event.preventDefault();

            // Client-side validation
            if ($('#tpassword').val() !== $('#tconfirmpassword').val()) {
                Toastify({
                    text: "Transaction passwords do not match!",
                    duration: 3000,
                    gravity: "top",
                    position: "center",
                    style: {
                        background: "linear-gradient(to right, #ff5f6d, #ffc371)",
                    }
                }).showToast();
                return;
            }

            $(".snedt").prop('disabled', true);
            $('#icon_class3').addClass('fa fa-spinner fa-spin');

            $.ajax({
                url: "{{ route('member.tran-password-update') }}",
                method: "POST",
                cache: false,
                contentType: false,
                processData: false,
                data: new FormData(this),
                success: function (data) {
                    $('#icon_class3').removeClass('fa fa-spinner fa-spin');
                    $(".snedt").prop('disabled', false);

                    Toastify({
                        text: data.message,
                        duration: 3000,
                        newWindow: true,
                        close: true,
                        gravity: "top",
                        position: "center",
                        stopOnFocus: true,
                        style: {
                            background: data.color,
                        },
                        onClick: function(){}
                    }).showToast();

                    if(data.status === 200){
                        $('#toldpassword').val('');
                        $('#tpassword').val('');
                        $('#tconfirmpassword').val('');
                    }
                },
                error: function(xhr, status, error) {
                    $('#icon_class3').removeClass('fa fa-spinner fa-spin');
                    $(".snedt").prop('disabled', false);

                    Toastify({
                        text: "An error occurred. Please try again.",
                        duration: 3000,
                        gravity: "top",
                        position: "center",
                        style: {
                            background: "linear-gradient(to right, #ff5f6d, #ffc371)",
                        }
                    }).showToast();
                }
            });
        });
    });
</script>
@endpush
