@extends('member-panel.layouts.app')

@section('title', 'Dealer Commission')

@push('css')

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
@endpush

@section('content')

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-0">
            <div class="col align-self-center text-left">
                    <h5>Dealer Commission Report</h5>
                </div>

                <form id="search-form" action="{{ route('member.dealer-commission') }}" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-primary">Search</button>
                              </div>
                        </div>
                </form>


                        <table class="table ">
                              <thead>
                                    <tr>
                                          <td>Date</td>
                                          <td>Order ID</td>
                                          <td>User ID</td>
                                          <td>SV Sale</td>
                                          <td>Amount</td>
                                    </tr>
                              </thead>
                              <tbody>
                              @php
                                    $total = 0;
                              @endphp
                              @foreach ($report as $item)
                              @php
                                    $total += $item->amount;
                              @endphp
                              @if($item->user_id == 'admin')
                                 @php  $username = $item->user_id;  @endphp
                              @else
                                @php   $username = DB::table('users')->where('id',$item->user_id)->first()->user_id;  @endphp
                              @endif

                                    <tr>
                                    <td>{{  date('h:i a d/m/Y', strtotime( $item->created_at)) }}</td>
                                    <td><a href="{{ url('member/order-detail/'.$item->order_id) }}" target="_blank">#{{$item->order_id}}</td>
                                    <td>{{ $username }}</td>
                                    <td>{{ $item->main_amount }}</td>
                                    <td>{{ $item->amount }}</td>
                                    </tr>
                              @endforeach
                              </tbody>
                              <tfoot>
                                    <tr>
                                          <td></td>
                                          <td></td>
                                          <td></td>
                                          <td>Total</td>
                                          <td> {{ $web_config['currency_sign']->value }}  {{ number_format($total,2) }} </td>
                                     </tr>
                              </tfoot>
                        </table>

                         {{ $report->appends(request()->input())->links() }}
               </div>
            </div>

      </div>

   <!-- main page content ends -->
@endsection


@push('js')
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
@endpush
