@extends('member-panel.layouts.app')

@section('title', 'Generation Commission')

@push('css')

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
@endpush

@php
function numberToOrdinal($number) {
    if ($number % 100 >= 11 && $number % 100 <= 13) {
        return $number . 'th';
    } else {
        switch ($number % 10) {
            case 1:
                return $number . 'st';
            case 2:
                return $number . 'nd';
            case 3:
                return $number . 'rd';
            default:
                return $number . 'th';
        }
    }
}
@endphp

@section('content')

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-2">
            <div class="col align-self-center text-left">
                    <h5>Generation Commission Report</h5>
                </div>

                <form id="search-form" action="{{ route('member.generation-commission') }}" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-primary">Search</button>
                              </div>
                        </div>
                </form>


                        <table class="table ">
                              <thead>
                                    <tr>
                                          <td>Date</td>
                                          <td>From User</td>
                                          <td>Generation Level</td>
                                          <td>Amount</td>
                                    </tr>
                              </thead>
                              <tbody>
                              @php
                                    $total = 0;
                              @endphp
                              @foreach ($report as $item)
                              @php
                                    $total += $item->amount;
                                    $user = DB::table('users')->where('id',$item->reg_id)->first(['user_id','f_name','l_name']);
                              @endphp
                                    <tr>
                                          <td>{{  date('h:i a d/m/Y', strtotime( $item->created_at)) }}</td>
                                          <td>{{ $user->user_id }} </td>
                                         <td>{{ numberToOrdinal($item->gen ) }} Generation</td>
                                          <td>{{ $item->amount }}</td>
                                    </tr>
                              @endforeach
                              </tbody>
                              <tfoot>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td align="right">Total</td>
                                       <td> {{ $web_config['currency_sign']->value }} {{ number_format($total,2) }} </td>

                                    </tr>
                              </tfoot>
                        </table>

                         {{ $report->appends(request()->input())->links() }}
               </div>
            </div>

      </div>

   <!-- main page content ends -->
@endsection


@push('js')
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
@endpush
