@extends('member-panel.layouts.app')

@section('title', 'Incentive Commission')

@push('css')

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
@endpush

@section('content')

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-0">
            <div class="col align-self-center text-left">
                    <h5>Incentive Commission Report</h5>
                </div>

                <form id="search-form" action="{{ route('member.incentive-commission') }}" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-primary">Search</button>
                              </div>
                        </div>
                </form>


                        <table class="table ">
                              <thead>
                                    <tr>
                                          <td>Date</td>
                                          <td>Rank</td>
                                          <td>Incentive</td>
                                          <td>Status
                                    </td>
                                    </tr>
                              </thead>
                              <tbody>
                              @php
                                    $total = 0;
                              @endphp
                              @foreach ($report as $item)

                                    <tr>
                                    <td>{{  date('h:i a d/m/Y', strtotime( $item->created_at)) }}</td>
                                    <td>{{ rank_name($item->rank) }}</td>
                                    <td>{{ $item->rank_bonus }}</td>
                                     @if(  $item->status  == 'pending')
                                     <td> <button class="btn btn-danger btn-sm">
                                     {{ $item->status }}
                                     </button>  </td>
                                       @else
                                     <td> <button class="btn btn-success btn-sm">
                                     {{ $item->status }}
                                     </button>  </td>
                                    @endif
                                    </tr>
                              @endforeach
                              </tbody>
                            {{--  <tfoot>
                                    <tr>
                                    <td>Total</td>
                                    <td>{{ number_format($total,2) }}  {{ $web_config['currency_sign']->value }} </td>
                                    </tr>
                              </tfoot> --}}
                        </table>

                         {{ $report->appends(request()->input())->links() }}
               </div>
            </div>

      </div>

   <!-- main page content ends -->
@endsection


@push('js')
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
@endpush
