@extends('member-panel.layouts.app')

@section('title', 'Purchase Wallet Report')

@push('css')

<style>
      #search-form {
        text-align: right;
      }
      .sym {
            width: 155px;
      }
      .btn-primary{ font-size: 12px !important;}
</style>
@endpush

@section('content')

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-0">

                        <div class="row">
                              <div class="col-md-8 offset-md-2">
                                    <div class="card ">
                                          <div class=" p-1 m-0 text-center st-val text-white">   <h5>Purchase Wallet Report</h5></div>
                                          <div class="card-body">
                                                <div class="table-responsive">
                                                      <table class="w-100 table table-bordered ">
                                                            <tbody><tr style="background: cadetblue;font-size: 20px;color: white;">
                                                                  <th colspan="3">Balance Inflow</th>
                                                            </tr>
                                                            <tr>
                                                                  <th>Cash In From Admin</th>
                                                                  <td class="sym"><span>{{ $web_config['currency_sign']->value }}  </span>
                                                                  {{ number_format($cashin,2) }}</td>
                                                                  <td style="width: 120px;"><a href="{{ route('member.cashin-list') }}" class="btn btn-sm btn-primary cust-btn">View Details</a></td>
                                                            </tr>
                                                            <tr>
                                                                  <th>In From User</th>
                                                                  <td class="sym"><span>{{ $web_config['currency_sign']->value }}  </span>
                                                                  {{ number_format($received,2) }}</td>
                                                                  <td style="width: 120px;"><a href="{{ route('member.balance-received') }}" class="btn btn-sm btn-primary cust-btn">View Details</a></td>
                                                            </tr>
                                                            <tr>
                                                                  <th> Product Delivery</th>
                                                                  <td class="sym"><span>{{ $web_config['currency_sign']->value }}  </span>
                                                                  {{ number_format($product_delivery,2) }}</td>
                                                                  <td style="width: 120px;"><a href="{{ route('member.delivery') }}" class="btn btn-sm btn-primary cust-btn">View Details</a></td>
                                                            </tr>

                                                            <tr style="background: aliceblue;font-size: 18px;font-weight: bold;">
                                                                  <th>Total Inflow</th>
                                                                  <td colspan="2" class="sym"><span>{{ $web_config['currency_sign']->value }}  </span>{{ number_format($total_income = $cashin + $received + $product_delivery ,2) }}</td>
                                                            </tr>
                                                      </tbody>
                                                      </table>
                                                      <table class="w-100 table  table-bordered">
                                                            <tbody><tr style="background: cadetblue;font-size: 20px;color: white;">
                                                                  <th colspan="3">Balance Expense</th>
                                                            </tr>
                                                            <tr>
                                                                  <th>Transfer Out</th>
                                                                  <td class="sym"><span>{{ $web_config['currency_sign']->value }}  </span>{{ number_format($transfer,2) }}</td>
                                                                  <td style="width: 120px;"><a href="{{ route('member.balance') }}" class="btn btn-sm btn-primary cust-btn">View Details</a></td>
                                                            </tr>
                                                            <!-- <tr>
                                                                  <th>Joining Expense</th>
                                                                  <td class="sym"><span>{{ $web_config['currency_sign']->value }}  </span>{{ number_format($transfer,2) }}</td>
                                                                  <td style="width: 120px;"><a href="{{ route('member.balance') }}" class="btn btn-sm btn-primary cust-btn">View Details</a></td>
                                                            </tr> -->
                                                            <tr>
                                                                  <th>Product Order</th>
                                                                  <td class="sym"><span>{{ $web_config['currency_sign']->value }}  </span>{{ number_format($product_order,2) }}</td>
                                                                  <td style="width: 120px;"><a href="{{ route('member.orders') }}" class="btn btn-sm btn-primary cust-btn">View Details</a></td>
                                                            </tr>
                                                            <tr style="background: aliceblue;font-size: 18px;font-weight: bold;">
                                                                  <th>Total Expense</th>
                                                                  <td colspan="2" class="sym"><span>{{ $web_config['currency_sign']->value }}  </span>{{ number_format( $total_expense =  $transfer + $product_order,2) }}</td>
                                                            </tr>
                                                            <tr>
                                                                  <th style="font-size: 18px; color: green;">Current Balance</th>
                                                                  <th  colspan="2"><span style="font-size: 18px; color: green;"> <span>{{ $web_config['currency_sign']->value }} </span>{{ number_format($total_income - $total_expense,2) }}</span></th>
                                                            </tr>

                                                      </tbody></table>
                                                </div>
                                          </div>
                                    </div>
                              </div>
                        </div>

               </div>
            </div>

      </div>

   <!-- main page content ends -->
@endsection

@push('js')

@endpush
