@extends('member-panel.layouts.app')
@section('title', 'Member Panel')
@push('css')  
    <style>
          #thumbnail {
            cursor: pointer;
        }

        #large-image-container {
            display: none;
            position: fixed;
            z-index: 9999;
            padding: 20px;
            text-align: center;
            background-color: rgba(0,0,0,0.7);
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
        }

        #large-image {
            max-width: 80%;
            max-height: 80%;
            margin: auto;
            display: block;
        }

        #large-image-container span {
            color: red;
            font-size: 14px;

            position: relative;
            top: 10px;
            right: 20px;
            cursor: pointer;
        }

    </style>
    
    
    <!-- Include jQuery from CDN -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <!-- Include Fancybox CSS and JS from CDN -->
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>


@endpush
@section('content')
   <!-- main page content -->
   <div class="main-container container">
            <!-- welcome user -->
           
            <div class="row mb-3">
                <div class="col">
                    <h6 class="title">News Gallery</h6>
                </div>
                <div class="col-auto">
                </div>
            </div>
          

            <!-- Content with images -->
            <div class="gallery">
                 @foreach($banners as $v)
                    <a  href="{{ asset('storage/app/public/banner/'.$v->photo) }}" data-fancybox="images" data-caption="{{ $v->title }}">
                        <img class="h-190 shadow-sm rounded-10  mb-3 " style="max-width:250px;" src="{{ asset('storage/app/public/banner/'.$v->photo) }}" alt="{{ $v->title }}">
                    </a>
                @endforeach   
            </div>
        

        </div>
        <!-- main page content ends -->



@endsection


@push('js')



    <script>
        $(document).ready(function () {
            // Initialize Fancybox for images
            $('[data-fancybox="images"]').fancybox({
                // Optional configuration options
            });
        });
    </script>
    
    
@endpush
