@extends('member-panel.layouts.app')
@section('title', 'Member Panel')
@push('css')
   <style>
        :root {
            --adminuiux-content-font: "Open Sans", serif;
            --adminuiux-content-font-weight: 400;
            --adminuiux-title-font: "Poppins", serif;
            --adminuiux-title-font-weight: 600;
        }


        .floating {
            animation: float 6s ease-in-out infinite;
        }

        .glass-effect {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .breaking-news-container {
            border-radius: 15px;
            padding: 20px;
            margin-top: 0;
            overflow: hidden;
            position: relative;
        }

        .news-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .breaking-badge {

            background: linear-gradient(45deg, #e46dce, #c80036);
            color: white;
            padding: 8px 15px;
            border-radius: 25px;
            font-size: 12px;
            font-weight: 700;
            letter-spacing: 1px;
            text-transform: uppercase;
            box-shadow: 0 4px 15px rgba(255, 71, 87, 0.4);
            animation: pulse-glow 2s infinite;
        }

        .live-indicator {
            color: #2ed573;
            font-size: 12px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .live-dot {
            width: 8px;
            height: 8px;
            background: #2ed573;
            border-radius: 50%;
            animation: blink 1.5s infinite;
        }

        .news-ticker {
            background: rgba(0, 0, 0, 0.3);
            border-radius: 10px;
            padding: 15px;
            overflow: hidden;
            position: relative;
            height: 22px;
            display: flex;
            align-items: center;
        }

        .ticker-content {
            display: flex;
            white-space: nowrap;
            animation: scroll-news 60s linear infinite;
            gap: 50px;
        }

        .news-item {
            color: white;
            font-size: 14px;
            font-weight: 500;
            padding: 0 20px;
            display: inline-block;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.5);
        }

        @keyframes scroll-news {
            0% { transform: translateX(0); }
            100% { transform: translateX(-100%); }
        }

        @keyframes pulse-glow {
            0%, 100% {
                box-shadow: 0 4px 15px rgba(255, 71, 87, 0.4);
                transform: scale(1);
            }
            50% {
                box-shadow: 0 6px 25px rgba(255, 71, 87, 0.7);
                transform: scale(1.05);
            }
        }

        @keyframes blink {
            0%, 50% { opacity: 1; }
            51%, 100% { opacity: 0.3; }
        }

        .news-ticker:hover .ticker-content {
            animation-play-state: paused;
        }
    </style>
@endpush
@section('content')

                                    <div class="container mt-3 mt-lg-4 mt-xl-5" id="main-content">
                                                <!-- welcome -->
                                       <div class="gx-3 align-items-center mb-xl-3 pb-2">
                                            <div class="breaking-news-container glass-effect">
                                                <div class="news-header">
                                                    <span class="breaking-badge">
                                                        <i class="fas fa-bolt"></i> BREAKING NEWS
                                                    </span>
                                                    <span class="live-indicator">
                                                        <span class="live-dot"></span> LIVE
                                                    </span>
                                                </div>
                                                <div class="news-ticker">
                                                    <div class="ticker-content">
                                                        <span class="news-item">🔴 {{ $notice->title }}</span>
                                                        <span class="news-item">🔴 {{ $notice->title }}</span>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class=" d-none"><div id="circleprogressblue1" class="lh-14"></div><div id="circleprogressgreen1" class="lh-14"></div>
                                        </div>

                                        <div class="row gx-3 gx-lg-4">
                                            <!-- summary and que balance -->
                                            <div class="col-12 col-md-12 col-xl-4">
                                                <div class="card border-0 position-relative overflow-hidden bg-theme-1 p-1 mb-3 mb-lg-4">
                                                    <div class="coverimg top-0 start-0 h-100 w-100 position-absolute z-index-0 opacity-75">
                                                        <img src="{{asset('public/assets/member-panel2')}}/assets/img/ecommerce/image-4.jpg" alt="">
                                                    </div>
                                                    <div class="height-130 p-3 text-black z-index-1">
                                                        <h1 class="mb-0">{{ $web_config['currency_sign']->value }} {{ number_format( auth('customer')->user()->register_wallet , 2) }}</h1>
                                                        <h6 class="mb-1"> Shopping Balance </h6>

                                                    </div>
                                                <div class="card adminuiux-card bg-none blur-overlay overflow-hidden position-relative" style="--bs-border-radius: 1.15rem;">
                                                        <div class="card-body z-index-1">
                                                            <div class="row gx-3 align-items-center mb-2">
                                                                <div class="col-auto">
                                                                    <div class="avatar avatar-50 rounded border border-theme-1">{{ $web_config['currency_sign']->value }}</div>
                                                                </div>
                                                                <div class="col">
                                                                <h1 class="mb-0">{{ $web_config['currency_sign']->value }} {{ number_format( auth('customer')->user()->income_wallet , 2) }}</h1>
                                                                <h6 class="mb-1"> Income Balance </h6>
                                                                </div>
                                                                <div class="col-auto">
                                                                    <button class="btn btn-square btn-link" data-bs-toggle="collapse" data-bs-target="#dates"><i class="bi bi-calendar-event"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="collapse" id="dates">
                                                                <div class="input-group width-250 pb-3">
                                                                    <input type="text" class="form-control bg-none text-center" id="daterangepickerranges">
                                                                    <span class="input-group-text bg-none" id="calendarpickerrange" onclick="jQuery(this).prev().click()">
                                                                        <i class="bi bi-calendar"></i>
                                                                    </span>
                                                                </div>
                                                            </div>
                                                            <div class="height-100">
                                                                <canvas id="summarychart" width="644" height="200" style="display: block; box-sizing: border-box; height: 100px; width: 322px;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>


                                <!-- dashboard card   bg-theme-accent-r-gradient -->
                                    <div class="row gx-3 gx-lg-4">
                                        @if(0 == 0)
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Refer Commission</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.refer-commission') }}';" style="cursor: pointer;">{{ number_format($spon_com,2) }}<span class="small">{{ $web_config['currency_sign']->value }}</span></h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Generation Commission</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.generation-commission') }}';" style="cursor: pointer;">{{ number_format($gen_com,2) }}<span class="small">{{ $web_config['currency_sign']->value }}</span></h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Matching Commission</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.matching-commission') }}';" style="cursor: pointer;">{{ number_format($matching,2) }}<span class="small">{{ $web_config['currency_sign']->value }}</span></h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Rank Name</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.incentive-commission') }}';" style="cursor: pointer;">
                                                            {{ rank_name(auth('customer')->user()->rank)?'N/A':'N/A' }}
                                                        </h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Rank Reward</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.incentive-commission') }}';" style="cursor: pointer;">{{ number_format(00,2) }}<span class="small">{{ $web_config['currency_sign']->value }}</span></h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Global Commission</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.global-commission') }}';" style="cursor: pointer;">{{ number_format($global_com,2) }}<span class="small">{{ $web_config['currency_sign']->value }}</span></h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Leadership Commission</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.leadership-commission') }}';" style="cursor: pointer;">{{ number_format($leadership,2) }}<span class="small">{{ $web_config['currency_sign']->value }}</span></h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Mentor Commission</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.mentor-commission') }}';" style="cursor: pointer;">{{ number_format($upline,2) }}<span class="small">{{ $web_config['currency_sign']->value }}</span></h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Dealer Refer Commission</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.dealer-commission') }}';" style="cursor: pointer;">{{ number_format(0,2) }}<span class="small">{{ $web_config['currency_sign']->value }}</span></h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Founder Commission</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.dealer-commission') }}';" style="cursor: pointer;">{{ number_format(0,2) }}<span class="small">{{ $web_config['currency_sign']->value }}</span></h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Salary</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.dealer-commission') }}';" style="cursor: pointer;">{{ number_format(0,2) }}<span class="small">{{ $web_config['currency_sign']->value }}</span></h3>
                                                    </div>
                                                </div>
                                            </div>
                                        @else
                                            <div class="col-6 col-md-6 col-xl-3">
                                                <div class="card bg-theme-1-subtle h-100 mb-2 mb-3 mb-lg-4">
                                                    <div class="card-body z-index-1">
                                                        <div class="mb-3">
                                                            <h6 class="mb-0">Dealer Commission</h6>
                                                        </div>
                                                        <h3 class="mb-1" onclick="window.location.href = '{{ route('member.dealer-commission') }}';" style="cursor: pointer;">{{ number_format($dealer,2) }}<span class="small">{{ $web_config['currency_sign']->value }}</span></h3>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                            <!-- dashboard card -->
                        </div>
@endsection

@push('js')

@endpush
