@extends('member-panel.layouts.app')
@section('title', 'Member Panel')
@push('css')

 <style>

    .tree {
        display: flex;
        justify-content: center;
        flex-wrap: wrap;
    }

    .node {

        padding: 10px;
        margin: 5px;
        text-align: center;
        cursor: pointer;
    }

    .details {
        display: none;
        margin-top: 10px;
        padding: 10px;

    }
</style>

@endpush
@section('content')


<div class="main-container container">

<div class="row mb-4  card adminuiux-card shadow-sm mb-4">
      <div class="col-12 px-2  table-responsive">

              <div class="row">
                <div class="col">
                   <span class="btn btn-primary btn-sm " >  {{ $users_detail->user_id }}'s   </span>
                </div>

                <div class="col">
                  <span class="btn btn-primary btn-sm " > {{   @numberConvert($gen)  }}  Generation </span>
                </div>
                <div class="col">
                  <span class="btn btn-primary btn-sm " > Total Member :   {{ $allcount  }} </span>
                </div>

                <div class="col">
                 <a class="btn btn-primary btn-sm " href="javascript:history.go(-1)"> <i class="tio-arrow-upward nav-icon"></i>Previous</a>
                </div>
              </div>

          <table class="table ">
                  <thead>
                    <tr>
                        <th>SaL</th>
                        <th>Action</th>
                        <th>User Name</th>
                        <th>Full Name</th>
                        <th>Team Member</th>
                        <th>Sponsor</th>
                        <th>Phone</th>

                        <th>Generation</th>
                        <th>Join Date</th>
                    </tr>
                  </thead>
                  <tbody>
                  @php
                    $total_team_sale = 0; $total_own_purchase = 0;
                  @endphp
                  @foreach($users as $v)
                  @php
                  @endphp
                    <tr>
                        <th>{{ $loop->iteration }}</th>
                        <th><a class="btn btn-sm btn-success" href="{{ url('member/generation-list?gen='.$gen.'&&user='.$v->user_id) }}"><i class="fa fa-plus"></i> </a></th>
                        <th>{{ $v->user_id }}</th>
                        <th>{{ $v->f_name }} {{ $v->l_name }}</th>
                        <th>{{ $v->sponser_count }}</th>
                        <th>{{ $v->sponser }}</th>
                        @if($gen == 1)
                        <th>{{ $v->phone }}</th>
                        @else
                        <th></th>
                        @endif

                        <th>{{ numberConvert($gen) }}</th>
                        <th>{{ date('H:i:s a d-m-Y', strtotime($v->created_at) ) }}</th>
                    </tr>
                  @endforeach
                  </tbody>

          </table>


         </div>
      </div>

</div>




@endsection


@push('js')
    <script>
     // public/js/script.js

     // public/js/script.js
    // public/js/script.js

    $(document).ready(function () {
        // Click event to show/hide details for each node
        $('.node').on('click', function () {
            const userId = $(this).data('id');
            const parentId = $(this).closest('.details').data('parent-id');

            // Ajax request to get the next generation
            $.ajax({
                url: '{{ url('user/get-generations') }}',
                type: 'GET',
                data: { user_id: userId },
                success: function (response) {
                    // Update the details within the parent .details block
                    $(`.details[data-parent-id=${parentId}]`).html(response.html).show();
                },
                error: function (error) {
                    console.log(error);
                }
            });

            // Hide details of other nodes
            $('.node').not(this).find('.details').hide();
        });
    });

    </script>
@endpush
