@extends('member-panel.layouts.app')

@section('title', 'Investment Packages')

@push('css')

<link rel="stylesheet" href="{{asset('public/assets/member-panel')}}/assets/css/toastr.css?{{ time() }}">
 <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
<style>
#customers {
  font-family: Arial, Helvetica, sans-serif;
  border-collapse: collapse;
  width: 100%;
}

#customers td, #customers th {
  border: 1px solid #ddd;
  padding: 8px;
}

#customers tr:nth-child(even){ }



#customers th {
  padding-top: 12px;
  padding-bottom: 12px;
  text-align: left;


}
</style>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<style>
    .packages-section {

        padding: 3rem 0;
        position: relative;
    }

    .section-title {
        margin-bottom: 2.5rem;
        position: relative;
        font-weight: 700;

    }

    .section-title:after {
        content: '';
        display: block;
        width: 80px;
        height: 4px;

        margin: 15px auto 0;
        border-radius: 2px;
    }

    .package-card {
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        transition: all 0.4s ease;
        border: none;
        height: 100%;
        position: relative;
    }

    .package-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 15px 35px rgba(0, 123, 255, 0.15);
    }

    .package-header {


        padding: 1.5rem;
        text-align: center;
        border-radius: 16px 16px 0 0;
    }

    .package-title {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0;
    }

    .package-body {
        padding: 1.8rem;
    }

    .feature-list {
        margin-bottom: 1.5rem;
    }

    .feature-item {
        padding: 0.7rem 0;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        display: flex;
        align-items: center;
    }

    .feature-item:last-child {
        border-bottom: none;
    }

    .feature-icon {
        width: 28px;
        height: 28px;

        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 12px;

        flex-shrink: 0;
    }

    .feature-text {
        font-weight: 500;

    }

    .feature-value {
        font-weight: 700;

    }

    .invest-btn {
        border-radius: 50px;
        padding: 0.8rem 1.5rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.3s;

        border: none;
    }

    .invest-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(40, 167, 69, 0.3);

    }

    .invest-btn i {
        margin-right: 8px;
    }

    @media (max-width: 768px) {
        .package-card {
            margin-bottom: 2rem;
        }
    }
</style>
@endpush

@section('content')
<div class="packages-section">
    <div class="container">
        <h2 class="text-center section-title">
            <i class="bi bi-briefcase-fill me-2"></i>Premium Investment Packages
        </h2>

        <div class="row g-4">
            @foreach($package as $pack)
                <div class="col-md-6 col-lg-4">
                    <div class="card package-card">
                        <div class="package-header">
                            <h5 class="package-title">{{ $pack->title }}</h5>
                        </div>
                        <div class="package-body">
                            <ul class="list-unstyled feature-list">
                                <li class="feature-item">
                                    <div class="feature-icon">
                                        <i class="bi bi-cash"></i>
                                    </div>
                                    <div>
                                        <span class="feature-text">Investment Amount:</span><br>
                                        <span class="feature-value">৳{{ number_format($pack->amount) }}</span>
                                    </div>
                                </li>
                                <li class="feature-item">
                                    <div class="feature-icon">
                                        <i class="bi bi-calendar-check"></i>
                                    </div>
                                    <div>
                                        <span class="feature-text">Duration:</span><br>
                                        <span class="feature-value">{{ $pack->days }} months</span>
                                    </div>
                                </li>
                                <li class="feature-item">
                                    <div class="feature-icon">
                                        <i class="bi bi-graph-up-arrow"></i>
                                    </div>
                                    <div>
                                        <span class="feature-text">Monthly Return:</span><br>
                                        <span class="feature-value">৳{{ number_format($pack->min_trans) }} - ৳{{ number_format($pack->min_with) }}</span>
                                    </div>
                                </li>
                            </ul>

                           <form method="POST" action="{{ url('member/investment_start') }}" onsubmit="return confirmInvestment({{ $pack->amount }})">
                                @csrf
                                <input type="hidden" name="pack_id" value="{{ $pack->id }}">
                                <button type="submit" class="btn btn-success w-100">
                                    <i class="bi bi-cash-coin"></i> Invest Now
                                </button>
                            </form>

                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>

@endsection


@push('js')

  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <!-- Select2 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
    <script>
      $("#agent").select2({
          placeholder: "Select Dealer ",
          allowClear: true
      });
    </script>

<script src="{{asset('public/assets/member-panel/assets')}}/js/toastr.js?{{ time() }}"></script>
    {!! Toastr::message() !!}
        <script>
            function showValue(event,loop_id)
            {
                //enter amount get
                var value        = event.target.value;
                $("#total_received_"+loop_id).attr("value", 0);
                var netAmount    = $(".product_price_"+loop_id).val();

                var printamount  = value * netAmount;
                $("#total_received_"+loop_id).attr("value", printamount);
                $('#total_price_'+loop_id).val(printamount);
                $('.total_price_'+loop_id).text(printamount);
            }
        </script>

        <script>
        function myFunction(input_value, loop_id) {
            var input_value  = parseInt(input_value);
            var qty_check    = parseInt($("#qty_check_"+loop_id).val());
            toastr.options   = {positionClass: 'toast-top-right'};

            if(input_value > qty_check){
                $('.applynow_'+loop_id).val(0);
                $('.total_price_'+loop_id).text(0);
                $('#total_price_'+loop_id).val(0);
                $('.applynow_'+loop_id).val("");
                toastr.warning('Stock is not available...');
                return false;
            }

            if(input_value < 0){
                $('#total_price_'+loop_id).val("");
                $('.total_price_'+loop_id).text("");
                $('.applynow_'+loop_id).val("");
                toastr.error('Entered amount is wrong..')
                return false;
            }
        }

        $(".applynow").on('keyup', function(){
            serialMaintain();
        });

        function serialMaintain(){
            var i = 1;
            var subtotal = 0;
                $('.serial').each(function(key, element) {
                    $(element).html(i);
                    var total   = $(element).parents('tr').find('input[name="total_amounts[]"]').val();
                    subtotal    += +total;
                    i++;
                });
            $('.sub-total').html(subtotal);
            $('#total_amount_pay_amount').val(subtotal);
        };

        $('.accountnumberconfirm').click(function (){
        var answer = confirm("Please check you are posting from the correct bank account. If correct press 'ok' and if not, 'cancel'!");
            if (answer) {
            return true;
            }else{
            return false;
            }
        });



        </script>


    <script>
    function confirmInvestment(amount) {
        return confirm('Are you sure you want to invest ৳' + amount + '?');
    }
    </script>
@endpush
