@extends('member-panel.layouts.app')

@section('title', 'Notice Details')

@push('css')

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
@endpush

@section('content')

        <!-- main page content -->
        <div class="main-container container">

            <!-- Blog/News Details banner -->
            <div class="row">
                <div class="col-12 px-0">
                    <div class="card mb-4 overflow-hidden shadow-sm theme-bg text-white rounded-0">
                        <div class="overlay"></div>
                        <div class="coverimg h-100 w-100 position-absolute opacity-5">
                            <img src="{{ asset('storage/app/public/notification/'.$notice->image) }}" alt="">
                        </div>
                        <div class="card-body">
                            <div class="row mb-5">
                                <div class="col">
                                    <span class="tag">Notification</span>
                                </div>
                                <div class="col-auto">
                                    <!-- <button class="btn btn-danger text-white btn-44 rounded-circle shadow-sm">
                                        <i class="bi bi-share"></i>
                                    </button> -->
                                    <!-- <button class="btn btn-success text-white btn-44 rounded-circle shadow-sm">
                                        <i class="bi bi-bookmark"></i>
                                    </button> -->
                                </div>
                            </div>
                            <br>
                            <a href="#" class="h4 text-normal d-block text-white mb-2">{{ $notice->title }}</a>
                            <p class="text-muted">Published on: {{  date('h:i a d/m/Y', strtotime( $notice->created_at)) }}</p>
                            <div class="small d-flex">
                                <figure class="avatar avatar-36 rounded">
                                    <img src="https://cdn-icons-png.flaticon.com/512/4205/4205999.png" alt="">
                                </figure>
                                <p class="mx-2">Sunam Digital<br><span class="text-muted">Admin</span></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Blogs/News Content  -->
            <div class="row">
                <div class="col-12 col-md-10 col-lg-8 mx-auto">
                 

                    <figure class="overflow-hidden rounded-15 text-center">
                        <img src="{{ asset('storage/app/public/notification/'.$notice->image) }}" alt="" class="mw-100 mx-auto">
                    </figure>

                    <h5 class="mb-3">{{ $notice->title }}</h5>
                    <p class="text-muted">{{ $notice->description }}</p>

                    <div class="row">
                        <div class="col-6">
                            <figure class="overflow-hidden rounded-15 text-center">
                                <img src="assets/img/news6.png" alt="" class="w-100 mx-auto">
                            </figure>
                        </div>
                        <div class="col-6">
                            <div class="row">
                                <div class="col-12 mb-2">
                                    <figure class="overflow-hidden rounded-15 text-center">
                                        <img src="assets/img/news4.jpg" alt="" class="w-100 mx-auto">
                                    </figure>
                                </div>
                                <div class="col-12">
                                    <figure class="overflow-hidden rounded-15 text-center">
                                        <img src="assets/img/news3.jpg" alt="" class="w-100 mx-auto">
                                    </figure>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                   

                 
                   
                </div>
            </div>

       
         
            <div class="clearfix"></div>
        </div>
        <!-- main page content ends -->
@endsection


@push('js')
    
@endpush
