@extends('member-panel.layouts.app')

@section('title', 'All Notices ')

@push('css')

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
@endpush

@section('content')
<div class="col align-self-center text-center">
                    <h5>All Notifications</h5>
                </div>
        <!-- main page content -->
         <div class="main-container container pt-0">
            <!-- notification list -->
            <div class="row">
                <div class="col-12 px-0">
                    <div class="list-group list-group-flush bg-none">
                       @foreach($notice as $v)
                            <a href="{{ url('member/notice-details/'.$v->id) }}" class="list-group-item bg-white">
                                <div class="row">
                                    <div class="col-auto">
                                        <div class="avatar avatar-44 coverimg rounded-10">
                                            <img src="{{ asset('storage/app/public/notification/'.$v->image) }}" alt="">
                                        </div>
                                    </div>
                                    <div class="col align-self-center ps-0">
                                        <p class="mb-1"><b> {{ $v->title }} </b></p>
                                        <p class="size-12 text-muted">{{ $v->created_at->diffForHumans() }}</p>
                                    </div>
                                </div>
                            </a>
                       @endforeach
                
                     
                    

                    </div>
                </div>
            </div>
        </div>
        <!-- main page content ends -->
@endsection


@push('js')
    
@endpush
