@extends('member-panel.layouts.app')

@section('title', 'Member Panel')

@push('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
@endpush

@section('content')

   <!-- main page content -->
   <div class="main-container container card adminuiux-card shadow-sm mb-4">
   <form method="post" id="upload_form" enctype="multipart/form-data" >
            @csrf
            <!-- profile information -->
            <div class="row mb-3">
                <div class="col">
                    <h6>Create Acccount </h6>
                </div>
            </div>

            <div class="row h-100 mb-4">
                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating  mb-3">
                        <input type="text" class="form-control" required value="" placeholder="full_name" id="full_name" name="full_name">
                        <label for="full_name">Full Name</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <input type="email" class="form-control" required value="" placeholder="Email" id="email" name="email">
                        <label for="email">Email</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating mb-3">
                        <input type="text" class="form-control" required value="" placeholder="phone" id="phone" name="phone">
                        <label for="phone">Phone</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating  mb-3">
                        <input  oninput="validateInput(this);" type="text" class="form-control" required value="" placeholder="user id" id="user_id" name="user_id">
                        <label for="user_id">User ID</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating  mb-3">
                        <input type="text" class="form-control" required value="" placeholder="Sponsor ID" id="sponsor" name="sponsor">
                        <label for="sponsor">Sponsor ID</label>
                    </div>
                </div>

                <!-- <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating  mb-3">
                        <select class="form-control" required name="pack_id" id="pack_id">
                            <option value="">Select Package</option>
                            @foreach($package as $v)
                            <option  value="{{$v->id}}">{{$v->title}} => {{$v->amount}} SV</option>
                            @endforeach
                        </select>
                    </div>
                </div> -->

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating  mb-3">
                        <input type="text" class="form-control" required value="{{ $placement_id }}" @if(!empty($placement_id)) readonly @endif placeholder="placement_id" id="placement_id" name="placement_id">
                        <label for="placement_id">Placement ID</label>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating  mb-3">
                        <select class="form-control" name="placement" required id="placement">
                            <option value="">Select Team</option>
                            <option  @if($placement == 'L') selected @endif value="L"> Team A</option>
                            <option  @if($placement == 'R') selected @endif value="R"> Team B</option>
                        </select>
                    </div>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-group form-floating  mb-3">
                        <input type="text" class="form-control" required value="" placeholder="NID" id="nid" name="nid">
                        <label for="nid">NID</label>
                    </div>
                </div>
            </div>


            <!-- change password -->
            <div class="row mb-3">
                <div class="col">
                    <h6>Password</h6>
                </div>
            </div>
            <div class="row h-100 mb-4">
                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-floating  mb-3">
                        <input type="password" class="form-control" required value="" placeholder="Password" name="password" id="password">
                        <label for="password">Password</label>
                    </div>
                </div>
                <div class="col-12 col-md-6 col-lg-4">
                    <div class="form-floating ">
                        <input type="password" class="form-control" required placeholder="Confirm Password" name="confirmpassword" id="confirmpassword">
                        <label for="confirmpassword">Confirm Password</label>
                        <span id="msg" style="color: red; font-size:10px;"/span>
                    </div>
                </div>
            </div>

            <div class="row h-100 ">
                <div class="col-12 mb-4">
                    <button type="submit" class="btn btn-primary btn-sm w-100 sned">  <i id="icon_class" class="" style="font-size: 25px;"></i> Create Account</button>
                </div>
            </div>

            </form>

    </div>
    <!-- main page content ends -->

    <style>
    .loading {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      -ms-transform: translate(-50%, -50%);
      z-index:1000000000;
    }
   .myDiv {
      height: 150px;
      width: 150px;
      display: inline-block;
      background-color: orange;
      margin-bottom: 25px;
    }

    /* The block of code below tells the browsers what to do on a screen that has a width of 320px or less */

    @media screen and (max-width: 320px) {

      .myDiv {
      width: 90%;
      display: block; /* Stops it from floating */
      margin: auto; /* Ensures that it is centered */
      margin-bottom: 25px; /* Space between the stacked elements */

      }

    }
  </style>
@endsection


@push('js')

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
        var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
         $(document).ready(function () {
            $('#user_id').val('');
        });

       $('#check_id').on('click',function(){
            if ( !this.checked){
                $('#exist_search').hide();
            }else{
                $('#exist_search').show();
            }
       });

       $('#account_type').on('change',function(){
            let pack = $(this).val();
            if ( pack ==  1 ){
                $('#package').val(1600);
            }else  if ( pack ==  2 ){
                $('#package').val(25600);
            } else  if ( pack ==  3 ){
                $('#package').val(160000);
            }
       });


         $(document).ready(function () {
            $('#sponsor').on('blur', function () {
                event.preventDefault();
                var sponsor        = $('#sponsor').val();
                var _token          = $('#_token').val();
                if(sponsor == ""){
                  return false;
                }
                $(".sned").prop('disabled', true);
                $("#loader").css('display', 'block');
                $.ajax({
                    url: "{{ url('member/sponser_search') }}",
                    type: 'post',
                    dataType: 'json',
                    data: { sponsor: sponsor, _token: CSRF_TOKEN,},
                    success: function (data) {
                        if(data == 1){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled',false);
                               $(".messege2").text('Your sponsor is matched');
                               $(".messege2").show().delay(5000).fadeOut();
                               /*Swal.fire(
                                'Congratulations!',
                                'We have found the sponsor',
                                'succes'
                               )    */
                        } else if(data == 2){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', true);
                               $(".messege2").text('Your sponsor is matched');
                               Swal.fire(
                                'Sorry!',
                                'This sponsor is not exist',
                                'error'
                               )
                        }
                    }
                })
            });
         });


         $(document).ready(function () {
            $('#user_id').on('blur', function () {
                event.preventDefault();

                var user_id        = $('#user_id').val();
                var _token          = $('#_token').val();
                if(user_id == ""){
                  return false;
                }
                $("#loader").css('display', 'block');
                $(".sned").prop('disabled', true);
                $.ajax({
                    url: "{{ url('member/user_id_search') }}",
                    type: 'post',
                    dataType: 'json',
                    data: { user_id: user_id, _token: CSRF_TOKEN,},
                    success: function (data) {
                        if(data == 1){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled',false);
                               $(".messege").text('This user name is available');
                               $(".messege").show().delay(5000).fadeOut();

                        } else if(data == 2){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', true);
                               $(".messege").text('');
                               Swal.fire(
                                'Sorry!',
                                'This user id is not available',
                                'error'
                               )
                        }
                    }
                })
            });
         });


         $(document).ready(function () {
            $('#placement').on('change', function () {
                event.preventDefault();
                var placement_id        = $('#placement_id').val();
                var placement           = $('#placement option:selected').val();
                var _token              = $('#_token').val();
                $("#loader").css('display', 'block');
                $(".sned").prop('disabled', true);
                if(placement_id == ''){
                     $("#loader").css('display', 'none');
                      return false;
                }
                if(placement == ''){
                     $("#loader").css('display', 'none');
                      return false;
                }
                $.ajax({
                    url: "{{ url('member/placement_search') }}",
                    type: 'post',
                    dataType: 'json',
                    data: { placement_id: placement_id, placement: placement , _token: CSRF_TOKEN,},
                    success: function (data) {
                        if(data == 1){
                            $("#loader").css('display', 'none');
                               $(".sned").prop('disabled',false);
                               Swal.fire(
                                'Success!',
                                'Available position',
                                'succes'
                               )

                        } else if(data == 2){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', true);
                               Swal.fire(
                                'Sorry!',
                                'Sorry unavailable position',
                                'error'
                               )

                        } else if(data == 3){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);


                        }  else if(data == 4){
                             $(".sned").prop('disabled',true);
                             $("#loader").css('display', 'none');
                               Swal.fire(
                                'Sorry!',
                                'Placement id is not exist',
                                'error'
                              )
                        } else if(data == 10){
                             $(".sned").prop('disabled',true);
                             $("#loader").css('display', 'none');
                               Swal.fire(
                                'Sorry!',
                                'Placement id is not exist',
                                'error'
                              )
                        } else if(data == 0){
                              $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               Swal.fire(
                                'Sorry!',
                                'Placement id is not exist',
                                'error'
                              )

                        }
                    }
                })
            });
         });

         $(document).ready(function () {
            $('#placement_id').on('blur', function () {
                event.preventDefault();
                var placement_id        = $('#placement_id').val();
                var placement           = $('#placement option:selected').val();
                var _token              = $('#_token').val();
                $("#loader").css('display', 'block');
                if(placement == ''){
                     $("#loader").css('display', 'none');

                      return false;
                }

                if(placement_id == ''){
                     $("#loader").css('display', 'none');
                     Swal.fire(
                      'Empty field!',
                      'Please select placement id!',
                      'error'
                    )
                      return false;
                }
                $.ajax({
                    url: "{{ url('member/placement_search') }}",
                    type: 'post',
                    dataType: 'json',
                    data: { placement_id: placement_id, placement: placement , _token: CSRF_TOKEN,},
                    success: function (data) {
                        if(data == 1){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled',false);
                               Swal.fire(
                                'Succes!',
                                'Available position',
                                'succes'
                               )
                        } else if(data == 2){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', true);
                               Swal.fire(
                                'Sorry!',
                                'Sorry unavailable position',
                                'error'
                               )

                        } else if(data == 3){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               Swal.fire(
                                'Succes!',
                                'Both position is available',
                                'succes'
                               )

                        }  else if(data == 4){
                             $(".sned").prop('disabled',true);
                             $("#loader").css('display', 'none');
                               Swal.fire(
                                'Sorry!',
                                'This placement id is not exist',
                                'error'
                              )
                        } else if(data == 10){
                             $(".sned").prop('disabled',true);
                             $("#loader").css('display', 'none');
                               Swal.fire(
                                'Sorry!',
                                'This placement id is not exist',
                                'error'
                              )
                        }  else if(data == 0){
                              $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               Swal.fire(
                                'Succes!',
                                'Both position is available',
                                'succes'
                               )
                        }
                    }
                })
            });
         });



        $("#password, #confirmpassword").on('keyup', function(){
            var password = $("#password").val();
            var confirmPassword = $("#confirmpassword").val();
            if(confirmPassword == ""){
                      $("#msg").text("");
                } else {
                    if(password == confirmPassword){
                        $("#msg").text("");
                        $(".sned").removeAttr('disabled', 'disabled');
                    } else {
                        $("#msg").text("Password and Confirm Password Do not match!");
                        $(".sned").attr('disabled', 'disabled');
                        return false;
                    }
              }
        });

        $(document).ready(function () {
            $('#upload_form').on('submit', function () {
                event.preventDefault();
                $("#loader").css('display', 'block');
                $(".sned").prop('disabled', true);
                $(this).find('i').toggleClass('fa fa-spinner fa-spin');
                $.ajax({
                    url: "{{ url('member/member_account_create') }}",
                    method: "POST",
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: new FormData(this),
                    success: function (data) {
                        $('#icon_class').removeClass('fa fa-spinner fa-spin');
                        if(data == 1){
                             $("#loader").css('display', 'none');
                            Swal.fire(
                                'Success!',
                                'User has been created successfully!',
                                'success'
                            )
                            // window.location.href = "{{ url('member/refferd-member')}}";
                             window.location.reload();

                        }else if(data == 2){
                               $("#loader").css('display', 'none');
                               $(this).find('i').toggleClass('');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'This user id is taken please try another',
                                'error'
                           )
                        } else if(data == 3){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'This sponsor id is wrong please try another',
                                'error'
                           )
                        }else if(data == 4){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'You do not have sufficiant balance',
                                'error'
                           )
                        } else if(data == 5){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'This position is not empty',
                                'error'
                           )
                        } else if(data == 6){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'The position is not empty',
                                'error'
                           )
                        } else if(data == 7){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Placement is wrong',
                                'error'
                           )
                        } else if(data == 10){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Placement id is wrong',
                                'error'
                           )
                        }else if(data == 20){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Password Miss match',
                                'error'
                           )
                        } else if(data == 21){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Minimum 6 digit password',
                                'error'
                           )
                        } else if(data == 0){
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Somthing went wrong',
                                'error'
                           )
                        } else {
                               $("#loader").css('display', 'none');
                               $(".sned").prop('disabled', false);
                               jQuery('#icon_class').removeClass('fa fa-spinner fa-spin');
                               Swal.fire(
                                'Error!',
                                'Somthing went wrong',
                                'error'
                           )
                        }
                     }
                })
            });
         });

         function validateInput(inputElement) {
          inputElement.value = inputElement.value.replace(/[^A-Za-z0-9]/g, '');
        }

    </script>

@endpush
