@extends('member-panel.layouts.app')

@section('title', 'Support Ticket')

@push('css')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.0/font/bootstrap-icons.css">
<style>
    :root {
        --primary: #4f46e5;
        --primary-hover: #4338ca;
        --success: #10b981;
        --danger: #ef4444;
        --text: #1f2937;
        --text-muted: #6b7280;
        --background: #f9fafb;
        --card-bg: #ffffff;
    }

    body {
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        background: var(--background);
        color: var(--text);
    }

    .ticket-container {
        padding: 2rem 1rem;
        min-height: 100vh;
    }

    .ticket-card {
        max-width: 1200px;
        margin: 0 auto;
        background: var(--card-bg);
        border-radius: 16px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        overflow: hidden;
    }

    .card-header {
        padding: 1.5rem;
        border-bottom: 1px solid #e5e7eb;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .card-header h2 {
        font-size: 1.5rem;
        font-weight: 700;
        margin: 0;
    }

    .card-body {
        padding: 2rem;
    }

    .table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 1.5rem;
    }

    .table th, .table td {
        padding: 1rem;
        text-align: left;
        border-bottom: 1px solid #e5e7eb;
    }

    .table th {
        font-weight: 600;
        background: #f3f4f6;
        text-transform: uppercase;
        font-size: 0.875rem;
        color: var(--text-muted);
    }

    .table td {
        vertical-align: middle;
    }

    .action-btn {
        padding: 0.5rem;
        border-radius: 8px;
        margin: 0 0.25rem;
        transition: all 0.2s ease;
    }

    .btn--primary {
        background: var(--primary);
        color: #ffffff;
    }

    .btn--primary:hover {
        background: var(--primary-hover);
        transform: translateY(-2px);
    }

    .btn--danger {
        background: var(--danger);
        color: #ffffff;
    }

    .btn--danger:hover {
        background: #dc2626;
        transform: translateY(-2px);
    }

    .modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        z-index: 1000;
        align-items: center;
        justify-content: center;
    }

    .modal-content {
        background: var(--card-bg);
        border-radius: 16px;
        max-width: 600px;
        width: 90%;
        overflow: hidden;
        animation: fadeInUp 0.3s ease-out;
    }

    .modal-header {
        padding: 1rem 1.5rem;
        border-bottom: 1px solid #e5e7eb;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .modal-header h5 {
        font-size: 1.25rem;
        font-weight: 600;
        margin: 0;
    }

    .modal-close {
        cursor: pointer;
        font-size: 1.5rem;
        color: var(--text-muted);
    }

    .modal-close:hover {
        color: var(--text);
    }

    .modal-body {
        padding: 1.5rem;
    }

    .form-group {
        margin-bottom: 1.5rem;
    }

    .form-label {
        font-weight: 600;
        font-size: 0.875rem;
        margin-bottom: 0.5rem;
        display: block;
    }

    .form-control {
        border: 1px solid #d1d5db;
        border-radius: 8px;
        padding: 0.75rem 1rem;
        font-size: 1rem;
        width: 100%;
        transition: all 0.2s ease;
    }

    .form-control:focus {
        outline: none;
        border-color: var(--primary);
        box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.1);
    }

    .modal-footer {
        padding: 1rem 1.5rem;
        border-top: 1px solid #e5e7eb;
        display: flex;
        justify-content: flex-end;
        gap: 0.5rem;
    }

    .btn {
        padding: 0.75rem 1.5rem;
        border-radius: 8px;
        font-weight: 600;
        transition: all 0.2s ease;
    }

    .btn-primary {
        background: var(--primary);
        color: #ffffff;
        border: none;
    }

    .btn-primary:hover {
        background: var(--primary-hover);
        transform: translateY(-2px);
    }

    .btn-secondary {
        background: #6b7280;
        color: #ffffff;
        border: none;
    }

    .btn-secondary:hover {
        background: #4b5563;
        transform: translateY(-2px);
    }

    .btn-primary:disabled, .btn-secondary:disabled {
        background: #d1d5db;
        cursor: not-allowed;
        transform: none;
    }

    @keyframes fadeInUp {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    @media (max-width: 768px) {
        .ticket-container {
            padding: 1rem;
        }

        .card-body, .card-header {
            padding: 1rem;
        }

        .table th, .table td {
            padding: 0.75rem;
            font-size: 0.875rem;
        }

        .action-btn {
            padding: 0.4rem;
        }
    }

    @media (max-width: 576px) {
        .table {
            display: block;
            overflow-x: auto;
        }

        .modal-content {
            width: 95%;
        }
    }
</style>
@endpush

@section('content')
<div class="ticket-container ">
    <div class="ticket-card  card adminuiux-card shadow-sm">
        <div class="card-header">
            <h2><i class="bi bi-headset me-2"></i>Support Tickets</h2>
            <button type="button" class="btn btn-primary btn-sm" onclick="document.getElementById('id01').style.display='block'">
                {{\App\CPU\translate('add_new_ticket')}}
            </button>
        </div>

        <div class="card-body">
            @php($allTickets = App\Model\SupportTicket::where('customer_id', auth('customer')->id())->get())
            <table class="table">
                <thead>
                    <tr>
                        <th>{{ \App\CPU\translate('submition_date') }}</th>
                        <th>{{ \App\CPU\translate('Type') }}</th>
                        <th>{{ \App\CPU\translate('Status') }}</th>
                        <th>{{ \App\CPU\translate('Topic') }}</th>
                        <th class="text-center">{{ \App\CPU\translate('Action') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($allTickets as $ticket)
                        <tr>
                            <td>{{ date('h:i a d/m/Y', strtotime($ticket['created_at'])) }}</td>
                            <td>{{ \App\CPU\translate($ticket['type']) }}</td>
                            <td>{{ \App\CPU\translate($ticket['status']) }}</td>
                            <td>{{ $ticket['subject'] }}</td>
                            <td class="text-center">
                                <div class="btn--container">
                                    @if($ticket['status'] == 'open')
                                        <a class="action-btn btn--primary" href="{{ route('member.support-ticket.index', $ticket['id']) }}" title="View Ticket">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                    @endif
                                    <a class="action-btn btn--danger" href="{{ route('member.support-ticket.delete', ['id' => $ticket->id]) }}" onclick="return confirm('Are you sure you want to delete this ticket?')" title="Delete Ticket">
                                        <i class="bi bi-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<div id="id01" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h5>{{ \App\CPU\translate('submit_new_ticket') }}</h5>
            <span class="modal-close" onclick="document.getElementById('id01').style.display='none'">&times;</span>
        </div>
        <div class="modal-body">
            <form method="post" action="{{ route('member.ticket-submit') }}" id="open-ticket">
                @csrf
                <div class="form-group">
                    <label class="form-label" for="ticket_subject">{{ \App\CPU\translate('Subject') }}</label>
                    <input type="text" class="form-control" id="ticket_subject" name="ticket_subject" required>
                    @error('ticket_subject')
                        <div class="text-danger text-sm mt-1">{{ $message }}</div>
                    @enderror
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label class="form-label" for="ticket_type">{{ \App\CPU\translate('Type') }}</label>
                        <select class="form-control" id="ticket_type" name="ticket_type" required>
                            <option value="Website problem">{{ \App\CPU\translate('Website problem') }}</option>
                            <option value="Complaint">{{ \App\CPU\translate('Complaint') }}</option>
                            <option value="Info inquiry">{{ \App\CPU\translate('Info inquiry') }}</option>
                        </select>
                        @error('ticket_type')
                            <div class="text-danger text-sm mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-6">
                        <label class="form-label" for="ticket_priority">{{ \App\CPU\translate('Priority') }}</label>
                        <select class="form-control" id="ticket_priority" name="ticket_priority" required>
                            <option value="" disabled selected>{{ \App\CPU\translate('choose_priority') }}</option>
                            <option value="Urgent">{{ \App\CPU\translate('Urgent') }}</option>
                            <option value="High">{{ \App\CPU\translate('High') }}</option>
                            <option value="Medium">{{ \App\CPU\translate('Medium') }}</option>
                            <option value="Low">{{ \App\CPU\translate('Low') }}</option>
                        </select>
                        @error('ticket_priority')
                            <div class="text-danger text-sm mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label" for="ticket_description">{{ \App\CPU\translate('describe_your_issue') }}</label>
                    <textarea class="form-control" rows="6" id="ticket_description" name="ticket_description" required></textarea>
                    @error('ticket_description')
                        <div class="text-danger text-sm mt-1">{{ $message }}</div>
                    @enderror
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="document.getElementById('id01').style.display='none'">{{ \App\CPU\translate('close') }}</button>
                    <button type="submit" class="btn btn-primary">{{ \App\CPU\translate('submit_a_ticket') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
$(document).ready(function() {
    $('#open-ticket').on('submit', function(e) {
        const subject = $('#ticket_subject').val().trim();
        const type = $('#ticket_type').val();
        const priority = $('#ticket_priority').val();
        const description = $('#ticket_description').val().trim();

        if (!subject || !type || !priority || !description) {
            e.preventDefault();
            alert('Please fill in all required fields.');
            return false;
        }
    });

    $('.action-btn.btn--danger').on('click', function(e) {
        if (!confirm('Are you sure you want to delete this ticket?')) {
            e.preventDefault();
            return false;
        }
    });
});
</script>
@endpush
