@extends('member-panel.layouts.app')

@section('title', 'Support Ticket Details')

@push('css')
<link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
@endpush

@section('content')

   <!-- main page content -->
   <div class="main-container container card adminuiux-card shadow-sm mb-4">
      <div class="row mb-4">
            <div class="col-12 px-2">
                <div class="card __card mb-4">
                    <div class="table-responsive">
                        <table class="table  mb-0">
                            <thead >
                                <tr>
                                    <th>{{\App\CPU\translate('Date Submitted')}}</th>
                                    <th>{{\App\CPU\translate('Last Updated')}}</th>
                                    <th>{{\App\CPU\translate('Type')}}</th>
                                    <th>{{\App\CPU\translate('Topic')}}</th>
                                    <th>{{\App\CPU\translate('Priority')}}</th>
                                    <th>{{\App\CPU\translate('Status')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        {{Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$ticket['created_at'])->format('Y-m-d')}}
                                    </td>
                                    <td>
                                        {{Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$ticket['updated_at'])->format('Y-m-d')}}
                                    </td>
                                    <td>
                                        {{$ticket['type']}}
                                    </td>
                                    <td>
                                        {{$ticket['subject']}}
                                    </td>
                                    <td>
                                        {{$ticket['priority']}}
                                    </td>
                                    <td>
                                        @if($ticket['status']=='open')
                                            <span class="badge btn btn-sm btn-secondary">{{$ticket['status']}}</span>
                                        @else
                                            <span class="badge btn btn-sm btn-secondary">{{$ticket['status']}}</span>
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Comment-->

        <!-- main page content -->
        <div class="main-container container pt-0">
            <!-- chat user list -->
            <div class="container chat-list ">
                         <div class="row no-margin right-chat">
                            <div class="col-12">
                                <div class="chat-block">
                                    <div class="row">
                                        <div class="col">
                                             {{$ticket['description']}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 text-end">
                                <p class="text-muted small time"  style="font-size: 10px;" ><i class="bi bi-check-all text-primary"></i>
                                {{Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$ticket['created_at'])->format('g:i a j M Y')}}
                                </p>
                            </div>
                        </div>
               @foreach($ticket->conversations as $conversation)

                    @if($conversation['customer_message'] == null)
                        <div class="row no-margin left-chat">
                            <div class="col-12">
                                <div class="chat-block">
                                    <div class="row">
                                        <div class="col">
                                          {{$conversation['admin_message']}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <p class="text-muted small time" style="font-size: 10px;" ><i class="bi bi-check-all text-primary"></i>
                              Admin: {{Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$conversation['created_at'])->format('g:i a j M Y')}}
                                </p>
                            </div>
                        </div>
                    @endif

                    @if($conversation['admin_message'] == null )
                        <div class="row no-margin right-chat">
                            <div class="col-12">
                                <div class="chat-block">
                                    <div class="row">
                                        <div class="col">
                                             {{$conversation['customer_message']}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 text-end">
                                <p class="text-muted small time" style="font-size: 10px;" ><i class="bi bi-check-all text-primary"></i>
                                {{Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$conversation['created_at'])->format('g:i a j M Y')}}
                                </p>
                            </div>
                        </div>
                    @endif
                @endforeach

                    <!-- chat message post -->
                    <form class="needs-validation" href="{{route('member.support-ticket.comment',[$ticket['id']])}}" method="post" novalidate>
                        @csrf
                    <div class=" chat-post py-3 card bg-theme-accent-r-gradient" style="z-index: 9999999;">
                        <div class="row mx-0">
                            <div class="col-auto">
                            <a href="{{route('member.support-ticket.close',[$ticket['id']])}}" class="btn btn-sm btn-secondary text-white">{{\App\CPU\translate('close')}}</a>
                                <!-- <button class="btn btn-sm btn-primary rounded-15" type="button" data-bs-toggle="modal" data-bs-target="#attachefiles">
                                    <i class="bi bi-plus"></i>
                                </button> -->
                            </div>
                            <div class="col ps-0">
                                <div class="input-group">
                                    <input type="text" name="comment" class="form-control" placeholder="Write your message">
                                    <button class="btn btn-sm btn-outline-primary" type="submit"><i class="bi bi-cursor"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- chat message post page -->
                    </form>
                <div class="clearfix"></div>
            </div>
           <div class="clearfix"></div>
         </div>
            <!-- main page content ends -->


      </div>
   <!-- main page content ends -->





@endsection


@push('js')
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
@endpush
