@extends('member-panel.layouts.app')

@section('title', 'Withdraw Report')

@push('css')

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
@endpush

@section('content')

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-2">
               <div class="col align-self-center text-left">
                    <h5>Withdraw Report</h5>
                </div>

                <form id="search-form" action="{{ route('member.withdraw-list') }}" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-sm btn-primary">Search</button>
                              </div>  <div class="col">
                                    <a href="{{ route('member.withdraw') }}" class="btn btn-sm btn-success"><i class="fa fa-plus"></i> Withdraw</a>
                              </div>
                        </div>
                </form>


                <table class="table  table-responsive table-responsive-sm table-responsive-md">
                        <thead>
                        <tr>
                            <th>SL</th>
                            <th>Time & Date</th>
                            <th>Payment Method</th>
                            <th>Amount</th>
                            <th>Withdrawal Amount</th>
                            <th>Account Number</th>
                            <th>Comment</th>
                            <th>Status</th>
                        </tr>
                        </thead>
                        <tbody>
                            @php
                                $total = 0;
                            @endphp
                            @foreach($report as $key=>$banner)
                            @php
                            $user  = DB::table('users')->where('id', $banner->user_id)->first();
                            $total = $total + $banner->amount;
                            @endphp
                                <tr>
                                    <th scope="row">{{$key+1}}</th>
                                    <td>{{  date('h:i:s a d M Y ', strtotime($banner->created_at)) }}</td>
                                    <td>{{$banner->method_name}}</td>
                                    <td>{{$banner->withouth_charge}}</td>
                                    <td>{{$banner->amount}}</td>
                                    <td>{{$banner->account_no}}</td>
                                    <td>{{$banner->transaction_note}}</td>
                                    @if($banner->approved == 0)
                                          <td><button class="btn btn-danger btn-sm">Pending</button></td>
                                    @elseif($banner->approved== 1)
                                          <td><button class="btn btn-success btn-sm">Paid</button></td>
                                    @endif
                                </tr>
                            @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td>  </td>
                                    <td>  </td>
                                    <td>  </td>
                                    <td>  Total</td>
                                    <td>{{ $web_config['currency_sign']->value }} {{ number_format($total,2) }}</td>

                                    <td>  </td>
                                    <td>  </td>
                                    <td>  </td>

                                </tr>
                            </tfoot>
                </table>

                         {{ $report->appends(request()->input())->links() }}
               </div>
            </div>

      </div>

   <!-- main page content ends -->
@endsection


@push('js')
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
@endpush
