<?php $__env->startSection('title', \App\CPU\translate('Login')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <style>
        .password-toggle-btn .custom-control-input:checked ~ .password-toggle-indicator {
            color: <?php echo e($web_config['primary_color']); ?>;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container py-4 py-lg-5 my-4"
         style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
        <div class="mx-auto __max-w-620">
            <div class="card border-0 box-shadow">
                <div class="card-body">
                    <h2 class="h4 mb-1"><?php echo e(\App\CPU\translate('sign_in')); ?></h2>
                    <form class="needs-validation mt-2" autocomplete="off" action="<?php echo e(route('customer.auth.login')); ?>"
                            method="post" id="form-id">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="si-email"><?php echo e(\App\CPU\translate('email_address')); ?>

                                / <?php echo e(\App\CPU\translate('USER ID')); ?> / <?php echo e(\App\CPU\translate('CID')); ?></label>
                            <input class="form-control" type="text" name="user_id" id="si-email"
                                    style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                                    value="<?php echo e(old('user_id')); ?>"
                                    placeholder="<?php echo e(\App\CPU\translate('Enter_email_address_or_user_id_or_CID')); ?>"
                                    required>
                            <div
                                class="invalid-feedback"><?php echo e(\App\CPU\translate('please_provide_valid_email_or_user_id')); ?>

                                .
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="si-password"><?php echo e(\App\CPU\translate('password')); ?></label>
                            <div class="password-toggle">
                                <input class="form-control" name="password" type="password" id="si-password"
                                        style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                                        required>
                                <label class="password-toggle-btn">
                                    <input class="custom-control-input" type="checkbox"><i
                                        class="czi-eye password-toggle-indicator"></i><span
                                        class="sr-only"><?php echo e(\App\CPU\translate('Show')); ?> <?php echo e(\App\CPU\translate('password')); ?> </span>
                                </label>
                            </div>
                        </div>
                        <div class="form-group d-flex flex-wrap justify-content-between">

                            <div class="form-group">
                                <input type="checkbox"
                                        class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-1' : 'mr-1'); ?>"
                                        name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>

                                <label class="" for="remember"><?php echo e(\App\CPU\translate('remember_me')); ?></label>
                            </div>
                            <a class="font-size-sm" href="<?php echo e(route('customer.auth.recover-password')); ?>">
                                <?php echo e(\App\CPU\translate('forgot_password')); ?>?
                            </a>
                        </div>
                        
                        <?php ($recaptcha = \App\CPU\Helpers::get_business_settings('recaptcha')); ?>
                        <?php if(isset($recaptcha) && $recaptcha['status'] == 1): ?>
                            <div id="recaptcha_element" class="w-100" data-type="image"></div>
                            <br/>
                        <?php else: ?>
                            <div class="row py-2">
                                <div class="col-6 pr-2">
                                    <input type="text" class="form-control border __h-40" name="default_recaptcha_id_customer_login" value=""
                                        placeholder="<?php echo e(\App\CPU\translate('Enter captcha value')); ?>" autocomplete="off">
                                </div>
                                <div class="col-6 input-icons mb-2 w-100 rounded bg-white">
                                    <a onclick="re_captcha();" class="d-flex align-items-center align-items-center">
                                        <img src="<?php echo e(URL('/customer/auth/code/captcha/1?captcha_session_id=default_recaptcha_id_customer_login')); ?>" class="input-field rounded __h-40" id="customer_login_recaptcha_id">
                                        <i class="tio-refresh icon cursor-pointer p-2"></i>
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>
                        <button class="btn btn--primary btn-block btn-shadow"
                                type="submit"><?php echo e(\App\CPU\translate('sign_in')); ?></button>
                    </form>
                </div>


<!--
                    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
                    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script> -->



                    <div class="card shadow-sm mb-4">
                        <div class="card-body">
                            <h2 class="h4 mb-4 text-primary fw-bold">🏆 Top 10 Achievers</h2>

                            <div id="achieverCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="3000">
                                <div class="carousel-inner">
                                    <?php $__currentLoopData = $latestRanks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $achiever): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="carousel-item <?php if($index === 0): ?> active <?php endif; ?>">
                                            <div class="d-flex align-items-center gap-3">
                                                <h4 class="text-primary mb-0">#<?php echo e($index + 1); ?></h4>
                                                <img src="https://cdn-icons-png.flaticon.com/512/2784/2784439.png" class="rounded-circle" width="60" height="60" alt="User">
                                                <div>
                                                    <h6 class="mb-1 fw-bold"><?php echo e(DB::table('users')->find($achiever->user)->f_name ?? 'Unknown'); ?></h6>
                                                    <small class="text-muted"><?php echo e(rank_name($achiever->rank)); ?>  </small>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>


                            </div>
                        </div>
                    </div>



                    


                <!--<div class="card-footer">-->
                <!--    <div class="row">-->
                <!--        <div class="col-12 d-flex flex-wrap justify-content-around justify-content-md-between align-items-center __gap-15" style="direction: <?php echo e(Session::get('direction')); ?>">-->
                <!--            <div class="<?php echo e(Session::get('direction') === "rtl" ? '' : 'ml-2'); ?>">-->
                <!--                <h6 class="m-0"><?php echo e(\App\CPU\translate('no_account_Sign_up_now')); ?></h6>-->
                <!--            </div>-->
                <!--            <div class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-2' : ''); ?>">-->
                <!--                <a class="btn btn-outline-primary"-->
                <!--                    href="<?php echo e(route('customer.auth.sign-up')); ?>">-->
                <!--                    <i class="fa fa-user-circle"></i> <?php echo e(\App\CPU\translate('sign_up')); ?>-->
                <!--                </a>-->
                <!--            </div>-->
                <!--        </div>-->
                <!--        <?php $__currentLoopData = \App\CPU\Helpers::get_business_settings('social_login'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socialLoginService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--            <?php if(isset($socialLoginService) && $socialLoginService['status']==true): ?>-->
                <!--                <div class="col-sm-6 text-center mt-3">-->
                <!--                    <a class="btn btn-outline-primary w-100" href="<?php echo e(route('customer.auth.service-login', $socialLoginService['login_medium'])); ?>">-->
                <!--                        <i class="czi-<?php echo e($socialLoginService['login_medium']); ?> mr-2 ml-n1"></i><?php echo e(\App\CPU\translate('sign_in_with_'.$socialLoginService['login_medium'])); ?>-->
                <!--                    </a>-->
                <!--                </div>-->
                <!--            <?php endif; ?>-->
                <!--        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--    </div>-->
                <!--</div>-->


            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

    
    <?php if(isset($recaptcha) && $recaptcha['status'] == 1): ?>
        <script type="text/javascript">
            var onloadCallback = function () {
                grecaptcha.render('recaptcha_element', {
                    'sitekey': '<?php echo e(\App\CPU\Helpers::get_business_settings('recaptcha')['site_key']); ?>'
                });
            };
        </script>
        <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit" async
                defer></script>
        <script>
            $("#form-id").on('submit', function (e) {
                var response = grecaptcha.getResponse();

                if (response.length === 0) {
                    e.preventDefault();
                    toastr.error("<?php echo e(\App\CPU\translate('Please check the recaptcha')); ?>");
                }
            });
        </script>
    <?php else: ?>
        <script type="text/javascript">
            function re_captcha() {
                $url = "<?php echo e(URL('/customer/auth/code/captcha')); ?>";
                $url = $url + "/" + Math.random()+'?captcha_session_id=default_recaptcha_id_customer_login';
                document.getElementById('customer_login_recaptcha_id').src = $url;
                console.log('url: '+ $url);
            }
        </script>
    <?php endif; ?>
    
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\walmart_express\resources\themes\default/customer-view/auth/login.blade.php ENDPATH**/ ?>