<?php $__env->startSection('title', \App\CPU\translate('Customer List')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
          .password-input {
              padding: 0px;
            border: none;
            margin-bottom: 0px;
            width: 100px;
            }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <!-- Page Title -->
        <div class="mb-4">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/customer.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('Customer_list')); ?>

                <span class="badge badge-soft-dark radius-50"><?php echo e(\App\User::count()); ?></span>
            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Card -->
        <div class="card">
            <!-- Header -->
            <div class="px-3 py-4">
                <div class="row gy-2 align-items-center">
                    <div class="col-sm-8 col-md-6 col-lg-4">
                        <!-- Search -->
                        <form action="<?php echo e(url()->current()); ?>" method="GET">
                            <div class="input-group input-group-merge input-group-custom">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        <i class="tio-search"></i>
                                    </div>
                                </div>
                                <input id="datatableSearch_" type="search" name="search" class="form-control"
                                       placeholder="<?php echo e(\App\CPU\translate('Search by Name or Email or Phone')); ?>"
                                       aria-label="Search orders" value="<?php echo e($search); ?>">
                                <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                            </div>
                        </form>
                        <!-- End Search -->
                    </div>
                    <div class="col-sm-4 col-md-6 col-lg-8 mb-2 mb-sm-0">
                        <div class="d-flex justify-content-sm-end">
                            <button type="button" class="btn btn-outline--primary" data-toggle="dropdown">
                                <i class="tio-download-to"></i>
                                <?php echo e(\App\CPU\translate('export')); ?>

                                <i class="tio-chevron-down"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.customer.export')); ?>"><?php echo e(\App\CPU\translate('excel')); ?></a></li>
                                <div class="dropdown-divider"></div>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- End Row -->
            </div>
            <!-- End Header -->

            <!-- Table -->
            <div class="table-responsive datatable-custom">
                <table
                    style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                    class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                    <thead class="thead-light thead-50 text-capitalize">
                    <tr>
                        <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                        <th><?php echo e(\App\CPU\translate('id')); ?></th>
                        <th><?php echo e(\App\CPU\translate('customer_name')); ?></th>
                        <th><?php echo e(\App\CPU\translate('user id')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Sponsor')); ?></th>

                        <th><?php echo e(\App\CPU\translate('Income Balance')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Purchase Balance')); ?></th>
                        <th><?php echo e(\App\CPU\translate('SV Wallet')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Account Type')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Dealer Type')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Left Count')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Right Count')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Left Carry')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Right Carry')); ?></th>

                        <th><?php echo e(\App\CPU\translate('Login Password')); ?></th>
                        <th><?php echo e(\App\CPU\translate('contact_info')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Total')); ?> <?php echo e(\App\CPU\translate('Order')); ?> </th>
                        <th><?php echo e(\App\CPU\translate('block')); ?> / <?php echo e(\App\CPU\translate('unblock')); ?></th>
                        <th class="text-center"><?php echo e(\App\CPU\translate('Action')); ?></th>
                    </tr>
                    </thead>

                    <tbody>
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <?php echo e($customers->firstItem()+$key); ?>

                            </td>
                              <td><?php echo e($customer->id); ?></td>
                            <td>
                                <a href="<?php echo e(route('admin.customer.view',[$customer['id']])); ?>"
                                   class="title-color hover-c1 d-flex align-items-center gap-10">
                                    <img src="<?php echo e(asset('storage/app/public/profile')); ?>/<?php echo e($customer->image); ?>"
                                         onerror="this.src='<?php echo e(asset('public/assets/back-end/img/160x160/img1.jpg')); ?>'"
                                         class="avatar rounded-circle" alt="" width="40">
                                    <?php echo e(\Illuminate\Support\Str::limit($customer['f_name']." ".$customer['l_name'],20)); ?>

                                </a>
                            </td>

                            <td>&nbsp; <?php echo e($customer->user_id); ?></td>
                            <td>&nbsp; <?php echo e($customer->sponser); ?></td>
                            <td><?php echo e($customer->income_wallet); ?></td>
                            <td><?php echo e($customer->register_wallet); ?></td>
                            <td><?php echo e($customer->sv_wallet); ?></td>
                            <td>
                            <?php if($customer->id_type == 1): ?>
                             <label class="btn text-info bg-soft-info font-weight-bold px-3 py-1 mb-0 fz-12">
                                Ecommerce  User
                             </label>
                            <?php elseif($customer->id_type == 2): ?>
                             <label class="btn text-warning bg-soft-warning font-weight-bold px-3 py-1 mb-0 fz-12">
                                Software User
                             </label>
                             <?php endif; ?>
                            </td>
                            <td><?php echo e(dealer_type($customer->id)); ?></td>
                            <td><?php echo e($customer->left_count); ?></td>
                            <td><?php echo e($customer->right_count); ?></td>
                            <td><?php echo e($customer->left_pv_flashable); ?></td>
                            <td><?php echo e($customer->right_pv_flashable); ?></td>

                            <td>
                                <input type="password" id="password" class="password-input" value="<?php echo e($customer->password_plain); ?>" onclick="togglePasswordVisibility(this)">
                            </td>

                            <td>
                                <div class="mb-1">
                                    <strong><a class="title-color hover-c1" href="mailto:<?php echo e($customer->email); ?>"><?php echo e($customer->email); ?></a></strong>
                                </div>
                                <a class="title-color hover-c1" href="tel:<?php echo e($customer->phone); ?>"><?php echo e($customer->phone); ?></a>
                            </td>
                            <td>
                                <label class="btn text-info bg-soft-info font-weight-bold px-3 py-1 mb-0 fz-12">
                                    <?php echo e($customer->orders->count()); ?>

                                </label>
                            </td>

                            <td>
                                <label class="switcher">
                                    <input type="checkbox" class="switcher_input"
                                           id="<?php echo e($customer['id']); ?>" <?php echo e($customer->is_active == 1?'checked':''); ?>>
                                    <span class="switcher_control"></span>
                                </label>
                            </td>

                            <td>
                                <div class="d-flex justify-content-center gap-2">
                                    <a title="<?php echo e(\App\CPU\translate('View')); ?>"
                                       class="btn btn-outline-success btn-sm square-btn"
                                       href="<?php echo e(route('admin.customer.edit',[$customer['id']])); ?>">
                                        <i class="tio-edit"></i>
                                    </a>
                                    <a title="<?php echo e(\App\CPU\translate('View')); ?>"
                                       class="btn btn-outline-info btn-sm square-btn"
                                       href="<?php echo e(route('admin.customer.view',[$customer['id']])); ?>">
                                        <i class="tio-invisible"></i>
                                    </a>

                                    <a target="_blank" title="<?php echo e(\App\CPU\translate('View')); ?>"
                                       class="btn btn-outline-info btn-sm square-btn"
                                       href="<?php echo e(route('admin.user-login',[$customer['id']])); ?>">
                                        <i class="tio-key"></i>
                                    </a>

                                    <!--<a title="<?php echo e(\App\CPU\translate('delete')); ?>"-->
                                    <!--   class="btn btn-outline-danger btn-sm delete square-btn" href="javascript:"-->
                                    <!--   onclick="form_alert('customer-<?php echo e($customer['id']); ?>','Want to delete this customer ?')">-->
                                    <!--    <i class="tio-delete"></i>-->
                                    <!--</a>-->
                                </div>
                                <form action="<?php echo e(route('admin.customer.delete',[$customer['id']])); ?>"
                                        method="post" id="customer-<?php echo e($customer['id']); ?>">
                                    <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <!-- End Table -->

            <div class="table-responsive mt-4">
                <div class="px-4 d-flex justify-content-lg-end">
                    <!-- Pagination -->
                    <?php echo $customers->links(); ?>

                </div>
            </div>

            <?php if(count($customers)==0): ?>
                <div class="text-center p-4">
                    <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg"
                         alt="Image Description">
                    <p class="mb-0"><?php echo e(\App\CPU\translate('No data to show')); ?></p>
                </div>
        <?php endif; ?>
        <!-- End Footer -->
        </div>
        <!-- End Card -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
       function togglePasswordVisibility(inputField) {
            if (inputField.type === "password") {
                inputField.type = "text";
            } else {
                inputField.type = "password";
            }
        }
    </script>

    <script>
        $(document).on('change', '.switcher_input', function () {
            let id = $(this).attr("id");

            let status = 0;
            if (jQuery(this).prop("checked") === true) {
                status = 1;
            }

            Swal.fire({
                title: '<?php echo e(\App\CPU\translate('Are you sure')); ?>?',
                text: '<?php echo e(\App\CPU\translate('want_to_change_status')); ?>',
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                cancelButtonText: 'No',
                confirmButtonText: 'Yes',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('admin.customer.status-update')); ?>",
                        method: 'POST',
                        data: {
                            id: id,
                            status: status
                        },
                        success: function () {
                            toastr.success('<?php echo e(\App\CPU\translate('Status updated successfully')); ?>');
                        }
                    });
                }
            })
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\walmart_express\resources\views/admin-views/customer/list.blade.php ENDPATH**/ ?>