

<?php $__env->startSection('title', 'Dealer Commission'); ?>

<?php $__env->startPush('css'); ?>

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-0">
            <div class="col align-self-center text-left">
                    <h5>Dealer Commission Report</h5>
                </div>
                 
                <form id="search-form" action="<?php echo e(route('member.dealer-commission')); ?>" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-primary">Search</button>
                              </div>
                        </div>
                </form>
     
                        
                        <table class="table table-dark">
                              <thead>
                                    <tr>
                                          <td>Date</td>      
                                          <td>Order ID</td>      
                                          <td>User ID</td>      
                                          <td>SV Sale</td>
                                          <td>Amount</td>
                                    </tr>
                              </thead>
                              <tbody>
                              <?php
                                    $total = 0; 
                              ?>
                              <?php $__currentLoopData = $report; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <?php
                                    $total += $item->amount; 
                              ?>
                              <?php if($item->user_id == 'admin'): ?>
                                 <?php  $username = $item->user_id;  ?>
                              <?php else: ?>
                                <?php   $username = DB::table('users')->where('id',$item->user_id)->first()->user_id;  ?>
                              <?php endif; ?>

                                    <tr>
                                    <td><?php echo e(date('h:i a d/m/Y', strtotime( $item->created_at))); ?></td>
                                    <td><a href="<?php echo e(url('member/order-detail/'.$item->order_id)); ?>" target="_blank">#<?php echo e($item->order_id); ?></td>
                                    <td><?php echo e($username); ?></td>
                                    <td><?php echo e($item->main_amount); ?></td>
                                    <td><?php echo e($item->amount); ?></td>
                                    </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </tbody>
                              <tfoot>
                                    <tr>
                                          <td></td>
                                          <td></td>
                                          <td></td>
                                          <td>Total</td>
                                          <td> <?php echo e($web_config['currency_sign']->value); ?>  <?php echo e(number_format($total,2)); ?> </td>
                                     </tr>   
                              </tfoot>
                        </table>
   
                         <?php echo e($report->appends(request()->input())->links()); ?>

               </div>
            </div>

      </div>

   <!-- main page content ends -->
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({		
                  mode: "range",
                  dateFormat: "Y-m-d",
            });	

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false; 
                        }
                  });
            });
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('member-panel.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\walmart_express\resources\views/member-panel/reports/dealer_commission.blade.php ENDPATH**/ ?>