<?php $__env->startSection('title', 'Leadership Commission'); ?>

<?php $__env->startPush('css'); ?>

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>

      <?php
      function numberToOrdinal($number) {
      if ($number % 100 >= 11 && $number % 100 <= 13) {
            return $number . 'th';
      } else {
            switch ($number % 10) {
                  case 1:
                  return $number . 'st';
                  case 2:
                  return $number . 'nd';
                  case 3:
                  return $number . 'rd';
                  default:
                  return $number . 'th';
            }
      }
      }
      ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-2">
            <div class="col align-self-center text-left">
                    <h5>Leadership Commission Report</h5>
                </div>

                <form id="search-form" action="<?php echo e(route('member.leadership-commission')); ?>" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-primary">Search</button>
                              </div>
                        </div>
                </form>


                        <table class="table ">
                              <thead>
                                    <tr>
                                          <td>Date</td>
                                          <td>From</td>
                                          <td>Generation Level</td>
                                          <td>Amount</td>
                                    </tr>
                              </thead>
                              <tbody>
                              <?php
                                    $total = 0;
                              ?>
                              <?php $__currentLoopData = $report; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <?php
                                    $total += $item->amount;
                                    $user = DB::table('users')->where('id',$item->reg_id)->first(['user_id','f_name','l_name']);
                              ?>
                                    <tr>
                                          <td><?php echo e(date('h:i a d/m/Y', strtotime( $item->created_at))); ?></td>
                                          <td><?php echo e($user->user_id); ?> <small style="font-size: 10px;">(<?php echo e($user->f_name); ?> <?php echo e($user->l_name); ?>)</small></td>
                                          <td><?php echo e(numberToOrdinal($item->gen )); ?> Generation</td>
                                          <td><?php echo e($item->amount); ?></td>
                                    </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </tbody>
                              <tfoot>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td align="right">Total</td>
                                       <td><?php echo e(number_format($total,2)); ?>  <?php echo e($web_config['currency_sign']->value); ?> </td>
                                    </tr>
                              </tfoot>
                        </table>

                         <?php echo e($report->appends(request()->input())->links()); ?>

               </div>
            </div>

      </div>

   <!-- main page content ends -->
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('member-panel.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\walmart_express\resources\views/member-panel/reports/leadership_commission.blade.php ENDPATH**/ ?>