<?php $__env->startSection('title', 'Withdraw Funds'); ?>

<?php $__env->startPush('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('public/assets/member-panel')); ?>/assets/css/toastr.css?<?php echo e(time()); ?>">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
<style>
:root {
    --primary: #6366f1;
    --primary-light: #818cf8;
    --secondary: #8b5cf6;
    --success: #10b981;
    --danger: #ef4444;
    --warning: #f59e0b;
    --info: #3b82f6;
    --light: #f8fafc;
    --dark: #1e293b;
    --gray: #64748b;
    --gray-light: #e2e8f0;
}

.withdraw-container {
    min-height: 100vh;
    padding: 2rem 0;
}

.withdraw-card {

    border-radius: 1.5rem;
    box-shadow: 0 10px 25px rgba(0,0,0,0.08);
    overflow: hidden;
    max-width: 800px;
    margin: 0 auto;
    border: none;
}

.card-header {

    padding: 2.5rem;
    text-align: center;

}

.card-header h2 {
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.card-header p {
    opacity: 0.9;
    margin-bottom: 0;
}

.balance-display {

    border-radius: 1rem;
    padding: 1.5rem;
    margin-top: 1.5rem;
    backdrop-filter: blur(10px);

}

.balance-amount {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.25rem;
}

.card-body {
    padding: 2.5rem;
}

/* Payment Method Selection */
.payment-methods {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 1rem;
    margin-bottom: 2rem;
}

.payment-option {
    position: relative;
}

.payment-option input[type="radio"] {
    position: absolute;
    opacity: 0;
}

.payment-label {
    display: flex;
    flex-direction: column;
    align-items: center;

    border: 2px solid var(--gray-light);
    border-radius: 0.75rem;
    padding: 1.5rem 1rem;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
    height: 100%;
}

.payment-label:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    border-color: var(--primary-light);
}

.payment-option input[type="radio"]:checked + .payment-label {
    border-color: var(--primary);
    background-color: rgba(99, 102, 241, 0.05);
}

.payment-image {
    width: 60px;
    height: 60px;
    object-fit: contain;
    margin-bottom: 0.75rem;
    border-radius: 0.5rem;
    background: white;
    padding: 0.5rem;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.payment-name {
    font-size: 0.9rem;
    font-weight: 600;

}

.checkmark {
    position: absolute;
    top: 0.5rem;
    right: 0.5rem;
    width: 1.5rem;
    height: 1.5rem;
    background: var(--success);

    border-radius: 50%;
    display: none;
    align-items: center;
    justify-content: center;
    font-size: 0.75rem;
}

.payment-option input[type="radio"]:checked + .payment-label .checkmark {
    display: flex;
}

/* Form Inputs */
.form-group {
    margin-bottom: 1.5rem;
}

.form-label {
    font-weight: 600;

    margin-bottom: 0.5rem;
    display: block;
}

.form-control {


    border-radius: 0.75rem;
    padding: 0.875rem 1.25rem;
    font-size: 1rem;
    transition: all 0.3s ease;

}

.form-control:focus {

    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.2);
    outline: none;
}

.input-icon {
    position: relative;
}

.input-icon i {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);

    font-size: 1.1rem;
}

.input-icon .form-control {
    padding-left: 3rem;
}

.password-toggle {
    position: absolute;
    right: 1rem;
    top: 50%;
    transform: translateY(-50%);
    cursor: pointer;

    font-size: 1.1rem;
    transition: color 0.3s ease;
}



/* Amount Breakdown */
.amount-breakdown {

    border-radius: 1rem;
    padding: 1.5rem;
    margin-bottom: 2rem;
    box-shadow: 0 2px 15px rgba(0,0,0,0.05);
}

.breakdown-title {
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 1.25rem;

    display: flex;
    align-items: center;
}

.breakdown-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 0.75rem;
    padding: 0.5rem 0;
}

.breakdown-item:last-child {
    border-top: 2px solid var(--gray-light);
    padding-top: 1rem;
    margin-top: 1rem;
    font-weight: 600;
    font-size: 1.1rem;
}

.breakdown-label {

}

.breakdown-value {
    font-weight: 600;

}

.breakdown-item:last-child .breakdown-value {

    font-size: 1.2rem;
}



.submit-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(99, 102, 241, 0.4);
}

.submit-btn:disabled {
    background: var(--gray-light);

    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}

.submit-btn i {
    margin-right: 0.5rem;
}

/* Responsive Design */
@media (max-width: 768px) {
    .withdraw-container {
        padding: 1rem;
    }

    .card-header {
        padding: 1.5rem;
    }

    .card-body {
        padding: 1.5rem;
    }

    .payment-methods {
        grid-template-columns: repeat(2, 1fr);
    }

    .balance-amount {
        font-size: 1.5rem;
    }
}

/* Animations */
@keyframes  fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.withdraw-card {
    animation: fadeInUp 0.5s ease;
}

/* Loading State */
.loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255,255,255,0.8);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

.spinner {
    width: 3rem;
    height: 3rem;
    border: 3px solid rgba(99, 102, 241, 0.2);
    border-radius: 50%;

    animation: spin 1s linear infinite;
    margin-bottom: 1rem;
}

@keyframes  spin {
    to { transform: rotate(360deg); }
}

/* Alert Styles */
.alert-info {
    background: rgba(59, 130, 246, 0.1);
    border-left: 4px solid var(--info);
    border-radius: 0.75rem;
    padding: 1rem;
    margin-bottom: 1.5rem;
}

.method-info {
    background: rgba(99, 102, 241, 0.05);
    border: 1px solid rgba(99, 102, 241, 0.1);
    border-radius: 0.75rem;
    padding: 1rem;
    margin-top: 1rem;
    display: none;
    animation: fadeInUp 0.3s ease;
}

.method-info.show {
    display: block;
}

.method-info small {

    display: block;
    margin-bottom: 0.25rem;
}

.method-info div {
    margin-bottom: 0.75rem;
}

/* Floating Labels */
.floating-label {
    position: relative;
    margin-bottom: 1.5rem;
}

.floating-label .form-control {
    height: calc(3.5rem + 2px);
    padding: 1.5rem 1rem 0.5rem;
}

.floating-label label {
    position: absolute;
    top: 1rem;
    left: 1rem;

    transition: all 0.2s;
    pointer-events: none;
}

.floating-label .form-control:focus ~ label,
.floating-label .form-control:not(:placeholder-shown) ~ label {
    top: 0.5rem;
    font-size: 0.75rem;

}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="withdraw-container">
    <div class="container card adminuiux-card shadow-sm mb-4">
        <div class="withdraw-card">
            <!-- Header -->
            <div class="card-header">
                <h2 class="mb-2">
                    <i class="bi bi-wallet2 me-2"></i>
                    Withdraw Funds
                </h2>
                <p class="mb-0">Transfer your earnings to your preferred payment method</p>

                <div class="balance-display mt-4">
                    <div class="d-flex align-items-center justify-content-center">
                        <i class="bi bi-piggy-bank me-3 fs-3"></i>
                        <div>
                            <p class="mb-1">Available Balance</p>
                            <div class="balance-amount">
                                <?php echo e(number_format(auth('customer')->user()->income_wallet, 2)); ?>

                                <span class="fs-5"><?php echo e($web_config['currency_sign']->value); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Body -->
            <div class="card-body">
                <form action="<?php echo e(url('member/withdraw-store')); ?>" method="post" enctype="multipart/form-data" id="withdrawForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="method_id" id="method_id">

                    <!-- Payment Method Selection -->
                    <div class="form-group">
                        <label class="form-label">
                            <i class="bi bi-credit-card-2-front me-2"></i>
                            Select Payment Method
                        </label>
                        <div class="payment-methods">
                            <?php $__currentLoopData = $payment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="payment-option">
                                    <input type="radio"
                                           id="method_<?php echo e($v->id); ?>"
                                           name="wallet_type"
                                           value="<?php echo e($v->id); ?>"
                                           onclick="selectPaymentMethod('<?php echo e($v->id); ?>','<?php echo e($v->method_name); ?>','<?php echo e($v->account_no); ?>','<?php echo e($v->min); ?>','<?php echo e($v->max); ?>','<?php echo e($v->comment); ?>')">
                                    <label for="method_<?php echo e($v->id); ?>" class="card bg-theme-accent-r-gradient payment-label">
                                        <img src="<?php echo e(asset('storage/app/public/brand/'. $v->image)); ?>"
                                             alt="<?php echo e($v->method_name); ?>"
                                             class="payment-image">
                                        <div class="payment-name"><?php echo e($v->method_name); ?></div>
                                        <div class="checkmark">
                                            <i class="bi bi-check-lg"></i>
                                        </div>
                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <!-- Method Info -->
                        <div class="method-info" id="methodInfo">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <small>Payment Method</small>
                                    <div id="selectedMethod" class="fw-bold text-primary">-</div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <small>Withdrawal Limits</small>
                                    <div id="selectedLimits" class="fw-bold">-</div>
                                </div>
                                <div class="col-12">
                                    <small>Instructions</small>
                                    <div id="selectedInstructions" class="small">-</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Amount Input -->
                    <div class="floating-label">
                        <input type="number"
                               name="amount"
                               id="amount"
                               class="form-control"
                               placeholder=" "
                               min="1"
                               step="0.01"
                               required>
                        <label for="amount">
                            <i class="bi bi-currency-exchange me-2"></i>
                            Withdrawal Amount
                        </label>
                        <small class="text-muted mt-1 d-block">Minimum withdrawal amount varies by payment method</small>
                    </div>

                    <!-- Account Number -->
                    <div class="floating-label">
                        <input type="text"
                               name="account_no"
                               id="account_no"
                               class="form-control"
                               placeholder=" "
                               required>
                        <label for="account_no">
                            <i class="bi bi-person-vcard me-2"></i>
                            Account/Mobile Number
                        </label>
                    </div>

                    <!-- Transaction Password -->
                    <div class="floating-label">
                        <input type="password"
                               name="trx_password"
                               id="trx_password"
                               class="form-control"
                               placeholder=" "
                               required>
                        <label for="trx_password">
                            <i class="bi bi-shield-lock me-2"></i>
                            Transaction Password
                        </label>
                        <span class="password-toggle" id="togglePassword">
                            <i class="bi bi-eye"></i>
                        </span>
                    </div>

                    <!-- Comment -->
                    <div class="form-group">
                        <label class="form-label" for="comment">
                            <i class="bi bi-chat-square-text me-2"></i>
                            Additional Notes (Optional)
                        </label>
                        <textarea name="comment"
                                  id="comment"
                                  class="form-control"
                                  rows="3"
                                  placeholder="Any special instructions or notes"></textarea>
                    </div>

                    <!-- Amount Breakdown -->
                    <div class="amount-breakdown">
                        <div class="breakdown-title">
                            <i class="bi bi-receipt me-2"></i>
                            Transaction Summary
                        </div>

                        <div class="breakdown-item">
                            <span class="breakdown-label">Withdrawal Amount:</span>
                            <span class="breakdown-value" id="entered_amount">0.00 <?php echo e($web_config['currency_sign']->value); ?></span>
                        </div>

                        <div class="breakdown-item">
                            <span class="breakdown-label">Processing Fee (<?php echo e(number_format(charges('withdraw_charge'),2)); ?>%):</span>
                            <span class="breakdown-value" id="charge_amount">0.00 <?php echo e($web_config['currency_sign']->value); ?></span>
                        </div>

                        <div class="breakdown-item">
                            <span class="breakdown-label">You Will Receive:</span>
                            <span class="breakdown-value" id="final_amount_display">0.00 <?php echo e($web_config['currency_sign']->value); ?></span>
                            <input type="hidden" name="final_amount" id="final_amount" required>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-primary btn-sm btn-block " id="submitBtn" >
                        <i class="bi bi-send-check me-2"></i>
                         Withdrawal Now
                    </button>

                    <!-- Info Alert -->
                    <div class="alert-info mt-4">
                        <div class="d-flex">
                            <i class="bi bi-info-circle-fill me-3 fs-5"></i>
                            <div>
                                <strong class="d-block mb-2">Important Information</strong>
                                <ul class="ps-3 mb-0">
                                    <li class="mb-1">Withdrawals are processed within 24-48 hours</li>
                                    <li class="mb-1">Ensure your account details are correct</li>
                                    <li class="mb-1">Processing fees are deducted from withdrawal amount</li>
                                    <li>Contact support if you encounter any issues</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div class="loading-overlay d-none" id="loadingOverlay">
    <div class="spinner"></div>
    <p class="text-primary fw-bold mt-3">Processing your withdrawal...</p>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="<?php echo e(asset('public/assets/member-panel/assets')); ?>/js/toastr.js?<?php echo e(time()); ?>"></script>
<?php echo Toastr::message(); ?>


<script>
$(document).ready(function() {
    // Initialize toastr
    toastr.options = {
        positionClass: 'toast-top-right',
        timeOut: 4000,
        closeButton: true,
        progressBar: true,
        newestOnTop: true
    };

    // Password toggle functionality
    $('#togglePassword').on('click', function() {
        const passwordField = $('#trx_password');
        const icon = $(this).find('i');

        if (passwordField.attr('type') === 'password') {
            passwordField.attr('type', 'text');
            icon.removeClass('bi-eye').addClass('bi-eye-slash');
        } else {
            passwordField.attr('type', 'password');
            icon.removeClass('bi-eye-slash').addClass('bi-eye');
        }
    });

    // Amount calculation
    $('#amount').on('input', function() {
        calculateWithdrawal();
        validateForm();
    });

    // Form validation on input
    $('input[required], textarea[required]').on('input change', function() {
        validateForm();
    });

    // Form submission
    $('#withdrawForm').on('submit', function(e) {
        const amount = parseFloat($('#amount').val()) || 0;
        const balance = <?php echo e(auth('customer')->user()->income_wallet); ?>;
        const finalAmount = parseFloat($('#final_amount').val()) || 0;
        const methodId = $('#method_id').val();

        if (!methodId) {
            e.preventDefault();
            toastr.error('Please select a payment method');
            return false;
        }

        if (amount <= 0) {
            e.preventDefault();
            toastr.error('Please enter a valid withdrawal amount');
            return false;
        }

        if (amount > balance) {
            e.preventDefault();
            toastr.error('Insufficient balance for this withdrawal');
            return false;
        }

        // Show loading overlay
        $('#loadingOverlay').removeClass('d-none');
        $('#submitBtn').prop('disabled', true).html('<i class="bi bi-hourglass-top me-2"></i>Processing...');

        return confirm(`Confirm withdrawal request of ${finalAmount.toFixed(2)} <?php echo e($web_config['currency_sign']->value); ?>?`);
    });
});

function selectPaymentMethod(id, methodName, accountNo, min, max, comment) {
    $('#method_id').val(id);

    // Show method info
    $('#selectedMethod').text(methodName);
    $('#selectedLimits').text(`${min} - ${max} <?php echo e($web_config['currency_sign']->value); ?>`);
    $('#selectedInstructions').text(comment || 'No special instructions required');
    $('#methodInfo').addClass('show');

    // Update amount field constraints
    const amountInput = $('#amount');
    amountInput.attr('min', min).attr('max', max);

    // Validate current amount against new limits
    const currentAmount = parseFloat(amountInput.val()) || 0;
    if (currentAmount > 0) {
        if (currentAmount < parseFloat(min)) {
            toastr.warning(`Minimum withdrawal for ${methodName} is ${min} <?php echo e($web_config['currency_sign']->value); ?>`);
            amountInput.val(min);
        } else if (currentAmount > parseFloat(max)) {
            toastr.warning(`Maximum withdrawal for ${methodName} is ${max} <?php echo e($web_config['currency_sign']->value); ?>`);
            amountInput.val(max);
        }
        calculateWithdrawal();
    }

    validateForm();
    toastr.success(`${methodName} selected`);
}

function calculateWithdrawal() {
    const amount = parseFloat($('#amount').val()) || 0;
    const chargeRate = <?php echo e(charges('withdraw_charge')); ?>;
    const chargeAmount = (amount * chargeRate) / 100;
    const finalAmount = amount - chargeAmount;

    $('#entered_amount').text(`${amount.toFixed(2)} <?php echo e($web_config['currency_sign']->value); ?>`);
    $('#charge_amount').text(`${chargeAmount.toFixed(2)} <?php echo e($web_config['currency_sign']->value); ?>`);
    $('#final_amount_display').text(`${finalAmount.toFixed(2)} <?php echo e($web_config['currency_sign']->value); ?>`);
    $('#final_amount').val(finalAmount.toFixed(2));
}

function validateForm() {
    const methodSelected = $('#method_id').val() !== '';
    const amount = parseFloat($('#amount').val()) || 0;
    const accountNo = $('#account_no').val().trim();
    const trxPassword = $('#trx_password').val().trim();
    const balance = <?php echo e(auth('customer')->user()->income_wallet); ?>;
    const minAmount = parseFloat($('#amount').attr('min')) || 1;

    let isValid = methodSelected &&
                 amount >= minAmount &&
                 amount <= balance &&
                 accountNo.length > 0 &&
                 trxPassword.length > 0;

    // Additional validation for maximum amount if set
    const maxAmount = parseFloat($('#amount').attr('max'));
    if (maxAmount && amount > maxAmount) {
        isValid = false;
    }

 //   $('#submitBtn').prop('disabled', !isValid);
}

// Initialize form validation
validateForm();
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('member-panel.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\walmart_express\resources\views/member-panel/withdraw/withdraw.blade.php ENDPATH**/ ?>