<?php $__env->startSection('title', 'Cash In'); ?>

<?php $__env->startPush('css'); ?>

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-2">
               <div class="col align-self-center text-left">
                    <h5>Cash In Report</h5>
                </div>

                <form id="search-form" action="<?php echo e(route('member.cashin-list')); ?>" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-sm btn-primary">Search</button>
                              </div>  <div class="col">
                                    <a href="<?php echo e(route('member.cashin')); ?>" class="btn btn-sm btn-success"><i class="fa fa-plus"></i> Cash IN</a>
                              </div>
                        </div>
                </form>


                <table class="table  table-responsive table-responsive-sm table-responsive-md">
                        <thead>
                        <tr>
                            <th>SL</th>
                            <th>Time & Date</th>
                            <th>Payment Method</th>
                            <th>Amount</th>
                            <th>Transaction ID</th>
                            <th>Upload Document</th>
                            <th>Comment</th>
                            <th>Status</th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php
                                $total = 0;
                            ?>
                            <?php $__currentLoopData = $report; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $user  = DB::table('users')->where('id', $banner->user_id)->first();
                            $total = $total + $banner->amount;
                            ?>
                                <tr>
                                    <th scope="row"><?php echo e($key+1); ?></th>
                                    <td><?php echo e(date('h:i:s a d M Y ', strtotime($banner->created_at))); ?></td>

                                    <td>
                                       <img style="max-height: 20px;max-width: 100px;" src="<?php echo e(asset('storage/app/public/brand/'. payment_method_name($banner->method_id)->image )); ?>" alt="" class="label-image" >
                                    </td>

                                    <td><?php echo e($banner->amount); ?></td>
                                    <td><?php echo e($banner->trx_id); ?></td>
                                    <td> <a download href="<?php echo e(asset('storage/app/public/brand/'. $banner->image )); ?>"> <img style="max-height: 40px;" src="<?php echo e(asset('storage/app/public/brand/'. $banner->image )); ?>" alt="" class="label-image" ></a></td>
                                    <td><?php echo e($banner->comment); ?></td>

                                    <?php if($banner->status == 0): ?>
                                          <td><button class="btn btn-danger btn-sm">Pending</button></td>
                                    <?php elseif($banner->status== 1): ?>
                                          <td><button class="btn btn-success btn-sm">Paid</button></td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td>  </td>
                                    <td>  </td>
                                    <td>  Total</td>
                                    <td><?php echo e($web_config['currency_sign']->value); ?> <?php echo e(number_format($total,2)); ?></td>
                                    <td>  </td>
                                    <td>  </td>
                                    <td>  </td>
                                    <td>  </td>
                                </tr>
                            </tfoot>
                </table>

                         <?php echo e($report->appends(request()->input())->links()); ?>

               </div>
            </div>

      </div>

   <!-- main page content ends -->
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('member-panel.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\walmart_express\resources\views/member-panel/cashin/list.blade.php ENDPATH**/ ?>