<?php $__env->startSection('title', \App\CPU\translate('Cash In Approval')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 d-flex gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/brand.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('Cash In Approval ')); ?> 
                <span class="badge badge-soft-dark radius-50 fz-14"><?php echo e($report->total()); ?></span>
            </h2>
        </div>
        <!-- End Page Title -->

        <div class="row mt-20">
            <div class="col-md-12">
                <div class="card">
                    <!-- Data Table Top -->
                    <div class="px-3 py-4">
                        <div class="row g-2 flex-grow-1">
                            <div class="col-sm-8 col-md-6 col-lg-4">
                                <!-- Search -->
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <div class="input-group input-group-custom input-group-merge">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <input id="datatableSearch_" type="search" name="search" class="form-control"
                                            placeholder="<?php echo e(\App\CPU\translate('Search_by_Transaction ID')); ?>" aria-label="Search by ID or name" value="<?php echo e($search); ?>" required>
                                        <button type="submit" class="btn btn--primary input-group-text"><?php echo e(\App\CPU\translate('Search')); ?></button>
                                    </div>
                                </form>

                                <!-- End Search -->
                            </div>
                            <div class="col-sm-4 col-md-6 col-lg-8 d-flex justify-content-end">

                                <!-- <button type="button" class="btn btn-outline--primary" data-toggle="dropdown">
                                    <i class="tio-download-to"></i>
                                    <?php echo e(\App\CPU\translate('export')); ?>

                                    <i class="tio-chevron-down"></i>
                                </button> -->

                                <ul class="dropdown-menu">
                                    <!-- <li><a class="dropdown-item" href="<?php echo e(route('admin.brand.export')); ?>">Excel</a></li> -->
                                </ul>

                            </div>
                        </div>
                        <!-- End Row -->
                    </div>
                    <!-- End Data Table Top -->

                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                                class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                                <thead class="thead-light thead-50 text-capitalize">
                                    <tr>
                                        <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Time & Date')); ?></th>
                                      
                                        <th><?php echo e(\App\CPU\translate('Payment Method')); ?></th>
                                          <th><?php echo e(\App\CPU\translate('UserID')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Amount')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Transaction ID')); ?></th>
                                        <th class="text-center"><?php echo e(\App\CPU\translate('Upload Document')); ?></th>
                                        <th class="text-center"> <?php echo e(\App\CPU\translate('Comment')); ?></th>
                                        <th class="text-center"> <?php echo e(\App\CPU\translate('Status')); ?></th>
                                        <th class="text-center"> <?php echo e(\App\CPU\translate('Action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php
                                $total = 0;
                            ?>
                            <?php $__currentLoopData = $report; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $user  = DB::table('users')->where('id', $banner->user_id)->first(); 
                            $total = $total + $banner->amount;
                            ?>
                                <tr>
                                    <th scope="row"><?php echo e($key+1); ?></th>
                                    <td><?php echo e(date('h:i:s a d M Y ', strtotime($banner->created_at))); ?></td>
                                    <td>
                                       <img style="max-height: 20px;max-width: 100px;" src="<?php echo e(asset('storage/app/public/brand/'. payment_method_name($banner->method_id)->image )); ?>" alt="" class="label-image" >
                                    </td>
                                    <td><?php echo e($user->user_id); ?></td>
                                    <td><?php echo e($banner->amount); ?></td>
                                    <td><?php echo e($banner->trx_id); ?></td>
                                    <td> <a download href="<?php echo e(asset('storage/app/public/brand/'. $banner->image )); ?>"> <img style="max-height: 40px;" src="<?php echo e(asset('storage/app/public/brand/'. $banner->image )); ?>" alt="" class="label-image" ></a></td>
                                    <td><?php echo e($banner->comment); ?></td>

                                    <?php if($banner->status == 0): ?>
                                          <td><button class="btn btn-danger btn-sm">Pending</button></td>
                                    <?php elseif($banner->status== 1): ?>
                                          <td><button class="btn btn-success btn-sm">Paid</button></td>
                                    <?php endif; ?>
                                    <td>
                                    <?php if($banner->status == 0): ?>
                                            <div class="d-flex justify-content-center gap-2">
                                                <a class="btn btn-outline-info btn-sm square-btn" title="<?php echo e(\App\CPU\translate('Edit')); ?>"
                                                href="<?php echo e(route('admin.business-settings.cashin-approve.status-update',[$banner->id])); ?>">
                                                <i class="tio-checkmark-circle"></i>
                                                </a>
                                            </div>
                                    <?php elseif($banner->status== 1): ?>
                                         <button class="btn btn-success btn-sm">Apporved</button>
                                    <?php endif; ?>
                                        
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="table-responsive mt-4">
                        <div class="d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            <?php echo e($report->links()); ?>

                        </div>
                    </div>
                    <?php if(count($report)==0): ?>
                        <div class="text-center p-4">
                            <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                            <p class="mb-0"><?php echo e(\App\CPU\translate('No_data_to_show')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).on('click', '.delete', function () {
            var id = $(this).attr("id");
            Swal.fire({
                title: '<?php echo e(\App\CPU\translate('Are_you_sure_delete_this_brand')); ?>?',
                text: "<?php echo e(\App\CPU\translate('You_will_not_be_able_to_revert_this')); ?>!",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '<?php echo e(\App\CPU\translate('Yes')); ?>, <?php echo e(\App\CPU\translate('delete_it')); ?>!',
                cancelButtonText: "<?php echo e(\App\CPU\translate('cancel')); ?>",
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('admin.brand.delete')); ?>",
                        method: 'POST',
                        data: {id: id},
                        success: function () {
                            toastr.success('<?php echo e(\App\CPU\translate('Brand_deleted_successfully')); ?>');
                            location.reload();
                        }
                    });
                }
            })
        });

        $(document).on('change', '.status', function () {
            var id = $(this).attr("id");
            if ($(this).prop("checked") == true) {
                var status = 1;
            } else if ($(this).prop("checked") == false) {
                var status = 0;
            }
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({ 
                url: "<?php echo e(route('admin.business-settings.payment-method.status-update')); ?>",
                method: 'POST',
                data: {
                    id: id,
                    status: status
                },
                success: function (data) {
                    console.log(data)
                    if (data.success == true) {
                        toastr.success('<?php echo e(\App\CPU\translate('Status updated successfully')); ?>');
                    } else {
                        toastr.error('<?php echo e(\App\CPU\translate('Status updated failed. Gateway must be approved')); ?>');
                        location.reload();
                    }
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\walmart_express\resources\views/admin-views/cashin-approve/cashin_list.blade.php ENDPATH**/ ?>