<?php $__env->startSection('title', 'Orders List'); ?>

<?php $__env->startPush('css'); ?>

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-2">
            <div class="col align-self-center text-left">
                    <h5>Orders List Report</h5>
                </div>

                <form id="search-form" action="<?php echo e(route('member.orders')); ?>" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-primary">Search</button>
                              </div>
                        </div>
                </form>

             <div class="table-responsive">
                        <table class="table ">
                              <thead>
                                    <tr>
                                          <td>Date</td>
                                          <td>Invoice ID </td>
                                          <td>Purchase From</td>
                                          <td>Order Amount</td>
                                          <td>Payment Status</td>
                                          <td>Delivery Status</td>
                                    </tr>
                              </thead>
                              <tbody>
                              <?php
                                    $total = 0;
                              ?>
                              <?php $__currentLoopData = $report; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <?php
                                    $total += $item->order_amount;
                              ?>

                              <?php if($item->seller_id == 'admin'): ?>
                                 <?php  $sellername = $item->seller_id;  ?>
                              <?php else: ?>
                                <?php   $sellername = DB::table('users')->where('id',$item->seller_id)->first()->user_id;  ?>
                              <?php endif; ?>
                                    <tr>
                                          <td><?php echo e(date('h:i a d/m/Y', strtotime( $item->created_at))); ?></td>
                                          <td><a href="<?php echo e(url('member/order-detail/'.$item->id)); ?>" target="_blank">#<?php echo e($item->id); ?></td>
                                          <td><?php echo e($sellername); ?></td>
                                          <td><?php echo e(number_format($item->order_amount,2)); ?></td>
                                          <?php if(  $item->payment_status  == 'paid'): ?>
                                                 <td> <button class="btn btn-success btn-sm"><?php echo e($item->payment_status); ?></button>  </td>
                                          <?php else: ?>
                                                 <td> <button class="btn btn-danger btn-sm"><?php echo e($item->payment_status); ?></button>  </td>
                                          <?php endif; ?>

                                          <?php if(  $item->order_status  == 'pending'): ?>
                                                 <td> <button class="btn btn-danger btn-sm"><?php echo e($item->order_status); ?></button>  </td>
                                          <?php else: ?>
                                                <td> <button class="btn btn-success btn-sm"><?php echo e($item->order_status); ?></button>  </td>
                                          <?php endif; ?>


                                    </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </tbody>
                              <tfoot>
                                    <tr>
                                          <td></td>
                                          <td></td>
                                          <td>Total</td>
                                          <td><?php echo e($web_config['currency_sign']->value); ?>  <?php echo e(number_format($total,2)); ?>  </td>
                                          <td></td>
                                          <td></td>
                                    </tr>
                              </tfoot>
                        </table>

                         <?php echo e($report->appends(request()->input())->links()); ?>

               </div>
                </div>
            </div>

      </div>

   <!-- main page content ends -->
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('member-panel.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\walmart_express\resources\views/member-panel/order/orders.blade.php ENDPATH**/ ?>