<?php $__env->startSection('title', 'Investment Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="card shadow">
        <div class="card-header bg-dark text-white">
            <h5 class="mb-0">Investment Report</h5>
        </div>
        <div class="card-body table-responsive">
           <table class="table table-bordered table-striped text-center">
                <thead   head class="bg-primary text-white">
                    <tr>
                        <th>SL</th>
                        <th>Package</th>
                        <th>Amount</th>
                        <th>Duration</th>
                        <th>Return Count</th>
                        <th>Total Return</th>
                        <th>Start Date</th>
                        <th>Next Profit</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $invest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $startDate = \Carbon\Carbon::parse($invest->updated_at);
                        $endTimeJS = $startDate->format('Y-m-d H:i:s');

                        // Correct query: single 'type' filter, not whereIn
                        $history = DB::table('invest_return_history')
                                    ->where('userid', $invest->userid)
                                    ->where('type', $invest->id)
                                    ->select('type', DB::raw('SUM(amount) as total_return'))
                                    ->groupBy('type')
                                    ->pluck('total_return', 'type');

                                // Get sum for current invest id or 0 if not found
                                $totalReturn = $history[$invest->id] ?? 0;
                            ?>
                            <tr>
                                <td><?php echo e($key + 1); ?></td>
                                <td><?php echo e($invest->title); ?></td>
                                <td>৳<?php echo e(number_format($invest->pack_amount)); ?></td>
                                <td><?php echo e($invest->duration); ?> months</td>
                                <td><?php echo e($invest->return_count); ?></td>
                                <td>৳<?php echo e(number_format($totalReturn, 2)); ?></td>
                                <td><?php echo e($startDate->format('d M Y h:i A')); ?></td>
                                <td><span class="countdown" data-end="<?php echo e($endTimeJS); ?>"></span></td>
                                <td>
                                    <?php if($invest->status == 0): ?>
                                        <span class="badge bg-success">Running</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Completed</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php if($investments->isEmpty()): ?>
                        <tr><td colspan="9">No investments found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>


<script>
    function updateCountdowns() {
        document.querySelectorAll('.countdown').forEach(function (el) {
            const end = new Date(el.getAttribute('data-end'));
            const now = new Date();
            const diff = end - now;

            if (diff <= 0) {
                el.innerText = '00d 00h 00m 00s';
                return;
            }

            const totalSeconds = Math.floor(diff / 1000);
            const days = Math.floor(totalSeconds / (60 * 60 * 24));
            const hours = Math.floor((totalSeconds % (60 * 60 * 24)) / 3600);
            const minutes = Math.floor((totalSeconds % 3600) / 60);
            const seconds = totalSeconds % 60;

            el.innerText = `${days}d ${String(hours).padStart(2, '0')}h ${String(minutes).padStart(2, '0')}m ${String(seconds).padStart(2, '0')}s`;
        });
    }

    // Initial call + every 1 second
    updateCountdowns();
    setInterval(updateCountdowns, 1000);
</script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('member-panel.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\walmart_express\resources\views/member-panel/system/investment_report.blade.php ENDPATH**/ ?>