<?php $__env->startSection('title', 'Product Stock Report'); ?>

<?php $__env->startPush('css'); ?>

<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
<style>
      #search-form {
        text-align: right;
      }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

   <!-- main page content -->
   <div class="main-container container">

      <div class="row mb-4">
            <div class="col-12 px-2">
            <div class="col align-self-center text-left">
                    <h5>Product Stock Report </h5>
                </div>

                <form id="search-form" action="<?php echo e(route('member.stock')); ?>" method="GET" class="mb-3">
                        <div class="row">
                              <div class="col">
                                    <input type="date" required name="date_range" id="date-range" class="form-control datepicker" placeholder="Select From Date To Date">
                              </div>
                              <!-- <div class="col">
                              <input type="text" name="search" class="form-control" placeholder="Search by user or date">
                              </div> -->
                              <div class="col">
                                    <button type="submit" class="btn btn-primary">Search</button>
                              </div>
                        </div>
                </form>


                        <table class="table ">
                              <thead>
                                    <tr>
                                          <td align="center">SL</td>
                                          <td align="left">Product Name</td>
                                          <td align="left">Stock</td>
                                          <td align="center">SV</td>
                                          <td align="center">Price</td>

                                    </tr>
                              </thead>
                              <tbody>
                              <?php
                                    $total = 0;
                              ?>
                              <?php $__currentLoopData = $report; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <?php
                                    $total += $v->qty;
                              ?>
                                    <tr>
                                          <td align="center" class="serial"><?php echo e($v->id); ?></td>
                                          <td align="left" style="color:#0909EC;">
                                                 <img style="max-height: 30px;" src="<?php echo e(asset('storage/app/public/product/thumbnail/'.$v->thumbnail )); ?>" /> <?php echo e($v->name); ?>

                                          </td>
                                          <td align="center" ><?php echo e($v->qty); ?> </td>
                                          <td align="center" ><?php echo e($v->sv_point); ?></td>
                                          <td align="center"><?php echo e($v->unit_price); ?></td>

                                    </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </tbody>
                              <tfoot>
                                    <tr>
                                          <td colspan="2" align="right">Total  </td>
                                          <td align="center"><?php echo e($total); ?></td>
                                          <td class="text-left"></td>
                                          <td class="text-left"></td>
                                    </tr>
                              </tfoot>
                        </table>

                         <?php echo e($report->appends(request()->input())->links()); ?>

               </div>
            </div>

      </div>

   <!-- main page content ends -->
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script> -->
      <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
      <script>
            $(".datepicker").flatpickr({
                  mode: "range",
                  dateFormat: "Y-m-d",
            });

            $(document).ready(function() {
                  $("#search-form").submit(function() {
                        var dateRangeValue = $("#date-range").val().trim();
                        if (dateRangeValue === "") {
                        alert("Please select a date range.");
                        return false;
                        }
                  });
            });
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('member-panel.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\walmart_express\resources\views/member-panel/order/stock.blade.php ENDPATH**/ ?>